/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapDisplayRankModeMenu;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapGraphHelper;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPopulationDataCreater;
import cgdp.recog.taxonomy.map.TaxMapPopulationDataExportItem;
import cgdp.recog.taxonomy.map.TaxMapShowGraphDataListItem;
import cgdp.recog.taxonomy.map.TaxMapShowHigherRankItem;
import cgdp.recog.taxonomy.map.TaxMapShowUnassignedGeneItem;
import cgdp.recog.taxonomy.map.TaxMapViewDialog;
import cgdp.recog.taxonomy.map.TaxMapViewHandler;
import cgdp.recog.taxonomy.map.TopNRankDisplayPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;

class TaxMapPopulationPanel
extends JPanel
implements ActionListener,
ApplicationObserver,
ChartMouseListener,
TaxMapViewHandler {
    private static final String VIEW_COMMAND = "VIEW";
    private static final String SHOW_LABEL_COMMAND = "SHOWLABEL";
    private static final String TITLE = "Gene Population";
    private Frame parent;
    private MediatorImpl mediator;
    private TaxMapModel taxMapModel;
    private JLabel titleLabel;
    private ChartPanel chartPanel;
    private JCheckBoxMenuItem showLabelItem;
    private TaxMapShowUnassignedGeneItem showUnassignedItem;
    private TaxMapShowHigherRankItem showHigherRankItem;
    private TopNRankDisplayPanel topNRankDisplayPanel;
    private boolean showView = true;
    private TaxMapViewDialog view;
    private TaxMapDisplayRankModeMenu taxMapDisplayRankModeMenu;
    private TaxMapPopulationDataExportItem taxMapPopulationDataExportItem;

    TaxMapPopulationPanel(Frame frame, MediatorImpl mediatorImpl) {
        this(frame, mediatorImpl, true);
    }

    private TaxMapPopulationPanel(Frame frame, MediatorImpl mediatorImpl, boolean bl) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.showView = bl;
        this.createComponents();
    }

    private void createComponents() {
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(TaxMapModel.TITLE_FONT);
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.addChartMouseListener(this);
        this.chartPanel.setPreferredSize(new Dimension(250, 170));
        this.topNRankDisplayPanel = new TopNRankDisplayPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.topNRankDisplayPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.chartPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPopupMenu createPopupMenu(ChartPanel chartPanel) {
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        this.showLabelItem = new JCheckBoxMenuItem("Show Label");
        this.showLabelItem.setActionCommand(SHOW_LABEL_COMMAND);
        this.showLabelItem.addActionListener(this);
        this.showLabelItem.setSelected(true);
        jPopupMenu.add(this.showLabelItem);
        this.showUnassignedItem = new TaxMapShowUnassignedGeneItem(this);
        this.showUnassignedItem.setSelected(true);
        jPopupMenu.add(this.showUnassignedItem);
        this.showHigherRankItem = new TaxMapShowHigherRankItem(this);
        this.showHigherRankItem.setSelected(true);
        jPopupMenu.add(this.showHigherRankItem);
        this.taxMapDisplayRankModeMenu = new TaxMapDisplayRankModeMenu();
        jPopupMenu.add(this.taxMapDisplayRankModeMenu);
        jPopupMenu.addSeparator();
        Dataset dataset = TaxMapFacade.createGenePopulationDataset(this.taxMapModel);
        TaxMapShowGraphDataListItem taxMapShowGraphDataListItem = new TaxMapShowGraphDataListItem(this, this.taxMapModel, dataset, "Gene population graph data list");
        jPopupMenu.add(taxMapShowGraphDataListItem);
        jPopupMenu.addSeparator();
        this.taxMapPopulationDataExportItem = new TaxMapPopulationDataExportItem(this, this.parent);
        jPopupMenu.add(this.taxMapPopulationDataExportItem);
        JMenuItem jMenuItem = new JMenuItem("Save Image...");
        jMenuItem.setActionCommand("SAVE");
        jMenuItem.addActionListener(chartPanel);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print...");
        jMenuItem2.setActionCommand("PRINT");
        jMenuItem2.addActionListener(chartPanel);
        jPopupMenu.add(jMenuItem2);
        if (this.isShowView()) {
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem("Show in another window...");
            jMenuItem3.setActionCommand(VIEW_COMMAND);
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
        }
        this.taxMapDisplayRankModeMenu.setTaxMapModel(this.taxMapModel);
        this.taxMapPopulationDataExportItem.setTaxMapModel(this.taxMapModel);
        this.showUnassignedItem.setTaxMapModel(this.taxMapModel);
        this.showHigherRankItem.setTaxMapModel(this.taxMapModel);
        return jPopupMenu;
    }

    void setTaxMapModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    private PiePlot getPiePlot() {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        return piePlot;
    }

    public void updateValue() {
        this.titleLabel.setText(this.taxMapModel.getGraphTitle());
        TaxMapPopulationDataCreater taxMapPopulationDataCreater = new TaxMapPopulationDataCreater(this.taxMapModel);
        PieDataset pieDataset = taxMapPopulationDataCreater.createPieDataset();
        JFreeChart jFreeChart = this.createChart(pieDataset);
        this.chartPanel.setChart(jFreeChart);
        this.topNRankDisplayPanel.updateValue(this.taxMapModel);
        this.chartPanel.setPopupMenu(this.createPopupMenu(this.chartPanel));
        this.showLabelItem.setSelected(this.taxMapModel.isShowLabelPopulation());
        this.showUnassignedItem.setSelected(this.taxMapModel.isShowUnassigned());
        this.showHigherRankItem.setSelected(this.taxMapModel.isShowHigherRank());
    }

    private JFreeChart createChart(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart(null, pieDataset, false, true, false);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setBackgroundPaint(Color.white);
        piePlot.setSimpleLabels(true);
        this.updateLabel(piePlot);
        return jFreeChart;
    }

    private void updateLabel(PiePlot piePlot) {
        if (this.taxMapModel.isShowLabelPopulation()) {
            piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        } else {
            piePlot.setLabelGenerator(null);
        }
    }

    public void update(Observable observable, Object object) {
        ApplicationObserverEvent applicationObserverEvent = (ApplicationObserverEvent)object;
        if (applicationObserverEvent.getSource() == this) {
            return;
        }
        if (applicationObserverEvent instanceof RankChangeEvent) {
            this.updateValue();
        }
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
        if (!(chartMouseEvent.getEntity() instanceof PieSectionEntity)) {
            return;
        }
        PieSectionEntity pieSectionEntity = (PieSectionEntity)chartMouseEvent.getEntity();
        String string = (String)((Object)pieSectionEntity.getSectionKey());
        string = this.taxMapModel.getOrganismCodeByName(string);
        TaxMapGraphHelper taxMapGraphHelper = new TaxMapGraphHelper(this, this.mediator);
        taxMapGraphHelper.setTaxMapModel(this.taxMapModel);
        taxMapGraphHelper.clickRankName(string);
    }

    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        } else if (actionEvent.getActionCommand().equals(VIEW_COMMAND)) {
            TaxMapViewDialog taxMapViewDialog = this.getView();
            if (taxMapViewDialog == null) {
                this.setView(this.createView());
                taxMapViewDialog = this.getView();
            }
            taxMapViewDialog.setVisible(true);
        } else if (actionEvent.getActionCommand().equals(SHOW_LABEL_COMMAND)) {
            boolean bl = !this.taxMapModel.isShowLabelPopulation();
            this.taxMapModel.setShowLabelPopulation(bl);
            this.updateLabel(this.getPiePlot());
            this.repaint();
        }
    }

    public TaxMapViewDialog createView() {
        TaxMapPopulationPanel taxMapPopulationPanel = new TaxMapPopulationPanel(this.parent, this.mediator, false);
        taxMapPopulationPanel.setTaxMapModel(this.taxMapModel);
        taxMapPopulationPanel.updateValue();
        taxMapPopulationPanel.setPreferredSize(new Dimension(400, 450));
        TaxMapViewDialog taxMapViewDialog = new TaxMapViewDialog(this.parent, TITLE, taxMapPopulationPanel, this.taxMapModel, this);
        return taxMapViewDialog;
    }

    public void disposeView() {
        if (this.view == null) {
            return;
        }
        this.view.dispose();
        this.view.setVisible(false);
        this.view = null;
    }

    public TaxMapViewDialog getView() {
        return this.view;
    }

    public boolean isShowView() {
        return this.showView;
    }

    public void setView(TaxMapViewDialog taxMapViewDialog) {
        this.view = taxMapViewDialog;
    }
}

