/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.gene.GeneSetAddItem;
import cgdp.recog.system.OS;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapDisplayModeItem;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapFilterItem;
import cgdp.recog.taxonomy.map.TaxMapFilterScoreItem;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapShowAllNodeItem;
import cgdp.recog.taxonomy.map.TaxMapShowMappingNodeItem;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.taxonomy.map.TaxMapViewDialog;
import cgdp.recog.taxonomy.map.TaxMapViewHandler;
import cgdp.recog.taxonomy.map.TaxTreeRenderer;
import cgdp.recog.taxonomy.map.TaxTreeStructureChangeEvent;
import cgdp.recog.util.AbstractPrintExecuter;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ImageUtil;
import cgdp.recog.util.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

class TaxTreePanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
ApplicationObserver,
TaxMapViewHandler {
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private static final String TITLE = "Taxonomy Tree";
    private static final String VIEW_COMMAND = "VIEW";
    private static final String SAVE_COMMAND = "SAVE";
    private static final String PRINT_COMMAND = "PRINT";
    private Component parent;
    private MediatorImpl mediator;
    private TaxTreeRenderer taxTreeRenderer;
    private TaxMapModel taxMapModel;
    private boolean showView = true;
    private TaxMapViewDialog view;

    TaxTreePanel(Component component, MediatorImpl mediatorImpl, TaxMapModel taxMapModel) {
        this(component, mediatorImpl, taxMapModel, true);
    }

    private TaxTreePanel(Component component, MediatorImpl mediatorImpl, TaxMapModel taxMapModel, boolean bl) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.taxMapModel = taxMapModel;
        this.showView = bl;
        this.taxTreeRenderer = new TaxTreeRenderer(this.taxMapModel);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTipText("");
    }

    void setTaxMapModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    private void setParent(Component component) {
        this.parent = component;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.taxTreeRenderer.draw((Graphics2D)graphics);
        this.taxTreeRenderer.drawSelectArea((Graphics2D)graphics);
        double d = this.taxTreeRenderer.getWidth();
        double d2 = this.taxTreeRenderer.getHeight();
        this.setPreferredSize(new Dimension((int)d, (int)d2));
        this.revalidate();
    }

    private void showPopup(Point point) {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new TaxMapShowAllNodeItem(this, this.taxMapModel));
        jPopupMenu.add(new TaxMapShowMappingNodeItem(this, this.taxMapModel));
        jPopupMenu.add(new TaxMapFilterScoreItem(this, this.parent, this.taxMapModel));
        jPopupMenu.addSeparator();
        TaxMapDisplayModeItem taxMapDisplayModeItem = new TaxMapDisplayModeItem(this, this.taxMapModel, "Action Mode", 1);
        TaxMapDisplayModeItem taxMapDisplayModeItem2 = new TaxMapDisplayModeItem(this, this.taxMapModel, "View Mode", 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(taxMapDisplayModeItem);
        buttonGroup.add(taxMapDisplayModeItem2);
        taxMapDisplayModeItem.setSelected(this.taxMapModel.isActionMode());
        taxMapDisplayModeItem2.setSelected(this.taxMapModel.isViewMode());
        jPopupMenu.add(taxMapDisplayModeItem);
        jPopupMenu.add(taxMapDisplayModeItem2);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Save...");
        jMenuItem.setActionCommand(SAVE_COMMAND);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print...");
        jMenuItem2.setActionCommand(PRINT_COMMAND);
        jMenuItem2.addActionListener(this);
        jPopupMenu.add(jMenuItem2);
        List list = this.taxMapModel.getSelectedTaxMapInfoList();
        if (!CollectionUtil.isNull(list)) {
            jPopupMenu.addSeparator();
            object = TaxMapUtil.createGeneInfoList(list);
            jPopupMenu.add(new GeneSetAddItem(this, this.mediator, this.parent, "Register gene set...", (List)object));
            jPopupMenu.add(new TaxMapFilterItem(this, this.mediator, (List)object));
        }
        if (this.isShowView()) {
            jPopupMenu.addSeparator();
            object = new JMenuItem("Show in another window...");
            ((AbstractButton)object).setActionCommand(VIEW_COMMAND);
            ((AbstractButton)object).addActionListener(this);
            jPopupMenu.add((JMenuItem)object);
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    private TaxonomyTreeNode updateSelectedNode(Point point) {
        if (!this.taxMapModel.containsRankArea(point)) {
            this.taxMapModel.setSelectNode(null);
            RankChangeEvent rankChangeEvent = new RankChangeEvent(this);
            this.taxMapModel.nodifyObservers(rankChangeEvent);
            return null;
        }
        TaxonomyTreeNode taxonomyTreeNode = this.taxMapModel.getTaxonomyTreeNode(point);
        this.taxMapModel.setSelectNode(taxonomyTreeNode);
        RankChangeEvent rankChangeEvent = new RankChangeEvent(this);
        this.taxMapModel.nodifyObservers(rankChangeEvent);
        return taxonomyTreeNode;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.taxMapModel.containsRankArea(mouseEvent.getPoint())) {
            return null;
        }
        TaxonomyTreeNode taxonomyTreeNode = this.taxMapModel.getTaxonomyTreeNode(mouseEvent.getPoint());
        if (this.taxMapModel.isModeGeneCountLower() || this.taxMapModel.isModeGeneCountUpper()) {
            return this.getTooltipStringForGeneCount(taxonomyTreeNode);
        }
        return this.getToolTipStringForScore(taxonomyTreeNode);
    }

    private String getTooltipStringForGeneCount(TaxonomyTreeNode taxonomyTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append(taxonomyTreeNode.getName());
        stringBuffer.append("<BR>");
        stringBuffer.append("Gene Count: " + MathUtil.roundDecimal(this.taxMapModel.getScore(taxonomyTreeNode), 3));
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    private String getToolTipStringForScore(TaxonomyTreeNode taxonomyTreeNode) {
        if (TaxMapModel.isNoHitsCode(TaxMapModel.getKeyName(taxonomyTreeNode))) {
            return this.getTooltipStringForGeneCount(taxonomyTreeNode);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append(taxonomyTreeNode.getName());
        stringBuffer.append("<BR>");
        stringBuffer.append("Total Score: " + this.taxMapModel.getTotalScore(taxonomyTreeNode));
        stringBuffer.append("<BR>");
        stringBuffer.append("Score: " + this.taxMapModel.getScore(taxonomyTreeNode));
        stringBuffer.append("<BR>");
        stringBuffer.append("Score(from child): " + this.taxMapModel.getChildScore(taxonomyTreeNode));
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Collection collection;
        if (mouseEvent.getClickCount() == 1) {
            this.updateSelectedNode(mouseEvent.getPoint());
            collection = this.taxMapModel.getSelectedTaxMapInfoList();
            if (!CollectionUtil.isNull(collection)) {
                if (this.taxMapModel.isSyncPPMFilter()) {
                    object = TaxMapUtil.createGeneInfoList(collection);
                    this.mediator.setTaxMapFilter((List)object);
                }
                if (this.taxMapModel.isSyncPPMSelect()) {
                    TaxMapFacade.selectClusterOnPPM(collection, this.mediator);
                }
            }
        }
        if (mouseEvent.getClickCount() == 2) {
            collection = this.taxMapModel.getTaxonomyTreeNodeSetOnTreeIcon(mouseEvent.getPoint());
            for (DisplayTaxonomyTreeNode displayTaxonomyTreeNode : collection) {
                displayTaxonomyTreeNode.flipVisibledChild();
                if (!displayTaxonomyTreeNode.isVisibledChild()) continue;
                displayTaxonomyTreeNode.setVisibled(true);
                Enumeration<TreeNode> enumeration = displayTaxonomyTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DisplayTaxonomyTreeNode displayTaxonomyTreeNode2 = (DisplayTaxonomyTreeNode)enumeration.nextElement();
                    displayTaxonomyTreeNode2.setVisibled(true);
                    if (!displayTaxonomyTreeNode2.isLeaf()) continue;
                    displayTaxonomyTreeNode2.setVisibledChild(true);
                }
            }
            object = this.taxMapModel.getSelectNode();
            if (object != null && object instanceof DisplayTaxonomyTreeNode) {
                ((DisplayTaxonomyTreeNode)object).flipVisibled();
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.taxMapModel.containsRankArea(mouseEvent.getPoint()) || this.taxMapModel.containsTreeIcon(mouseEvent.getPoint())) {
            this.setCursor(HAND_CURSOR);
        } else {
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void update(Observable observable, Object object) {
        ApplicationObserverEvent applicationObserverEvent = (ApplicationObserverEvent)object;
        if (applicationObserverEvent.getSource() == this) {
            return;
        }
        if (object instanceof RankChangeEvent) {
            Rectangle rectangle = this.taxMapModel.getSelectedNodeRect();
            if (rectangle != null && !this.getVisibleRect().contains(rectangle)) {
                this.scrollRectToVisible(rectangle);
            }
            this.repaint();
        } else if (object instanceof TaxTreeStructureChangeEvent) {
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        } else if (actionEvent.getActionCommand().equals(VIEW_COMMAND)) {
            TaxMapViewDialog taxMapViewDialog = this.getView();
            if (taxMapViewDialog == null) {
                this.setView(this.createView());
                taxMapViewDialog = this.getView();
            }
            taxMapViewDialog.setVisible(true);
        } else if (actionEvent.getActionCommand().equals(SAVE_COMMAND)) {
            ImageUtil.doSaveAsPNG(this.taxTreeRenderer, this.getWidth(), this.getHeight(), this.parent);
        } else if (actionEvent.getActionCommand().equals(PRINT_COMMAND)) {
            AbstractPrintExecuter abstractPrintExecuter = new AbstractPrintExecuter(this.parent, this.getWidth(), this.getHeight()){

                protected void draw(Graphics2D graphics2D, int n, int n2) {
                    TaxTreePanel.this.taxTreeRenderer.draw(graphics2D);
                }
            };
            abstractPrintExecuter.execute();
        }
    }

    public void disposeView() {
        if (this.view == null) {
            return;
        }
        this.view.dispose();
        this.view.setVisible(false);
        this.view = null;
    }

    public TaxMapViewDialog getView() {
        return this.view;
    }

    public TaxMapViewDialog createView() {
        TaxTreePanel taxTreePanel = new TaxTreePanel(this.parent, this.mediator, this.taxMapModel, false);
        taxTreePanel.setShowView(false);
        taxTreePanel.setPreferredSize(new Dimension(600, 400));
        TaxMapViewDialog taxMapViewDialog = new TaxMapViewDialog(this.parent, TITLE, taxTreePanel, this.taxMapModel, this, true);
        taxTreePanel.setParent(taxMapViewDialog);
        return taxMapViewDialog;
    }

    public void setView(TaxMapViewDialog taxMapViewDialog) {
        this.view = taxMapViewDialog;
    }

    public boolean isShowView() {
        return this.showView;
    }

    public void setShowView(boolean bl) {
        this.showView = bl;
    }
}

