/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxTreeBarColor;
import cgdp.recog.taxonomy.map.TaxTreeContext;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.JLicenserTool;
import cgdp.recog.util.Renderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.TreeNode;

class TaxTreeRenderer
implements Renderer {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxTreeRenderer.class);
    private static Image PLUS_IMAGE;
    private static Image MINUS_IMAGE;
    private static AlphaComposite composite;
    private TaxMapModel taxMapModel;
    private TaxTreeContext taxTreeContext;
    private double height;
    private double width;
    private double widthToLeaf;

    TaxTreeRenderer(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
        this.taxTreeContext = new TaxTreeContext();
    }

    public void draw(Graphics2D graphics2D) {
        this.taxMapModel.clearRankArea();
        this.taxMapModel.clearTreeIconAreaSet();
        this.drawTree(graphics2D);
    }

    public void drawSelectArea(Graphics2D graphics2D) {
        if (!this.taxMapModel.isExistSelectedNode()) {
            return;
        }
        List list = this.taxMapModel.getSelectedNodeRectList();
        for (Rectangle rectangle : list) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(TaxTreeRenderer.composite);
            graphics2D.setColor(Color.blue);
            graphics2D.fill(rectangle);
            graphics2D.setComposite(composite);
        }
    }

    private void drawTree(Graphics2D graphics2D) {
        TaxonomyTreeNode taxonomyTreeNode = this.taxMapModel.getRootNode();
        double d = this.taxTreeContext.getMarginX();
        double d2 = this.taxTreeContext.getMarginY();
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.calcPanelSize(fontMetrics, taxonomyTreeNode);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.taxTreeContext.createFont());
        this.drawTree(graphics2D, taxonomyTreeNode, d, d2, this.taxTreeContext.getBarGraphWidth());
        graphics2D.setFont(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private double drawTree(Graphics2D graphics2D, TaxonomyTreeNode taxonomyTreeNode, double d, double d2, double d3) {
        int n;
        Image image = ((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild() ? MINUS_IMAGE : PLUS_IMAGE;
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int n4 = n2 - 6;
        int n5 = n3 - 6;
        if (this.taxMapModel.isViewMode()) {
            n2 = 0;
            n3 = 0;
            n4 = 0;
            n5 = 0;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d4 = d2;
        double d5 = this.taxTreeContext.getBarGraphWidth();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            String string = taxonomyTreeNode2.getName();
            d5 = Math.max((double)fontMetrics.stringWidth(string), d5);
        }
        double d6 = d + d3 + this.taxTreeContext.getBranchLabelLength() * 2.0;
        if (!((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
            d6 = d + this.taxTreeContext.getBranchLabelLength() * 3.0;
        }
        double d7 = 0.0;
        double d8 = 0.0;
        List list = this.getChildNodeList((DisplayTaxonomyTreeNode)taxonomyTreeNode);
        for (n = 0; n < list.size(); ++n) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode = (DisplayTaxonomyTreeNode)list.get(n);
            if (!((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) continue;
            d7 = this.drawTree(graphics2D, displayTaxonomyTreeNode, d6, d4, d5);
            d8 += d7;
            if (n == list.size() - 1) continue;
            double d9 = displayTaxonomyTreeNode.isVisibledChild() || displayTaxonomyTreeNode.isVisibled() ? this.taxTreeContext.getBranchInterval() : (this.taxMapModel.isActionMode() ? (double)n3 / 1.2 : 0.0);
            graphics2D.drawLine((int)d6, (int)(d4 + (double)(n5 / 2)), (int)d6, (int)(d4 + d7 + d9));
            d8 += d9;
            d4 += d7 + d9;
        }
        if (this.taxMapModel.isActionMode()) {
            n = (int)d - n2 / 2;
            int n6 = (int)d2 - n3 / 2;
            graphics2D.drawImage(image, n, n6, null);
            this.registerTreeIconArea(taxonomyTreeNode, n, n6, image);
        }
        if (taxonomyTreeNode.isLeaf()) {
            if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) {
                graphics2D.drawLine((int)d, (int)d2, (int)this.getWidthToLeaf(), (int)d2);
                if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
                    graphics2D.drawString(taxonomyTreeNode.getName(), (int)(this.getWidthToLeaf() + this.taxTreeContext.getBranchLabelMargin()), (int)d4 + fontMetrics.getDescent());
                    if (!(!this.taxMapModel.isExistRankScore(taxonomyTreeNode) || this.taxMapModel.isModeScoreLower() && TaxMapModel.isNoHitsCode(taxonomyTreeNode.getAbbreviation()))) {
                        d8 = this.drawBarGraph(graphics2D, (int)this.getWidthToLeaf(), (int)d4 + fontMetrics.getDescent(), taxonomyTreeNode.getAbbreviation(), false);
                    }
                    this.registerRankArea(taxonomyTreeNode, (int)this.getWidthToLeaf(), (int)d4, d8, fontMetrics);
                } else {
                    double d10 = this.taxTreeContext.getHideCircleSize();
                    graphics2D.fillOval((int)(this.getWidthToLeaf() - d10 / 2.0 - 1.0), (int)(d2 - d10 / 2.0), (int)d10, (int)d10);
                    this.registerRankArea(taxonomyTreeNode, (int)(this.getWidthToLeaf() - d10 / 2.0), (int)(d2 - d10 / 2.0), (int)d10, (int)d10);
                }
            }
        } else if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
            n = (int)(d + this.taxTreeContext.getBranchTopLength());
            int n7 = fontMetrics.stringWidth(taxonomyTreeNode.getName());
            graphics2D.drawLine((int)d, (int)d2, n, (int)d2);
            if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) {
                graphics2D.drawLine((int)((double)(n + n7) + this.taxTreeContext.getBranchLabelMargin()), (int)d2, (int)d6 - n4 / 2, (int)d2);
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawString(taxonomyTreeNode.getName(), (int)(d + this.taxTreeContext.getBranchLabelLength()), (int)d2 + fontMetrics.getDescent());
            d7 = 0.0;
            if (this.taxMapModel.isExistRankScore(taxonomyTreeNode)) {
                d7 = this.drawBarGraph(graphics2D, n, (int)d2 + fontMetrics.getDescent(), taxonomyTreeNode.getName(), false);
                d8 = Math.max(d7, d8);
            }
            this.registerRankArea(taxonomyTreeNode, n, (int)d2, d7, fontMetrics);
        } else if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) {
            graphics2D.drawLine((int)d, (int)d2, (int)d6 - n4 / 2, (int)d2);
            n = (int)(d + this.taxTreeContext.getAddBranchOvalLength());
            double d11 = this.taxTreeContext.getHideCircleSize();
            graphics2D.fillOval((int)((double)n - d11 / 2.0 - 1.0), (int)(d2 - d11 / 2.0), (int)d11, (int)d11);
            this.registerRankArea(taxonomyTreeNode, (int)((double)n - d11 / 2.0), (int)(d2 - d11 / 2.0), (int)d11, (int)d11);
        }
        return d8;
    }

    private List getChildNodeList(DisplayTaxonomyTreeNode displayTaxonomyTreeNode) {
        ArrayList<DisplayTaxonomyTreeNode> arrayList = new ArrayList<DisplayTaxonomyTreeNode>();
        for (int i = 0; i < displayTaxonomyTreeNode.getChildCount(); ++i) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode2 = (DisplayTaxonomyTreeNode)displayTaxonomyTreeNode.getChildAt(i);
            arrayList.add(displayTaxonomyTreeNode2);
        }
        if (this.taxMapModel.isViewMode()) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode3;
            HashSet<DisplayTaxonomyTreeNode> hashSet = new HashSet<DisplayTaxonomyTreeNode>();
            for (int i = displayTaxonomyTreeNode.getChildCount() - 1; i >= 0 && !(displayTaxonomyTreeNode3 = (DisplayTaxonomyTreeNode)displayTaxonomyTreeNode.getChildAt(i)).isVisibledChild() && !displayTaxonomyTreeNode3.isVisibled(); --i) {
                hashSet.add(displayTaxonomyTreeNode3);
            }
            arrayList.removeAll(hashSet);
        }
        return arrayList;
    }

    private int drawBarGraph(Graphics2D graphics2D, int n, int n2, String string, boolean bl) {
        int n3 = n + (int)this.taxTreeContext.getBarMarginX();
        int n4 = n2 + (int)this.taxTreeContext.getBarMarginY();
        if (this.taxMapModel.isLine() || this.taxMapModel.getCumulativeBarStep() >= 100.0) {
            if (bl) {
                return 0;
            }
            double d = this.taxMapModel.getScoreRatio(string);
            double d2 = this.taxTreeContext.getBarGraphWidth() * d;
            d2 = d2 <= 1.0 ? 2.0 : d2;
            graphics2D.setColor(Color.red.darker());
            graphics2D.fill(new Rectangle2D.Double(n3, n4, d2, this.taxTreeContext.getBarGraphHeight()));
            double d3 = this.taxMapModel.getChildScoreRatio(string);
            double d4 = this.taxTreeContext.getBarGraphWidth() * d3;
            graphics2D.setColor(Color.blue.darker());
            graphics2D.fill(new Rectangle2D.Double((double)n3 + d2, n4, d4, this.taxTreeContext.getBarGraphHeight()));
            double d5 = this.taxMapModel.getParentScoreRatio(string);
            double d6 = this.taxTreeContext.getBarGraphWidth() * d5;
            graphics2D.setColor(Color.green.darker());
            graphics2D.fill(new Rectangle2D.Double((double)n3 + d2 + d4, n4, d6, this.taxTreeContext.getBarGraphHeight()));
            graphics2D.setColor(Color.gray.brighter());
            graphics2D.drawRect(n3, n4, (int)this.taxTreeContext.getBarGraphWidth(), (int)this.taxTreeContext.getBarGraphHeight());
            graphics2D.setColor(Color.black);
            return 0;
        }
        if (this.taxMapModel.isGradation()) {
            if (bl) {
                return 0;
            }
            double d = this.taxMapModel.getScoreRatio(string);
            Color color = TaxTreeBarColor.getColor(d);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(n3, n4, (int)this.taxTreeContext.getBarGraphWidth(), this.taxTreeContext.getBarGraphHeight()));
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n3, n4, (int)this.taxTreeContext.getBarGraphWidth(), (int)this.taxTreeContext.getBarGraphHeight());
            return 0;
        }
        if (this.taxMapModel.isCumulative()) {
            double d = this.taxMapModel.getScoreRatio(string);
            double d7 = this.taxTreeContext.getBarGraphWidth() * d;
            d7 = d7 <= 1.0 ? 2.0 : d7;
            double d8 = this.taxMapModel.getChildScoreRatio(string);
            double d9 = this.taxTreeContext.getBarGraphWidth() * d8;
            double d10 = this.taxMapModel.getParentScoreRatio(string);
            double d11 = this.taxTreeContext.getBarGraphWidth() * d10;
            double d12 = this.taxMapModel.getCumulativeBarStep();
            int n5 = (int)this.taxTreeContext.getBarGraphHeight() / 2;
            int n6 = (int)this.taxTreeContext.getBarGraphHeight() / 4;
            this.drawCumulativeBarGraph(graphics2D, new Point2D.Double(n3, n4), new double[]{d7 * 100.0 / d12, d9 * 100.0 / d12, d11 * 100.0 / d12}, new Color[]{Color.red.darker(), Color.blue.darker(), Color.green.darker()}, (int)this.taxTreeContext.getBarGraphWidth(), n5, n6, false, bl);
            this.drawCumulativeBarGraph(graphics2D, new Point2D.Double(n3, n4), new double[]{(d7 + d9 + d11) * 100.0 / d12}, new Color[]{Color.gray.brighter()}, (int)this.taxTreeContext.getBarGraphWidth(), n5, n6, true, bl);
            if (!bl) {
                graphics2D.setColor(Color.black);
            }
            int n7 = (int)Math.ceil((d7 + d9 + d11) * 100.0 / d12 / this.taxTreeContext.getBarGraphWidth());
            return Math.max(0, (n7 - 1) * (n5 + n6));
        }
        return 0;
    }

    private void drawCumulativeBarGraph(Graphics2D graphics2D, Point2D point2D, double[] dArray, Color[] colorArray, int n, int n2, int n3, boolean bl, boolean bl2) {
        if (bl2) {
            return;
        }
        double d = 0.0;
        Point2D point2D2 = (Point2D)point2D.clone();
        block0: for (int i = 0; i < dArray.length; ++i) {
            if (i < colorArray.length) {
                graphics2D.setColor(colorArray[i]);
            }
            for (double d2 = dArray[i]; d2 > 0.0; d2 -= (double)n - d) {
                if (d + d2 < (double)n && !bl) {
                    if (bl) {
                        graphics2D.drawRect((int)point2D2.getX(), (int)point2D2.getY(), (int)d2, n2);
                    } else {
                        graphics2D.fill(new Rectangle2D.Double(point2D2.getX(), point2D2.getY(), d2, n2));
                    }
                    d += d2;
                    point2D2.setLocation(point2D2.getX() + d2, point2D2.getY());
                    d2 = 0.0;
                    continue block0;
                }
                if (bl) {
                    graphics2D.drawRect((int)point2D2.getX(), (int)point2D2.getY(), (int)((double)n - d), n2);
                } else {
                    graphics2D.fill(new Rectangle2D.Double(point2D2.getX(), point2D2.getY(), (double)n - d, n2));
                }
                d = 0.0;
                point2D2.setLocation(point2D.getX(), point2D2.getY() + (double)n2 + (double)n3);
            }
        }
    }

    private void registerRankArea(TaxonomyTreeNode taxonomyTreeNode, int n, int n2, double d, FontMetrics fontMetrics) {
        double d2 = fontMetrics.stringWidth(taxonomyTreeNode.getName()) + 3;
        if (this.taxMapModel.isExistRankScore(taxonomyTreeNode)) {
            d2 = Math.max(d2, this.taxTreeContext.getBarGraphWidth() + this.taxTreeContext.getBarMarginX()) + 3.0;
        }
        double d3 = this.taxTreeContext.getBarGraphHeight() + (double)fontMetrics.getHeight() + (double)fontMetrics.getDescent() + this.taxTreeContext.getBarMarginY() + d;
        Rectangle rectangle = new Rectangle(n, n2 - fontMetrics.getHeight() + 3, (int)d2, (int)d3);
        this.taxMapModel.addRankArea(taxonomyTreeNode, rectangle);
    }

    private void registerRankArea(TaxonomyTreeNode taxonomyTreeNode, int n, int n2, FontMetrics fontMetrics) {
        this.registerRankArea(taxonomyTreeNode, n, n2, 0.0, fontMetrics);
    }

    private void registerRankArea(TaxonomyTreeNode taxonomyTreeNode, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n4 / 2, n3 * 2, n4 * 2);
        this.taxMapModel.addRankArea(taxonomyTreeNode, rectangle);
    }

    private void registerTreeIconArea(TaxonomyTreeNode taxonomyTreeNode, int n, int n2, Image image) {
        Rectangle rectangle = new Rectangle(n, n2, image.getWidth(null), image.getHeight(null));
        this.taxMapModel.addTreeIconRect(taxonomyTreeNode, rectangle);
    }

    private void calcPanelSize(FontMetrics fontMetrics, TaxonomyTreeNode taxonomyTreeNode) {
        this.width = 0.0;
        this.widthToLeaf = 0.0;
        this.height = this.calcPanelSize(fontMetrics, taxonomyTreeNode, this.taxTreeContext.getMarginX(), this.taxTreeContext.getBarGraphWidth()) + this.taxTreeContext.getBarGraphHeight() + (double)fontMetrics.getHeight() + this.taxTreeContext.getBarMarginY() + this.taxTreeContext.getMarginY() * 2.0;
    }

    private double calcPanelSize(FontMetrics fontMetrics, TaxonomyTreeNode taxonomyTreeNode, double d, double d2) {
        int n;
        Object object;
        Image image = ((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild() ? MINUS_IMAGE : PLUS_IMAGE;
        int n2 = image.getHeight(null);
        if (this.taxMapModel.isViewMode()) {
            n2 = 0;
        }
        double d3 = this.taxTreeContext.getBarGraphWidth();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            object = taxonomyTreeNode2.getName();
            d3 = Math.max((double)fontMetrics.stringWidth((String)object), d3);
        }
        double d4 = d + d2 + this.taxTreeContext.getBranchLabelLength() * 2.0;
        if (!((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
            d4 = d + this.taxTreeContext.getBranchLabelLength() * 3.0;
        }
        object = this.getChildNodeList((DisplayTaxonomyTreeNode)taxonomyTreeNode);
        double d5 = 0.0;
        double d6 = 0.0;
        for (n = 0; n < object.size(); ++n) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode = (DisplayTaxonomyTreeNode)object.get(n);
            if (!((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) continue;
            d5 = this.calcPanelSize(fontMetrics, displayTaxonomyTreeNode, d4, d3);
            d6 += d5;
            if (n == object.size() - 1) continue;
            double d7 = displayTaxonomyTreeNode.isVisibledChild() || displayTaxonomyTreeNode.isVisibled() ? this.taxTreeContext.getBranchInterval() : (this.taxMapModel.isActionMode() ? (double)n2 / 1.2 : 0.0);
            d6 += d7;
        }
        if (taxonomyTreeNode.isLeaf()) {
            if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) {
                if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
                    if (!(!this.taxMapModel.isExistRankScore(taxonomyTreeNode) || this.taxMapModel.isModeScoreLower() && TaxMapModel.isNoHitsCode(taxonomyTreeNode.getAbbreviation()))) {
                        d6 += (double)this.drawBarGraph(null, (int)this.getWidthToLeaf(), fontMetrics.getDescent(), taxonomyTreeNode.getAbbreviation(), true);
                    }
                } else {
                    double d8 = this.taxTreeContext.getHideCircleSize();
                }
            }
        } else if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibled()) {
            n = (int)(d + this.taxTreeContext.getBranchTopLength());
            int n3 = fontMetrics.stringWidth(taxonomyTreeNode.getName());
            if (this.taxMapModel.isExistRankScore(taxonomyTreeNode)) {
                d5 = this.drawBarGraph(null, n, fontMetrics.getDescent(), taxonomyTreeNode.getName(), true);
                d6 = Math.max(d5, d6);
            }
        } else if (((DisplayTaxonomyTreeNode)taxonomyTreeNode).isVisibledChild()) {
            n = (int)(d + this.taxTreeContext.getAddBranchOvalLength());
            double d9 = this.taxTreeContext.getHideCircleSize();
        }
        this.widthToLeaf = Math.max(this.widthToLeaf, d + this.taxTreeContext.getBranchLabelLength() * 2.0 + this.taxTreeContext.getBranchTopLength());
        this.width = Math.max(this.width, this.widthToLeaf + d2 + this.taxTreeContext.getMarginX() * 2.0);
        return d6;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getWidthToLeaf() {
        return this.widthToLeaf;
    }

    static {
        try {
            PLUS_IMAGE = Toolkit.getDefaultToolkit().getImage(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/plus.png"));
            MINUS_IMAGE = Toolkit.getDefaultToolkit().getImage(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/minus.png"));
        }
        catch (Exception exception) {
            logger.warn("Fail to load image[plus.png/minus.png]", exception);
        }
        composite = AlphaComposite.getInstance(3, 0.25f);
    }
}

