/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Genome;
import cgdp.recog.funccat.FunctionCategoryDownloader;
import cgdp.recog.funccat.FunctionCategoryExporter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AllGeneInfoUpdater;
import cgdp.recog.update.DataUpdateType;
import cgdp.recog.update.DataVersionExporter;
import cgdp.recog.update.DomClustExecGeneInfoUpdater;
import cgdp.recog.update.DomClustGeneInfoUpdater;
import cgdp.recog.update.LocalGeneInfoUpdater;
import cgdp.recog.update.SysInfoDownloader;
import cgdp.recog.update.TaxonomyOnlyUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataUpdater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractDataUpdater.class);
    private Frame parent;
    private MediatorImpl mediator;
    private File workDir;

    protected AbstractDataUpdater(Frame frame, MediatorImpl mediatorImpl) {
        this.parent = frame;
        this.mediator = mediatorImpl;
    }

    protected Frame getParent() {
        return this.parent;
    }

    protected MediatorImpl getMediator() {
        return this.mediator;
    }

    public static AbstractDataUpdater createDataUpdater(int n, Frame frame, MediatorImpl mediatorImpl) {
        if (DataUpdateType.isTaxonomyOnly(n)) {
            return new TaxonomyOnlyUpdater(frame, mediatorImpl);
        }
        if (DataUpdateType.isLocalGeneOnly(n)) {
            return new LocalGeneInfoUpdater(frame, mediatorImpl);
        }
        if (DataUpdateType.isLocalGeneOnlyForce(n)) {
            LocalGeneInfoUpdater localGeneInfoUpdater = new LocalGeneInfoUpdater(frame, mediatorImpl);
            localGeneInfoUpdater.setForceFlag(true);
            return localGeneInfoUpdater;
        }
        return new AllGeneInfoUpdater(frame, mediatorImpl);
    }

    public static AbstractDataUpdater createDomClustGeneInfoDataUpdater(Frame frame, MediatorImpl mediatorImpl, Set set) {
        DomClustGeneInfoUpdater domClustGeneInfoUpdater = new DomClustGeneInfoUpdater(frame, mediatorImpl);
        domClustGeneInfoUpdater.setOrganismCodeSet(set);
        return domClustGeneInfoUpdater;
    }

    public static DomClustExecGeneInfoUpdater createDomClustExecGeneInfoUpdater(Frame frame, MediatorImpl mediatorImpl, Set set) {
        DomClustExecGeneInfoUpdater domClustExecGeneInfoUpdater = new DomClustExecGeneInfoUpdater(frame, mediatorImpl);
        domClustExecGeneInfoUpdater.setOrganismCodeSet(set);
        return domClustExecGeneInfoUpdater;
    }

    public abstract String[] getProgressMessages();

    public void createWorkDir() {
        String string = String.valueOf("tmp_" + System.currentTimeMillis());
        File file = new File(AccessServer.getDataDir(), string);
        file.mkdir();
        File file2 = new File(file, "chromosome");
        File file3 = new File(file, "genes");
        File file4 = new File(file, "contig");
        File file5 = new File(file, "mapping");
        file2.mkdir();
        file3.mkdir();
        file4.mkdir();
        file5.mkdir();
        this.workDir = file;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void deleteWorkDir() {
        if (this.workDir == null) {
            return;
        }
        FileUtil.delete(this.workDir);
    }

    public void copyFromWorkDir(String string) throws Exception {
        FileUtil.copyDir(this.workDir.getAbsolutePath(), string, true);
    }

    public static void updateDataVersion() {
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(new Runnable(){

            public void run() {
                try {
                    SysInfoDownloader sysInfoDownloader = new SysInfoDownloader();
                    sysInfoDownloader.execute();
                    String string = sysInfoDownloader.getSysInfoProperties().getProperty("ver-data");
                    DataVersionExporter dataVersionExporter = new DataVersionExporter(string, DataManager.getDataVersionFilepath());
                    dataVersionExporter.execute();
                }
                catch (Exception exception) {
                    logger.warn("Fail to update data version.", exception);
                }
            }
        });
    }

    public static void updateDataVersion(String string) throws Exception {
        SysInfoDownloader sysInfoDownloader = new SysInfoDownloader();
        sysInfoDownloader.execute();
        String string2 = sysInfoDownloader.getSysInfoProperties().getProperty("ver-data");
        DataVersionExporter dataVersionExporter = new DataVersionExporter(string2, string);
        dataVersionExporter.execute();
    }

    protected Set getUpdateOrganismCodeSet(List list, List list2, Set set) {
        Map map = this.createGenomeMap(list2);
        HashSet<String> hashSet = new HashSet<String>();
        for (Genome genome : list) {
            Genome genome2;
            if (!set.contains(genome.getSpeciesCode()) || (genome2 = (Genome)map.get(genome.getSpeciesCode())) == null || genome.getMbgdUpdate().equals(genome2.getMbgdUpdate())) continue;
            hashSet.add(genome.getSpeciesCode());
        }
        return hashSet;
    }

    private Map createGenomeMap(List list) {
        HashMap<String, Genome> hashMap = new HashMap<String, Genome>();
        for (Genome genome : list) {
            hashMap.put(genome.getSpeciesCode(), genome);
        }
        return hashMap;
    }

    protected List createUpdateGenmeList(List list, List list2, Set set) {
        Object object;
        Object object22;
        Map map = this.createGenomeMap(list2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object22 : list) {
            if (set.contains(((Genome)object22).getSpeciesCode())) {
                object = (Genome)map.get(((Genome)object22).getSpeciesCode());
                if (object == null) {
                    System.err.println("No server genome");
                    continue;
                }
                arrayList.add(object);
                hashSet.add(((Genome)object22).getSpeciesCode());
                continue;
            }
            if (object22 == null) continue;
            arrayList.add(object22);
        }
        HashSet hashSet2 = new HashSet(set);
        hashSet2.removeAll(hashSet);
        object22 = hashSet2.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            Genome genome = (Genome)map.get(object);
            if (genome == null) continue;
            arrayList.add(genome);
        }
        return arrayList;
    }

    protected boolean downloadFunctionCategory() throws Exception {
        FunctionCategoryDownloader functionCategoryDownloader = new FunctionCategoryDownloader();
        functionCategoryDownloader.execute();
        if (functionCategoryDownloader.isError()) {
            this.setError(true);
            this.setErrorMessage(functionCategoryDownloader.getErrorMessage());
            return false;
        }
        Map map = functionCategoryDownloader.getFunctionCategoryMap();
        for (String string : map.keySet()) {
            String string2 = DataManager.getFunctionCategoryFilepath(string);
            if (new File(string2).isFile()) continue;
            List list = (List)map.get(string);
            FunctionCategoryExporter functionCategoryExporter = new FunctionCategoryExporter(string, list);
            functionCategoryExporter.setOutputDir(this.getWorkDir().getAbsolutePath());
            functionCategoryExporter.execute();
        }
        return true;
    }

    public void done() {
    }
}

