/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Genome;
import cgdp.recog.data.GenomeExporter;
import cgdp.recog.data.GenomeImporter;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AllGeneInfoUpdater
extends AbstractDataUpdater {
    private static final ApplicationLogger logger = new ApplicationLogger(AllGeneInfoUpdater.class);

    AllGeneInfoUpdater(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        Object object;
        try {
            progressImpl.setTotal(3);
            DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
            DataManager.createDataDirectory();
            this.createWorkDir();
            object = this.getWorkDir();
            String string = new File((File)object, "taxonomy.dat").getAbsolutePath();
            String string2 = new File((File)object, "dataVersion").getAbsolutePath();
            String string3 = new File((File)object, "genome.dat").getAbsolutePath();
            String string4 = new File((File)object, "genome_param.dat").getAbsolutePath();
            dataFileDownloader.downloadTaxonomyData(string);
            progressImpl.increment();
            AbstractDataUpdater.updateDataVersion(string2);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            dataFileDownloader.downloadGenomeParamData(string4);
            dataFileDownloader.downloadGenomeData(string3);
            GenomeImporter genomeImporter = new GenomeImporter(string3);
            genomeImporter.execute();
            List list = genomeImporter.getGenomeList();
            Set set = this.getOrganismCodeSet(list);
            GenomeExporter genomeExporter = new GenomeExporter(list, string3);
            genomeExporter.execute();
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setCount(-1);
            progressImpl.increment();
            progressImpl.setTotal(set.size());
            dataFileDownloader.downloadGeneAndChromosomeData(set, (File)object, progressImpl);
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setTotal(1);
            progressImpl.setCount(-1);
            progressImpl.increment();
            if (!this.downloadFunctionCategory()) {
                return;
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            this.copyFromWorkDir(AccessServer.getDataDir());
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
        }
        catch (Exception exception) {
            object = "Fail to update data files.";
            logger.warn((String)object, exception);
            this.setError(true);
            this.setErrorMessage((String)object);
        }
        finally {
            this.deleteWorkDir();
        }
    }

    private Set getOrganismCodeSet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Genome genome : list) {
            hashSet.add(genome.getSpeciesCode());
        }
        return hashSet;
    }

    public String[] getProgressMessages() {
        return new String[]{"Update taxonomy tree data...", "Update gene data...", "Update function category..."};
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage((Component)this.getParent(), this.getErrorMessages());
            return;
        }
        this.getMediator().updateTaxonomyTree();
    }
}

