/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;

class TaxonomyOnlyUpdater
extends AbstractDataUpdater {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxonomyOnlyUpdater.class);

    TaxonomyOnlyUpdater(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        Object object;
        try {
            progressImpl.setTotal(3);
            DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
            DataManager.createDataDirectory();
            this.createWorkDir();
            object = this.getWorkDir();
            String string = new File((File)object, "taxonomy.dat").getAbsolutePath();
            String string2 = new File((File)object, "dataVersion").getAbsolutePath();
            dataFileDownloader.downloadTaxonomyData(string);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            AbstractDataUpdater.updateDataVersion(string2);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            this.copyFromWorkDir(AccessServer.getDataDir());
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
        }
        catch (Exception exception) {
            object = "Fail to update taxonomy file.";
            logger.warn((String)object, exception);
            this.setError(true);
            this.setErrorMessage((String)object);
        }
        finally {
            this.deleteWorkDir();
        }
    }

    public String[] getProgressMessages() {
        return new String[]{"Update taxonomy tree data..."};
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage((Component)this.getParent(), this.getErrorMessages());
            return;
        }
        this.getMediator().updateTaxonomyTree();
    }
}

