/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AbstractControlTabPanel
extends TabPanel
implements ActionListener {
    private JPanel controlButtonPanel = this.createControlButtonPanel();
    protected JButton addButton;
    protected JButton editButton;
    protected JButton deleteButton;
    protected JButton downloadButton;
    protected JButton uploadButton;
    private boolean showAddButton = true;

    public AbstractControlTabPanel(Dialog dialog) {
        super(dialog);
    }

    protected void setEnabledButton(int n) {
        if (n == -1) {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.downloadButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.downloadButton.setEnabled(true);
            this.uploadButton.setEnabled(true);
        }
    }

    public JPanel getControlButtonPanel() {
        return this.controlButtonPanel;
    }

    private JPanel createControlButtonPanel() {
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(this);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton("Delete...");
        this.deleteButton.addActionListener(this);
        this.downloadButton = new JButton("Download...");
        this.downloadButton.addActionListener(this);
        this.uploadButton = new JButton("Upload");
        this.uploadButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.editButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.downloadButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.uploadButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        return jPanel;
    }

    protected void setDownloadButtonLabel(String string) {
        this.downloadButton.setText(string);
    }

    public void setShowAddButton(boolean bl) {
        this.showAddButton = bl;
        this.addButton.setVisible(bl);
    }

    private boolean isShowAddButton() {
        return this.showAddButton;
    }

    protected abstract void add();

    protected abstract void edit();

    protected abstract void delete();

    protected abstract void download();

    protected abstract void upload();

    protected void changeDefault() {
    }

    public boolean check() {
        return false;
    }

    protected void updateParameters() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.editButton) {
            this.edit();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        } else if (actionEvent.getSource() == this.downloadButton) {
            this.download();
        } else if (actionEvent.getSource() == this.uploadButton) {
            this.upload();
        }
    }
}

