/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneUtil {
    private static final String ORGANISMCODE_LOCUSTAG_DELIMITER = ":";

    public static double calcGenePositionMB(double d, double d2, double d3, boolean bl) {
        return GeneUtil.calcGenePosition(d, d2, d3, bl) / 1000.0;
    }

    public static double calcGenePosition(double d, double d2, double d3, boolean bl) {
        double d4 = (d + d2) / 2.0;
        if (bl && d4 > d3 / 2.0) {
            d4 -= d3;
        }
        return d4;
    }

    public static double calcGenePosition(double d, double d2, boolean bl) {
        double d3 = d;
        if (bl && d > d2 / 2.0) {
            d3 = d - d2;
        }
        return d3;
    }

    public static double diffGenePosition(double d, double d2, double d3, boolean bl) {
        double d4 = Math.abs(d - d2);
        if (bl && d4 > d3 / 2.0) {
            d4 = Math.abs(d3 - d4);
        }
        return d4;
    }

    public static int countSp(Collection collection, Collection collection2) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!collection2.contains(iterator.next())) continue;
            ++n;
        }
        return n;
    }

    public static String createOrganismLocusTagKey(Gene gene) {
        return GeneUtil.createOrganismLocusTagKey(gene.getOrganism(), gene.getLocusTag());
    }

    public static String createOrganismLocusTagKey(String string, String string2) {
        return string + ORGANISMCODE_LOCUSTAG_DELIMITER + string2;
    }

    public static String createOrganismLocusTagKey(GeneInfo geneInfo) {
        String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
        String string2 = geneInfo.getLocusTag();
        return GeneUtil.createOrganismLocusTagKey(string, string2);
    }

    public static String removeDomainNo(String string) {
        if (!GeneUtil.isDomain(string)) {
            return string;
        }
        String string2 = string;
        int n = string2.lastIndexOf("(");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static Set removeDomainNo(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            hashSet.add(GeneUtil.removeDomainNo(string));
        }
        return hashSet;
    }

    public static int getDomainNo(String string) {
        if (!string.endsWith(")")) {
            return Integer.MIN_VALUE;
        }
        int n = string.indexOf("(");
        if (n == -1) {
            return Integer.MIN_VALUE;
        }
        String string2 = string.substring(n + 1, string.length() - 1);
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
        return n2;
    }

    public static boolean isDomain(String string) {
        return GeneUtil.getDomainNo(string) != Integer.MIN_VALUE;
    }

    public static String combineLocusTagDomainNo(String string, int n) {
        String string2 = "(" + n + ")";
        if (string.endsWith(string2)) {
            return string;
        }
        return string + string2;
    }

    public static int convertDNAFrom(int n) {
        return n * 3 - 2;
    }

    public static int convertDNATo(int n) {
        return n * 3;
    }

    public static int getDNALength(int n, int n2) {
        return n2 - n + 1;
    }

    public static List getLocusTagList(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (GeneInformation geneInformation : list) {
            arrayList.add(geneInformation.getLocusTag());
        }
        return arrayList;
    }

    public static String getDisplayDirection(int n) {
        if (n == 1) {
            return "+";
        }
        if (n == -1) {
            return "-";
        }
        return "";
    }

    public static String getOrganismLocusTagsString(String string, List list, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            if (i == list.size() - 1) continue;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static Map createLocusTagMapFromOrganismLocusTagsString(String string, String string2, String string3) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        Vector vector = StringTool.splitString(string, string3);
        for (String string4 : vector) {
            Vector vector2 = StringTool.splitString(string4, string2);
            if (vector2.size() != 2) continue;
            String string5 = ((String)vector2.get(0)).trim();
            String string6 = ((String)vector2.get(1)).trim();
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string5);
            if (CollectionUtil.isNull(arrayList)) {
                arrayList = new ArrayList<String>();
                hashMap.put(string5, arrayList);
            }
            arrayList.add(string6);
        }
        return hashMap;
    }

    public static String convertLocation(String string, int n) {
        String string2 = string;
        int n2 = 1;
        if (string.startsWith("complement")) {
            n2 = -1;
            string2 = string2.replaceAll("complement", "");
            string2 = string2.substring(1, string2.length() - 1);
        }
        boolean bl = false;
        if (string2.startsWith("join")) {
            string2 = string2.replaceAll("join", "");
            string2 = string2.substring(1, string2.length() - 1);
            bl = true;
        }
        Vector vector = StringTool.splitString(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([0-9]+)");
        for (String string3 : vector) {
            Matcher matcher = pattern.matcher(string3);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                int n3 = Integer.parseInt(matcher.group());
                matcher.appendReplacement(stringBuffer, String.valueOf(n3 += n));
            }
            matcher.appendTail(stringBuffer);
            arrayList.add(stringBuffer.toString());
        }
        Object object = StringTool.conbineStrList(arrayList, ",");
        if (bl) {
            object = "join(" + (String)object + ")";
        }
        if (n2 == -1) {
            object = "complement(" + (String)object + ")";
        }
        return object;
    }

    public static Map createGeneMap(List list) {
        HashMap<String, Gene> hashMap = new HashMap<String, Gene>();
        for (Gene gene : list) {
            String string = GeneUtil.createOrganismLocusTagKey(gene);
            hashMap.put(string, gene);
        }
        return hashMap;
    }
}

