/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.FocusTextField;
import java.text.NumberFormat;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RestrictTextField
extends FocusTextField {
    public static final int NOT_RESTRICT = -1;
    private static final NumberFormat doubleFormat = NumberFormat.getInstance();
    private boolean negative = false;
    private boolean decimal = false;
    private int restrict = -1;

    public RestrictTextField() {
        this.setHorizontalAlignment(4);
    }

    public RestrictTextField(String string) {
        this.setText(string);
        this.setHorizontalAlignment(4);
    }

    public RestrictTextField(int n) {
        super(n);
        this.setHorizontalAlignment(4);
    }

    public RestrictTextField(String string, int n) {
        super(n);
        this.setText(string);
        this.setHorizontalAlignment(4);
    }

    public void setDecimal(boolean bl) {
        this.decimal = bl;
    }

    private boolean isDecimal() {
        return this.decimal;
    }

    public void setNegative(boolean bl) {
        this.negative = bl;
    }

    private boolean isNegative() {
        return this.negative;
    }

    public void setRestrict(int n) {
        this.restrict = n;
    }

    private int getRestrict() {
        return this.restrict;
    }

    protected Document createDefaultModel() {
        return new RestrictDocument();
    }

    private boolean canParseDouble(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    static {
        doubleFormat.setMaximumFractionDigits(10);
    }

    private class RestrictDocument
    extends PlainDocument {
        private RestrictDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (string == null) {
                return;
            }
            if (RestrictTextField.this.canParseDouble(string) && string.toUpperCase().indexOf("E") != -1) {
                string = doubleFormat.format(Double.parseDouble(string));
            }
            int n3 = n2 = this.getText(0, this.getLength()).indexOf(".") == -1 ? this.getLength() : this.getText(0, this.getLength()).indexOf(".");
            if (n2 >= RestrictTextField.this.getRestrict() && RestrictTextField.this.getRestrict() != -1 && n2 >= n && !string.equals(".")) {
                return;
            }
            int n4 = n;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) {
                    super.insertString(n4, String.valueOf(c), attributeSet);
                    ++n4;
                    continue;
                }
                if (RestrictTextField.this.isDecimal() && c == '.') {
                    if (this.getText(0, this.getLength()).indexOf(".") != -1 || this.getLength() == 0) break;
                    super.insertString(n4, String.valueOf(c), attributeSet);
                    ++n4;
                    continue;
                }
                if (!RestrictTextField.this.isNegative() || c != '-' || this.getLength() != 0) break;
                super.insertString(n4, String.valueOf(c), attributeSet);
                ++n4;
            }
        }
    }
}

