/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabDialog
extends AbstractApplyDialog
implements ChangeListener {
    protected JTabbedPane tabbedPane;
    private JButton defaultButton;
    private boolean showDefaultButton;

    public TabDialog(Frame frame) {
        super(frame);
    }

    public TabDialog(Dialog dialog) {
        super(dialog);
    }

    protected void createComponents() {
        this.setTitle("Option");
        this.setModal(true);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(this);
        this.addTabPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        if (this.isShowDefaultButton()) {
            this.getContentPane().add((Component)this.defaultButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        }
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void setShowDefaultButton(boolean bl) {
        this.showDefaultButton = bl;
    }

    private boolean isShowDefaultButton() {
        return this.showDefaultButton;
    }

    protected abstract void addTabPanel();

    protected boolean check() {
        Component[] componentArray = this.tabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TabPanel) || ((TabPanel)componentArray[i]).check()) continue;
            return false;
        }
        return true;
    }

    protected boolean apply() {
        Component[] componentArray = this.tabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TabPanel)) continue;
            System.err.println("update: i=" + i + " " + componentArray[i].getClass());
            ((TabPanel)componentArray[i]).updateParameters();
        }
        this.processApply();
        return true;
    }

    protected boolean processApply() {
        return true;
    }

    private void changeDefault() {
        TabPanel tabPanel = (TabPanel)this.tabbedPane.getSelectedComponent();
        tabPanel.changeDefault();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.defaultButton) {
            this.changeDefault();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void setSelectedTab(String string) {
        int n = this.tabbedPane.indexOfTab(string);
        if (n != -1) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }
}

