/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtil {
    private TreeUtil() {
    }

    public static final DefaultMutableTreeNode copyTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2.add(TreeUtil.copyTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)));
        }
        return defaultMutableTreeNode2;
    }

    public static List saveExpandedState(JTree jTree) {
        return TreeUtil.findExpanded(jTree, (DefaultMutableTreeNode)jTree.getModel().getRoot());
    }

    private static List findExpanded(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            if (!jTree.isExpanded(treePath)) continue;
            arrayList.add(treePath);
        }
        return arrayList;
    }

    public static void expand(JTree jTree, TreePath treePath, boolean bl) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        arrayList.add(treePath);
        TreeUtil.expandAll(jTree, arrayList, bl);
    }

    public static void expandAll(JTree jTree, List list, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        TreeUtil.expandAll(jTree, new TreePath(treeNode), list, bl);
    }

    private static void expandAll(JTree jTree, TreePath treePath, List list, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                TreeUtil.expandAll(jTree, treePath2, list, bl);
            }
        }
        if (TreeUtil.isTargetPath(list, treePath)) {
            if (bl) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }
    }

    private static boolean isTargetPath(List list, TreePath treePath) {
        return list == null || list.contains(treePath);
    }

    public static final List getLastNodeList(TreePath[] treePathArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (treePathArray == null) {
            return arrayList;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            arrayList.add(treePathArray[i].getLastPathComponent());
        }
        return arrayList;
    }

    public static TreePath[] filterUniqueLastNode(TreePath[] treePathArray) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (hashSet.contains(treePathArray[i].getLastPathComponent())) continue;
            arrayList.add(treePathArray[i]);
            hashSet.add(treePathArray[i].getLastPathComponent());
        }
        TreePath[] treePathArray2 = new TreePath[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            treePathArray2[i] = (TreePath)arrayList.get(i);
        }
        return treePathArray2;
    }
}

