/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.data.Chromosome;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AlignGroupComparator
implements Comparator {
    private String referenceOrganismCode;
    private List organismCodeList;
    private GlobalAlign globalAlign;

    public AlignGroupComparator(String string, List list) {
        this.referenceOrganismCode = string;
        this.organismCodeList = list;
    }

    public AlignGroupComparator(String string, List list, GlobalAlign globalAlign) {
        this.referenceOrganismCode = string;
        this.organismCodeList = list;
        this.globalAlign = globalAlign;
    }

    public int compare(Object object, Object object2) {
        String string;
        GlobalAlignElement globalAlignElement;
        GlobalAlignGroup globalAlignGroup = (GlobalAlignGroup)object;
        GlobalAlignGroup globalAlignGroup2 = (GlobalAlignGroup)object2;
        GlobalAlignElement globalAlignElement2 = globalAlignGroup.getMinPositionAlignGroup(this.referenceOrganismCode);
        int n = this.compareAlignElement(globalAlignElement2, globalAlignElement = globalAlignGroup2.getMinPositionAlignGroup(this.referenceOrganismCode));
        if (n != 0) {
            return n;
        }
        Iterator iterator = this.organismCodeList.iterator();
        while (iterator.hasNext() && ((string = (String)iterator.next()).equals(this.referenceOrganismCode) || (n = this.compareAlignElement(globalAlignElement2 = globalAlignGroup.getMinPositionAlignGroup(string), globalAlignElement = globalAlignGroup2.getMinPositionAlignGroup(string))) == 0)) {
        }
        return n;
    }

    private int compareAlignElement(GlobalAlignElement globalAlignElement, GlobalAlignElement globalAlignElement2) {
        if (globalAlignElement != null && globalAlignElement2 != null) {
            Chromosome chromosome = this.globalAlign.getChromosome(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
            double d = globalAlignElement.getPosition();
            if (chromosome != null && chromosome.isCircular() && globalAlignElement.getPosition() > (double)chromosome.getLength() / 2.0) {
                d = globalAlignElement.getPosition() - (double)chromosome.getLength();
            }
            Chromosome chromosome2 = this.globalAlign.getChromosome(globalAlignElement2.getOrganism().getOrganismCode(), globalAlignElement2.getChromID());
            double d2 = globalAlignElement2.getPosition();
            if (chromosome2 != null && chromosome2.isCircular() && globalAlignElement2.getPosition() > (double)chromosome2.getLength() / 2.0) {
                d2 = globalAlignElement2.getPosition() - (double)chromosome2.getLength();
            }
            if (d != d2) {
                return d - d2 < 0.0 ? -1 : 1;
            }
            if (globalAlignElement.getStart() != globalAlignElement2.getStart()) {
                return globalAlignElement.getStart() - globalAlignElement2.getStart();
            }
            if (globalAlignElement.getEnd() != globalAlignElement2.getEnd()) {
                return globalAlignElement.getEnd() - globalAlignElement2.getEnd();
            }
            return globalAlignElement.getLocusTag().compareTo(globalAlignElement2.getLocusTag());
        }
        if (globalAlignElement != null && globalAlignElement2 == null) {
            return -1;
        }
        if (globalAlignElement == null && globalAlignElement2 != null) {
            return 1;
        }
        return 0;
    }
}

