/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class GlobalAlignColorOptionPanel
extends TabPanel {
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private JRadioButton refColorButton;
    private JRadioButton ppmButton;

    GlobalAlignColorOptionPanel(Component component, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(component);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createColorPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.updateValue();
    }

    private JPanel createColorPanel() {
        this.refColorButton = new JRadioButton("Reference genome");
        this.ppmButton = new JRadioButton("Use the color of the control tree");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.refColorButton);
        buttonGroup.add(this.ppmButton);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.refColorButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.ppmButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.updateValue(this.globalAlignViewModel);
    }

    private void updateValue(GlobalAlignViewModel globalAlignViewModel) {
        if (globalAlignViewModel.isColorPPM()) {
            this.ppmButton.setSelected(true);
        } else {
            this.refColorButton.setSelected(true);
        }
    }

    protected void changeDefault() {
        GlobalAlignViewModel globalAlignViewModel = new GlobalAlignViewModel();
        this.updateValue(globalAlignViewModel);
    }

    public boolean check() {
        return true;
    }

    protected void updateParameters() {
        if (this.ppmButton.isSelected()) {
            this.globalAlignViewModel.setColorType(2);
        } else {
            this.globalAlignViewModel.setColorType(1);
        }
    }
}

