/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class GlobalAlignContext
implements Cloneable {
    private static final String FONT_NAME = "Times New Roman";
    private static final int FONT_STYLE = 3;
    private static final int LABEL_FONT_STYLE = 1;
    private static final double DEFAULT_MARGIN_TOP = 30.0;
    private static final double DEFAULT_MARGIN_BOTTOM = 10.0;
    private static final double DEFAULT_MARGIN_LEFT = 20.0;
    private static final double DEFAULT_MARGIN_RIGHT = 20.0;
    private static final double DEFAULT_ORGANISM_INTERVAL_X = 5.0;
    private static final double DEFAULT_SCALE_INTERVAL_Y = 20.0;
    private static final double DEFAULT_GENOME_INTERVAL_Y = 40.0;
    private static final double DEFAULT_GENE_HEIGHT = 10.0;
    private static final double DEFAULT_INTRON_HEIGHT = 2.0;
    private static final double DEFAULT_GENE_DIRECTION_WIDTH = 10.0;
    private static final double DEFAULT_GENE_DIRECTION_HEIGHT = 13.0;
    private static final Color DEFAULT_GENE_BORDER_COLOR = Color.lightGray;
    private static final double DEFAULT_GENOME_LINE_GENE_MARGIN = 2.0;
    private static final double DEFAULT_LABEL_MARGIN = 2.0;
    private static final double DEFAULT_LABEL_TO_LABEL_MARGIN = 2.0;
    private static final double DEFAULT_SCALE_HEIGHT = 5.0;
    private static final float DEFAULT_FONT_SIZE = 13.5f;
    private static final float DEFAULT_LABEL_FONT_SIZE = 10.0f;
    private static final Color DEFAULT_NON_CORE_COLOR = Color.lightGray;
    private static final boolean DEFAULT_DRAW_EFFICIENT = false;
    private static final Color DEFAULT_HIDE_GENE = new Color(250, 250, 250);
    private double drawWidth;
    private double drawHeight;
    private double marginTop = 30.0;
    private double marginBottom = 10.0;
    private double marginLeft = 20.0;
    private double marginRight = 20.0;
    private double organismIntervalX = 5.0;
    private double scaleIntervalY = 20.0;
    private double genomeIntervalY = 40.0;
    private double geneHeight = 10.0;
    private double intronHeight = 2.0;
    private double geneDirectionWidth = 10.0;
    private double geneDirectionHeight = 13.0;
    private Color geneBorderColor = DEFAULT_GENE_BORDER_COLOR;
    private double genomeLineGeneMargin = 2.0;
    private double labelMargin = 2.0;
    private double labelToLabelMargin = 2.0;
    private double scaleHeight = 5.0;
    private float fontSize = 13.5f;
    private float labelFontSize = 10.0f;
    private Color nonCoreColor = DEFAULT_NON_CORE_COLOR;
    private boolean drawEfficient = false;
    private Color hideGeneColor = DEFAULT_HIDE_GENE;
    private double organismNameWidth;
    private double scaleX;
    private List genomeLineStartYList = new ArrayList();

    GlobalAlignContext() {
    }

    double getDrawWidth() {
        return this.drawWidth;
    }

    void setDrawWidth(double d) {
        this.drawWidth = d;
    }

    double getDrawHeight() {
        return this.drawHeight;
    }

    void setDrawHeight(double d) {
        this.drawHeight = d;
    }

    double getMarginTop() {
        return this.marginTop;
    }

    void setMarginTop(double d) {
        this.marginTop = d;
    }

    double getMarginBottom() {
        return this.marginBottom;
    }

    void setMarginBottom(double d) {
        this.marginBottom = d;
    }

    double getMarginLeft() {
        return this.marginLeft;
    }

    void setMarginLeft(double d) {
        this.marginLeft = d;
    }

    double getMarginRight() {
        return this.marginRight;
    }

    void setMarginRight(double d) {
        this.marginRight = d;
    }

    double getOrganismIntervalX() {
        return this.organismIntervalX;
    }

    void setOrganismIntervalX(double d) {
        this.organismIntervalX = d;
    }

    double getScaleIntervalY() {
        return this.scaleIntervalY;
    }

    void setScaleIntervalY(double d) {
        this.scaleIntervalY = d;
    }

    double getGenomeIntervalY() {
        return this.genomeIntervalY;
    }

    void setGenomeIntervalY(double d) {
        this.genomeIntervalY = d;
    }

    double getGeneHeight() {
        return this.geneHeight;
    }

    double getGeneHeightIncludeMargin() {
        return this.getGeneHeight() + this.getGenomeLineGeneMargin();
    }

    double getGeneDirectionHeightIncludeMargin() {
        return this.getGeneDirectionHeight() + this.getGenomeLineGeneMargin();
    }

    double getIntronHeight() {
        return this.intronHeight;
    }

    void setIntronHeight(double d) {
        this.intronHeight = d;
    }

    double getIntronMargin() {
        return (this.getGeneHeight() - this.getIntronHeight()) / 2.0;
    }

    double getLabelToLabelMargin() {
        return this.labelToLabelMargin;
    }

    void setLabelToLabelMargin(double d) {
        this.labelToLabelMargin = d;
    }

    void setGeneHeight(double d) {
        this.geneHeight = d;
    }

    double getGenomeLineGeneMargin() {
        return this.genomeLineGeneMargin;
    }

    private double getGeneDirectionWidth() {
        return this.geneDirectionWidth;
    }

    double getGeneDirectionWidth(double d) {
        if (d <= 1.0) {
            return 0.0;
        }
        if (d <= this.getGeneDirectionWidth()) {
            return d / 2.0;
        }
        return this.getGeneDirectionWidth();
    }

    void setGeneDirectionWidth(double d) {
        this.geneDirectionWidth = d;
    }

    double getGeneDirectionHeight() {
        return this.geneDirectionHeight;
    }

    void setGeneDirectionHeight(double d) {
        this.geneDirectionHeight = d;
    }

    Color getGeneBorderColor() {
        return this.geneBorderColor;
    }

    void setGeneBorderColor(Color color) {
        this.geneBorderColor = color;
    }

    void setGenomeLineGeneMargin(double d) {
        this.genomeLineGeneMargin = d;
    }

    double getLabelMargin() {
        return this.labelMargin;
    }

    void setLabelMargin(double d) {
        this.labelMargin = d;
    }

    double getGeneCenterPositionFromGenomeLine() {
        return this.getGeneHeight() / 2.0 + this.getGenomeLineGeneMargin();
    }

    double getScaleHeight() {
        return this.scaleHeight;
    }

    void setScaleHeight(double d) {
        this.scaleHeight = d;
    }

    Color getNonCoreColor() {
        return this.nonCoreColor;
    }

    void setNonCoreColor(Color color) {
        this.nonCoreColor = color;
    }

    float getFontSize() {
        return this.fontSize;
    }

    void setFontSize(float f) {
        this.fontSize = f;
    }

    float getLabelFontSize() {
        return this.labelFontSize;
    }

    void setLabelFontSize(float f) {
        this.labelFontSize = f;
    }

    boolean isDrawEfficient() {
        return this.drawEfficient;
    }

    void setDrawEfficient(boolean bl) {
        this.drawEfficient = bl;
    }

    Color getHideGeneColor() {
        return this.hideGeneColor;
    }

    void setHideGeneColor(Color color) {
        this.hideGeneColor = color;
    }

    double getOrganismNameWidth() {
        return this.organismNameWidth;
    }

    void setOrganismNameWidth(double d) {
        this.organismNameWidth = d;
    }

    double getScaleX() {
        return this.scaleX;
    }

    void setScaleX(double d) {
        this.scaleX = d;
    }

    List getGenomeLineStartYList() {
        return this.genomeLineStartYList;
    }

    double getGenomeLineStartY(int n) {
        return (Double)this.genomeLineStartYList.get(n);
    }

    void setGenomeLineStartYList(List list) {
        this.genomeLineStartYList = list;
    }

    double getAlignStartX() {
        return this.getMarginLeft() + this.getOrganismNameWidth() + this.getOrganismIntervalX();
    }

    Font createFont() {
        return new Font(FONT_NAME, 3, (int)this.getFontSize());
    }

    Font createLabelFont() {
        return new Font(FONT_NAME, 1, (int)this.getLabelFontSize());
    }

    double getLabelRowHeight() {
        return (double)this.getLabelFontSize() * 1.2;
    }

    double getGenomeLineStartY() {
        return this.getMarginTop() + this.getScaleHeight() + this.getScaleIntervalY();
    }

    double getScaleStartY() {
        return this.getMarginTop() + this.getScaleHeight();
    }

    double getAlignDrawWidth() {
        return this.getDrawWidth() - (this.getMarginLeft() + this.getOrganismNameWidth() + this.getOrganismIntervalX() + this.getMarginRight());
    }

    double calcGenomeLineWidth(double d) {
        return d * this.getScaleX();
    }

    double calcX(double d) {
        return d * this.getScaleX();
    }

    double calcLength(double d) {
        return d / this.getScaleX();
    }

    int indexOfOrganism(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = 0;
        double d = this.getGeneHeight();
        if (bl) {
            d = this.getGeneHeight() / 2.0;
        }
        Iterator iterator = this.getGenomeLineStartYList().iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next();
            if ((double)n >= d2 - d && (double)n <= d2 + d) {
                bl2 = true;
                break;
            }
            if ((double)n < d2 - d) {
                n2 = -1;
                break;
            }
            ++n2;
        }
        if (bl2) {
            return n2;
        }
        return -1;
    }

    boolean isOrganismTitleX(Point point) {
        return (double)point.x >= this.getMarginLeft() && (double)point.x < this.getAlignStartX();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }
}

