/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class GlobalAlignScaleOptionPanel
extends TabPanel {
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private JRadioButton scalePositionFromCenterButton;
    private JRadioButton scaleReferenceGenomeButton;

    GlobalAlignScaleOptionPanel(Component component, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(component);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createScalePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.updateValue();
    }

    private JPanel createScalePanel() {
        this.scalePositionFromCenterButton = new JRadioButton("Relative position from center");
        this.scaleReferenceGenomeButton = new JRadioButton("Position of reference genome");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.scalePositionFromCenterButton);
        buttonGroup.add(this.scaleReferenceGenomeButton);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Scale"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.scalePositionFromCenterButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.scaleReferenceGenomeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.updateValue(this.globalAlignViewModel);
    }

    protected void changeDefault() {
        GlobalAlignViewModel globalAlignViewModel = new GlobalAlignViewModel();
        this.updateValue(globalAlignViewModel);
    }

    private void updateValue(GlobalAlignViewModel globalAlignViewModel) {
        if (globalAlignViewModel.isScaleCenter()) {
            this.scalePositionFromCenterButton.setSelected(true);
        } else {
            this.scaleReferenceGenomeButton.setSelected(true);
        }
    }

    public boolean check() {
        return true;
    }

    protected void updateParameters() {
        if (this.scalePositionFromCenterButton.isSelected()) {
            this.globalAlignViewModel.setScaleType(1);
        } else {
            this.globalAlignViewModel.setScaleType(2);
        }
    }
}

