/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.AlignGroupComparator;
import cgdp.recog.align.DirArrangeType;
import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignColorType;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignPositionManager;
import cgdp.recog.align.GlobalAlignRange;
import cgdp.recog.align.GlobalAlignRenderer;
import cgdp.recog.align.GlobalAlignScaleType;
import cgdp.recog.align.GlobalAlignZoomListener;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.data.Chromosome;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalAlignViewModel
implements ApplicationPropertyAccessable,
Cloneable {
    private static final boolean DEFAULT_SHOW_CORE = true;
    private static final boolean DEFAULT_SHOW_NON_CORE = true;
    private static final boolean DEFAULT_SHOW_RNA = true;
    private static final boolean DEFAULT_SHOW_CORE_LINE = true;
    private static final boolean DEFAULT_SHOW_NON_CORE_LINE = true;
    private static final boolean DEFAULT_SHOW_CORE_UNIVERSAL = true;
    private static final boolean DEFAULT_SHOW_CORE_ONE_TO_ONE = true;
    private static final boolean DEFAULT_SHOW_NON_CORE_UNIVERSAL = false;
    private static final boolean DEFAULT_SHOW_NON_CORE_ONE_TO_ONE = true;
    private static final boolean DEFAULT_SHOW_NON_CORE_UNIQUE = true;
    private static final int DEFAULT_DIR_ARRANG_TYPE = 2;
    private static final double DEFAULT_ZOOM_SCALE = 1.0;
    private static final double DEFAULT_START_POSITION = 0.0;
    private static final boolean DEFAULT_SHOW_LOCUS_TAG = false;
    private static final boolean DEFAULT_ADJUST_MODE = true;
    private static final boolean DEFAULT_SHOW_GENE_INFO_ON_BROWSER = false;
    private static final boolean DEFAULT_DETAIL_DISPLAY = false;
    private static final double DEFAULT_ZOOM_SCALE_INTERVAL = 2.0;
    private static final int MAX_LABEL_ROW_COUNT = 1;
    private static final int DEFAULT_SCALE_TYPE = 1;
    private static final double MIN_ZOOM_SCALE = 1.0;
    private static final double MAX_ZOOM_SCALE = 4096.0;
    private static final double THRESHOLD_DETAIL_DISPLAY = 0.005;
    private GlobalAlignPositionManager globalAlignPositionManager;
    private GlobalAlign globalAlign;
    private OrganismViewModel organismViewModel;
    private String domClustId;
    private Organism referenceOrganism;
    private boolean showCore = true;
    private boolean showNonCore = true;
    private boolean showRna = true;
    private boolean showCoreLine = true;
    private boolean showNonCoreLine = true;
    private boolean showCoreUniversal = true;
    private boolean showCoreOneToOne = true;
    private boolean showNonCoreUniversal = false;
    private boolean showNonCoreOneToOne = true;
    private boolean showNonCoreUnique = true;
    private int dirArrangeType = 2;
    private boolean showLocusTag = false;
    private int targetShowGlobalAlignGroupCount;
    private double zoomScale = 1.0;
    private double zoomScaleInterval = 2.0;
    private double startPosition = 0.0;
    private Map selectableAreaMap = new HashMap();
    private Set selectedGlobalAlignGroupSet = new HashSet();
    private boolean adjustMode = true;
    private Map centralPositionMap = new HashMap();
    private Map baseCentralPositionMap = new HashMap();
    private boolean showGeneInfoOnBrowser = false;
    private boolean detailDisplay = false;
    private Set reverseChromIdSet = new HashSet();
    private HashMap isReverseChrom = new HashMap();
    private GlobalAlignGroup referenceGlobalAlignGroup;
    private GlobalAlignElement referneceGlobalAlignElement;
    private int scaleType = 1;
    private int colorType = 1;
    private List zoomListeners = new ArrayList();
    private int maxLabelRowCount = 1;
    private CoreCommonParamDTO coreCommonParamDTO;
    private List viewGlobalAlignGroupList = new ArrayList();
    private boolean printZoomAuto = true;
    private double printZoomSpecValue = 1.0;
    private GlobalAlignRenderer globalAlignRenderer;

    public GlobalAlignViewModel() {
        this.organismViewModel = new OrganismViewModel();
        this.globalAlignPositionManager = new GlobalAlignPositionManager(this);
    }

    public GlobalAlignPositionManager getGlobalAlignPositionManager() {
        return this.globalAlignPositionManager;
    }

    public GlobalAlign getGlobalAlign() {
        return this.globalAlign;
    }

    public void setGlobalAlign(GlobalAlign globalAlign) {
        this.globalAlign = globalAlign;
    }

    void initGlobalAlignViewModel() {
        this.initCentralPositionList();
        this.updateAlignGroupStatus();
        this.updateViewPosition();
        this.globalAlignPositionManager.initGenomeLineStartPositionMap();
        this.initStartPosition();
    }

    void initStartPosition() {
        this.setStartPosition(-this.globalAlignPositionManager.getScaleLength() / 2.0);
    }

    OrganismViewModel getOrganismViewModel() {
        return this.organismViewModel;
    }

    private List getViewOrganismList() {
        return this.organismViewModel.getViewOrganismList();
    }

    public void setViewOrganismList(List list) {
        this.organismViewModel.setViewOrganismList(list);
    }

    public List getViewOrganismCodeList() {
        return this.organismViewModel.getViewOrganismCodeList();
    }

    private boolean isAddStrainToName() {
        return this.organismViewModel.isAddStrainToName();
    }

    private void setAddStrainToName(boolean bl) {
        this.organismViewModel.setAddStrainToName(bl);
    }

    private int getOrganismNameType() {
        return this.organismViewModel.getOrganismNameType();
    }

    private void setOrganismNameType(int n) {
        this.organismViewModel.setOrganismNameType(n);
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public boolean isShowCore() {
        return this.showCore;
    }

    public void setShowCore(boolean bl) {
        this.showCore = bl;
    }

    public boolean isShowNonCore() {
        return this.showNonCore;
    }

    public void setShowNonCore(boolean bl) {
        this.showNonCore = bl;
    }

    public boolean isShowRna() {
        return this.showRna;
    }

    public void setShowRna(boolean bl) {
        this.showRna = bl;
    }

    public boolean isShowCoreLine() {
        return this.showCoreLine;
    }

    public void setShowCoreLine(boolean bl) {
        this.showCoreLine = bl;
    }

    public boolean isShowNonCoreLine() {
        return this.showNonCoreLine;
    }

    public void setShowNonCoreLine(boolean bl) {
        this.showNonCoreLine = bl;
    }

    public boolean isShowCoreUniversal() {
        return this.showCoreUniversal;
    }

    public void setShowCoreUniversal(boolean bl) {
        this.showCoreUniversal = bl;
    }

    public boolean isShowCoreOneToOne() {
        return this.showCoreOneToOne;
    }

    public void setShowCoreOneToOne(boolean bl) {
        this.showCoreOneToOne = bl;
    }

    public boolean isShowNonCoreUniversal() {
        return this.showNonCoreUniversal;
    }

    public void setShowNonCoreUniversal(boolean bl) {
        this.showNonCoreUniversal = bl;
    }

    public boolean isShowNonCoreOneToOne() {
        return this.showNonCoreOneToOne;
    }

    public void setShowNonCoreOneToOne(boolean bl) {
        this.showNonCoreOneToOne = bl;
    }

    public boolean isShowNonCoreUnique() {
        return this.showNonCoreUnique;
    }

    public void setShowNonCoreUnique(boolean bl) {
        this.showNonCoreUnique = bl;
    }

    public void setDirArrangeType(int n) {
        this.dirArrangeType = n;
    }

    public int getDirArrangeType() {
        return this.dirArrangeType;
    }

    public boolean isDirArrangePositive() {
        return DirArrangeType.isPositive(this.getDirArrangeType());
    }

    public boolean isDirArrangeConsensusOrtholog() {
        return DirArrangeType.isConsensusOrtholog(this.getDirArrangeType());
    }

    public boolean isDirArrangeReferenceGenome() {
        return DirArrangeType.isReffernceGenome(this.getDirArrangeType());
    }

    public boolean isShowLocusTagForView() {
        return this.showLocusTag && this.isShowLocusTagForZoom() && this.getMaxLabelRowCount() != 0;
    }

    private boolean isShowLocusTagForZoom() {
        return this.isDetailDisplay();
    }

    public boolean isShowLocusTag() {
        return this.showLocusTag;
    }

    public void setShowLocusTag(boolean bl) {
        this.showLocusTag = bl;
    }

    private void updateViewGlobalAlignGroupList() {
        this.viewGlobalAlignGroupList.clear();
        for (GlobalAlignGroup globalAlignGroup : this.globalAlign.getGlobalAlignGroupList()) {
            if (!this.isShowGene(globalAlignGroup)) continue;
            this.viewGlobalAlignGroupList.add(globalAlignGroup);
        }
        this.updateViewGlobalAlignGroupListOrder();
    }

    public void updateViewGlobalAlignGroupListOrder() {
        Organism organism = this.getReferenceOrganism();
        Collections.sort(this.viewGlobalAlignGroupList, new GroupListComparator(organism));
    }

    public boolean isShowGene(GlobalAlignGroup globalAlignGroup) {
        if (!this.isShowCore() && globalAlignGroup.isCore()) {
            return false;
        }
        if (!this.isShowNonCore() && globalAlignGroup.isNonCore()) {
            return false;
        }
        if (!this.isShowRna() && globalAlignGroup.isRna()) {
            return false;
        }
        return !this.isShowNonCore() || !globalAlignGroup.isNonCore() || !this.isShowNonCoreUnique() || globalAlignGroup.isUnique();
    }

    public boolean isShowOrthologLine(GlobalAlignGroup globalAlignGroup) {
        if (globalAlignGroup.isCore()) {
            if (!this.isShowCoreLine()) {
                return false;
            }
            if (this.isShowCoreUniversal() && !globalAlignGroup.isUniversal()) {
                return false;
            }
            if (this.isShowCoreOneToOne() && !globalAlignGroup.isOneToOne()) {
                return false;
            }
        }
        if (globalAlignGroup.isNonCore()) {
            if (!this.isShowNonCoreLine()) {
                return false;
            }
            if (this.isShowNonCoreUniversal() && !globalAlignGroup.isUniversal()) {
                return false;
            }
            if (this.isShowNonCoreUnique() && !globalAlignGroup.isUnique()) {
                return false;
            }
            if (this.isShowNonCoreOneToOne() && !globalAlignGroup.isOneToOne()) {
                return false;
            }
        }
        return true;
    }

    public int getTargetShowGlobalAlignGroupCount() {
        return this.targetShowGlobalAlignGroupCount;
    }

    private void updateTargetGlobalAlignGroupCount() {
        int n = 0;
        for (GlobalAlignGroup globalAlignGroup : this.globalAlign.getGlobalAlignGroupList()) {
            if (!this.isShowGene(globalAlignGroup) || !globalAlignGroup.isCore()) continue;
            ++n;
        }
        this.targetShowGlobalAlignGroupCount = n;
    }

    void updateViewPosition() {
        this.globalAlignPositionManager.reverseGenome();
        this.globalAlignPositionManager.updateViewPosition();
    }

    GlobalAlignGroup getReferenceGlobalAlignGroup() {
        return this.referenceGlobalAlignGroup;
    }

    void setReferenceGlobalAlignGroup(GlobalAlignGroup globalAlignGroup) {
        this.referenceGlobalAlignGroup = globalAlignGroup;
    }

    public GlobalAlignElement getReferneceGlobalAlignElement() {
        return this.referneceGlobalAlignElement;
    }

    public void setReferneceGlobalAlignElement(GlobalAlignElement globalAlignElement) {
        this.referneceGlobalAlignElement = globalAlignElement;
    }

    List getViewGlobalAlignElementList(String string) {
        return this.globalAlignPositionManager.getViewGlobalAlignElementList(string);
    }

    public void setZoomScale(double d) {
        this.zoomScale = d;
    }

    public boolean isSetZoominScale() {
        return this.getZoomScale() * this.getZoomScaleInterval() <= 4096.0;
    }

    public boolean isSetZoomoutScale() {
        return this.getZoomScale() / this.getZoomScaleInterval() >= 1.0;
    }

    public double getZoomScale() {
        return this.zoomScale;
    }

    public double getZoomScaleInterval() {
        return this.zoomScaleInterval;
    }

    public void setZoomScaleInterval(double d) {
        this.zoomScaleInterval = d;
    }

    public double getZoominScale() {
        double d = this.getZoomScale() * this.getZoomScaleInterval();
        if (d > 4096.0) {
            d = 4096.0;
        }
        return d;
    }

    public double getZoomoutScale() {
        double d = this.getZoomScale() / this.getZoomScaleInterval();
        if (d < 1.0) {
            d = 1.0;
        }
        return d;
    }

    public double getStartPosition() {
        return this.startPosition;
    }

    public double getViewStartPosition(String string, int n) {
        String string2 = this.getReferenceOrganism().getOrganismCode();
        double d = this.getMainCentralPosition(string2);
        double d2 = this.getCentralPosition(string, n);
        double d3 = this.getStartPosition();
        return d3 + (d2 - d);
    }

    public void setStartPosition(double d) {
        System.err.println("STARTPOS:" + d);
        this.startPosition = d;
    }

    public Map getSelectableAreaMap() {
        return this.selectableAreaMap;
    }

    public void setSelectableAreaMap(Map map) {
        this.selectableAreaMap = map;
    }

    public GlobalAlignElement getGlobalAlignElement(String string, int n) {
        List list = (List)this.selectableAreaMap.get(string);
        if (list == null) {
            return null;
        }
        for (GlobalAlignRange globalAlignRange : list) {
            if (globalAlignRange.contains(n)) {
                return globalAlignRange.getGlobalAlignElement();
            }
            if (!globalAlignRange.less(n)) continue;
            break;
        }
        return null;
    }

    public void setShowGeneInfoOnBrowser(boolean bl) {
        this.showGeneInfoOnBrowser = bl;
    }

    public boolean isShowGeneInfoOnBrowser() {
        return this.showGeneInfoOnBrowser;
    }

    public void addZoomListener(GlobalAlignZoomListener globalAlignZoomListener) {
        this.zoomListeners.add(globalAlignZoomListener);
    }

    public void removeZoomListener(GlobalAlignZoomListener globalAlignZoomListener) {
        this.zoomListeners.remove(globalAlignZoomListener);
    }

    public void notifyZoom() {
        for (GlobalAlignZoomListener globalAlignZoomListener : this.zoomListeners) {
            globalAlignZoomListener.zoomAfter();
        }
    }

    public boolean isViewAbstract() {
        return !this.isDetailDisplay();
    }

    public boolean isViewGeneDetail() {
        return this.isDetailDisplay();
    }

    void initCentralPositionList() {
        this.centralPositionMap.clear();
        this.baseCentralPositionMap.clear();
        for (Organism organism : this.getGlobalAlign().getOrganismList()) {
            String string = organism.getOrganismCode();
            List list = this.globalAlign.getChromosomeList(string);
            HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
            for (Chromosome chromosome : list) {
                if (chromosome.isCircular()) {
                    hashMap.put(new Integer(chromosome.getId()), new Double(0.0));
                    continue;
                }
                hashMap.put(new Integer(chromosome.getId()), new Double(0.0));
            }
            this.centralPositionMap.put(string, hashMap);
            this.baseCentralPositionMap.put(string, new HashMap(hashMap));
        }
    }

    private void clearBaseCentralPositionList() {
        this.baseCentralPositionMap.clear();
    }

    void saveCentralPosition() {
        this.clearBaseCentralPositionList();
        for (String string : this.centralPositionMap.keySet()) {
            Map map = (Map)this.centralPositionMap.get(string);
            this.baseCentralPositionMap.put(string, new HashMap(map));
        }
    }

    void setCentralPosition(String string, int n, double d) {
        Map map = (Map)this.centralPositionMap.get(string);
        map.put(new Integer(n), new Double(d));
    }

    void printCentralPositions() {
        System.err.println("**** CentralPositions");
        for (String string : this.centralPositionMap.keySet()) {
            System.err.println(string + ": " + this.centralPositionMap.get(string));
        }
    }

    void recoverCentralPosition() {
        this.centralPositionMap.clear();
        for (String string : this.baseCentralPositionMap.keySet()) {
            Map map = (Map)this.baseCentralPositionMap.get(string);
            this.centralPositionMap.put(string, new HashMap(map));
        }
        this.updateViewPosition();
    }

    void setBaseCentralPosition(String string, int n, double d) {
        Map map = (Map)this.baseCentralPositionMap.get(string);
        map.put(new Integer(n), new Double(d));
    }

    void changeChromosomePosition(String string, int n) {
        this.getGlobalAlign().changeChromosomePosition(string, n);
    }

    double getCentralPosition(String string, int n) {
        Map map = (Map)this.centralPositionMap.get(string);
        return (Double)map.get(new Integer(n));
    }

    double getCentralViewPosition(String string, int n) {
        if (this.isAdjustMode()) {
            return 0.0;
        }
        double d = this.getCentralPosition(string, n);
        return d;
    }

    double leftMostCoodinate(Chromosome chromosome) {
        if (chromosome.isCircular()) {
            return (double)chromosome.getLength() / 2.0;
        }
        return 0.0;
    }

    double getBaseCentralPosition(String string, int n) {
        Map map = (Map)this.baseCentralPositionMap.get(string);
        return (Double)map.get(new Integer(n));
    }

    private double getMainCentralPosition(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        if (chromosome == null) {
            return 0.0;
        }
        return this.getCentralPosition(string, chromosome.getId());
    }

    private void setMainCentralPosition(String string, double d) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        if (chromosome == null) {
            return;
        }
        this.setCentralPosition(string, chromosome.getId(), d);
    }

    private double getOriginalPosition(String string, int n) {
        Map map = (Map)this.baseCentralPositionMap.get(string);
        return (Double)map.get(new Integer(n));
    }

    private double getMainOriginalPosition(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        if (chromosome == null) {
            return 0.0;
        }
        return this.getOriginalPosition(string, chromosome.getId());
    }

    void updatePositionForChangeReferenceGenome() {
        Organism organism = this.getReferenceOrganism();
        String string = organism.getOrganismCode();
        double d = this.getMainOriginalPosition(string);
        double d2 = this.getMainCentralPosition(string);
        double d3 = d2 - d;
        this.globalAlignPositionManager.reverseGenome();
        this.updateViewPosition();
    }

    List getGlobalAlignElementList(String string, List list) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        ArrayList arrayList = new ArrayList();
        for (GlobalAlignGroup globalAlignGroup : list) {
            ArrayList<GlobalAlignElement> arrayList2 = new ArrayList<GlobalAlignElement>();
            if (!this.isAdjustMode()) {
                arrayList2.addAll(globalAlignGroup.getAlignElementList(string));
            } else {
                for (GlobalAlignElement globalAlignElement : globalAlignGroup.getAlignElementList(string)) {
                    if (!this.isAdjustMode() || !chromosome.equalsChromId(globalAlignElement.getChromID())) continue;
                    arrayList2.add(globalAlignElement);
                }
            }
            if (this.isShowCore() && globalAlignGroup.isCore()) {
                arrayList.addAll(arrayList2);
            }
            if (this.isShowNonCore() && globalAlignGroup.isNonCore()) {
                arrayList.addAll(arrayList2);
            }
            if (!this.isShowRna() || !globalAlignGroup.isRna()) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    List getViewGlobalAlignGroupList() {
        return this.viewGlobalAlignGroupList;
    }

    void clearSelectGlobalAlignGroup() {
        this.selectedGlobalAlignGroupSet.clear();
    }

    void setSelectGlobalAlignGroup(GlobalAlignGroup globalAlignGroup) {
        this.clearSelectGlobalAlignGroup();
        this.selectedGlobalAlignGroupSet.add(globalAlignGroup);
    }

    void setSelectGlobalAlignGroupSet(Set set) {
        this.clearSelectGlobalAlignGroup();
        this.selectedGlobalAlignGroupSet.addAll(set);
    }

    public Set getSelectedGlobalAlignGroupSet() {
        return this.selectedGlobalAlignGroupSet;
    }

    boolean isExistSelectedGlobalAlignGroup() {
        return !this.selectedGlobalAlignGroupSet.isEmpty();
    }

    Organism getReferenceOrganism() {
        return this.referenceOrganism;
    }

    String getReferenceOrganismCode() {
        return this.getReferenceOrganism().getOrganismCode();
    }

    void setReferenceOrganism(Organism organism) {
        this.referenceOrganism = organism;
    }

    void setReferenceOrganismCode(String string) {
        Organism organism = this.organismViewModel.getOrganism(string);
        if (organism != null) {
            this.setReferenceOrganism(organism);
        }
    }

    void processAfterUpdateOrganism() {
        Collections.sort(this.getGlobalAlign().getGlobalAlignGroupList(), new AlignGroupComparator(this.referenceOrganism.getOrganismCode(), this.organismViewModel.getViewOrganismCodeList(), this.getGlobalAlign()));
    }

    boolean isReferenceOrganism(String string) {
        return this.getReferenceOrganism().getOrganismCode().equals(string);
    }

    void updateAlignGroupStatus() {
        this.getGlobalAlign().updateAlignGroupStatus(this.getOrganismViewModel().getViewOrganismCodeList());
        this.updateViewGlobalAlignGroupList();
        this.updateTargetGlobalAlignGroupCount();
    }

    int getMaxLabelRowCount() {
        return this.maxLabelRowCount;
    }

    void setMaxLabelRowCount(int n) {
        this.maxLabelRowCount = n;
    }

    public boolean isAdjustMode() {
        return this.adjustMode;
    }

    public void setAdjustMode(boolean bl) {
        this.adjustMode = bl;
    }

    void changeCoordinateGenePositionByChangeAdjustMode(boolean bl) {
        this.globalAlignPositionManager.changeCoordinateGenePositionByChangeAdjustMode(bl);
    }

    void setCoreCommonParamDTO(CoreCommonParamDTO coreCommonParamDTO) {
        this.coreCommonParamDTO = coreCommonParamDTO;
    }

    boolean updateByCoreCommonParamDTO() {
        if (this.coreCommonParamDTO == null) {
            return false;
        }
        if (!this.coreCommonParamDTO.isUpdate(this.getReferenceOrganism(), this.getViewOrganismList(), this.isAddStrainToName(), this.getOrganismNameType())) {
            return false;
        }
        this.coreCommonParamDTO.setFinish(true);
        this.setReferenceOrganism(this.coreCommonParamDTO.getReferenceOrganism());
        this.setViewOrganismList(this.coreCommonParamDTO.getViewOrganismList());
        this.setAddStrainToName(this.coreCommonParamDTO.isAddStrainToName());
        this.setOrganismNameType(this.coreCommonParamDTO.getOrganismNameType());
        this.processAfterUpdateOrganism();
        this.updateAlignGroupStatus();
        return true;
    }

    public CoreCommonParamDTO createCoreCommonParamDTO() {
        CoreCommonParamDTO coreCommonParamDTO = new CoreCommonParamDTO();
        coreCommonParamDTO.setReferenceOrganism(this.getReferenceOrganism());
        coreCommonParamDTO.setOrganismViewModel(this.createOrganismViewModel());
        return coreCommonParamDTO;
    }

    private OrganismViewModel createOrganismViewModel() {
        OrganismViewModel organismViewModel = new OrganismViewModel();
        organismViewModel.setAddStrainToName(this.isAddStrainToName());
        organismViewModel.setOrganismNameType(this.getOrganismNameType());
        organismViewModel.setViewOrganismList(new ArrayList(this.getViewOrganismList()));
        return organismViewModel;
    }

    void clearCoreCommonParamDTO() {
        this.coreCommonParamDTO = null;
    }

    Set getOrthologGroupSetByCluster(Set set) {
        Set set2 = this.getGlobalAlign().getOrthologGroupSetByCluster(set);
        return set2;
    }

    public Set getCoreOrthologGroupSet() {
        return this.getGlobalAlign().getCoreOrthologGroupSet();
    }

    Set getGlobalAlignGroupSetByCluster(Set set) {
        Set set2 = this.getGlobalAlign().getGlobalAlignGroupSetByCluster(set);
        return set2;
    }

    void updateDetailDisplay(double d, double d2) {
        this.detailDisplay = d2 / d > 0.005;
    }

    private boolean isDetailDisplay() {
        return this.detailDisplay;
    }

    void setReverseChromIdSet(Set set) {
        this.reverseChromIdSet = set;
    }

    void updateReverseChromIdSet(Map map) {
        for (Integer n : map.keySet()) {
            if (((Boolean)map.get(n)).booleanValue()) {
                this.reverseChromIdSet.add(n);
                continue;
            }
            this.reverseChromIdSet.remove(n);
        }
        this.printReverseChromIdSet();
    }

    void printReverseChromIdSet() {
        System.err.println("### Reverse chromosomes");
        for (Integer n : this.reverseChromIdSet) {
            System.err.println(n);
        }
    }

    boolean containsReverseChromId(int n) {
        return this.reverseChromIdSet.contains(new Integer(n));
    }

    boolean isDirectionPosition(GlobalAlignElement globalAlignElement) {
        if (globalAlignElement.isPositive()) {
            return !this.containsReverseChromId(globalAlignElement.getChromID());
        }
        return this.containsReverseChromId(globalAlignElement.getChromID());
    }

    boolean isReverseGenome(int n) {
        return this.containsReverseChromId(n);
    }

    int getScaleType() {
        return this.scaleType;
    }

    void setScaleType(int n) {
        this.scaleType = n;
    }

    boolean isScaleCenter() {
        return GlobalAlignScaleType.isCenter(this.getScaleType());
    }

    boolean isScaleReferenceGenome() {
        return GlobalAlignScaleType.isReferenceGenome(this.getScaleType());
    }

    int getColorType() {
        return this.colorType;
    }

    void setColorType(int n) {
        this.colorType = n;
    }

    boolean isColorRefGenome() {
        return GlobalAlignColorType.isRefGenome(this.getColorType());
    }

    boolean isColorPPM() {
        return GlobalAlignColorType.isPPM(this.getColorType());
    }

    GlobalAlignRenderer getGlobalAlignRenderer() {
        return this.globalAlignRenderer;
    }

    void setGlobalAlignRenderer(GlobalAlignRenderer globalAlignRenderer) {
        this.globalAlignRenderer = globalAlignRenderer;
    }

    boolean isPrintZoomAuto() {
        return this.printZoomAuto;
    }

    void setPrintZoomAuto(boolean bl) {
        this.printZoomAuto = bl;
    }

    void setPrintZoomSpecValue(double d) {
        this.printZoomSpecValue = d;
    }

    double getPrintZoomSpecValue() {
        return this.printZoomSpecValue;
    }

    boolean isLeftCoordinate() {
        return this.isSetZoomoutScale() && this.isAdjustMode();
    }

    boolean isChromCoordinate() {
        return !this.isLeftCoordinate();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public String getCategory() {
        return "GCV";
    }

    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowCore", String.valueOf(this.isShowCore())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowNoneCore", String.valueOf(this.isShowNonCore())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowRNA", String.valueOf(this.isShowRna())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowCoreLine", String.valueOf(this.isShowCoreLine())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowCoreUniv", String.valueOf(this.isShowCoreUniversal())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowCoreOneVsOne", String.valueOf(this.isShowCoreOneToOne())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowNoneCoreLine", String.valueOf(this.isShowNonCoreLine())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowNoneCoreUniv", String.valueOf(this.isShowNonCoreUniversal())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowNoneCoreOneVsOne", String.valueOf(this.isShowNonCoreOneToOne())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowNoneCoreUnique", String.valueOf(this.isShowNonCoreUnique())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVShowLocusTag", String.valueOf(this.isShowLocusTag())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVMaxLabelRowCount", String.valueOf(this.getMaxLabelRowCount())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVDirArrangeType", String.valueOf(this.getDirArrangeType())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVScaleType", String.valueOf(this.getScaleType())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GCVColorType", String.valueOf(this.getColorType())));
        return arrayList;
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        if (map.containsKey("GCVShowCore")) {
            this.setShowCore(new Boolean((String)map.get("GCVShowCore")));
        }
        if (map.containsKey("GCVShowNoneCore")) {
            this.setShowNonCore(new Boolean((String)map.get("GCVShowNoneCore")));
        }
        if (map.containsKey("GCVShowRNA")) {
            this.setShowRna(new Boolean((String)map.get("GCVShowRNA")));
        }
        if (map.containsKey("GCVShowCoreLine")) {
            this.setShowCoreLine(new Boolean((String)map.get("GCVShowCoreLine")));
        }
        if (map.containsKey("GCVShowCoreUniv")) {
            this.setShowCoreUniversal(new Boolean((String)map.get("GCVShowCoreUniv")));
        }
        if (map.containsKey("GCVShowCoreOneVsOne")) {
            this.setShowCoreOneToOne(new Boolean((String)map.get("GCVShowCoreOneVsOne")));
        }
        if (map.containsKey("GCVShowNoneCoreLine")) {
            this.setShowNonCoreLine(new Boolean((String)map.get("GCVShowNoneCoreLine")));
        }
        if (map.containsKey("GCVShowNoneCoreUniv")) {
            this.setShowNonCoreUniversal(new Boolean((String)map.get("GCVShowNoneCoreUniv")));
        }
        if (map.containsKey("GCVShowNoneCoreOneVsOne")) {
            this.setShowNonCoreOneToOne(new Boolean((String)map.get("GCVShowNoneCoreOneVsOne")));
        }
        if (map.containsKey("GCVShowNoneCoreUnique")) {
            this.setShowNonCoreUnique(new Boolean((String)map.get("GCVShowNoneCoreUnique")));
        }
        if (map.containsKey("GCVShowLocusTag")) {
            this.setShowLocusTag(new Boolean((String)map.get("GCVShowLocusTag")));
        }
        if (map.containsKey("GCVMaxLabelRowCount")) {
            this.setMaxLabelRowCount(Integer.parseInt((String)map.get("GCVMaxLabelRowCount")));
        }
        if (map.containsKey("GCVDirArrangeType")) {
            this.setDirArrangeType(Integer.parseInt((String)map.get("GCVDirArrangeType")));
        }
        if (map.containsKey("GCVScaleType")) {
            this.setScaleType(Integer.parseInt((String)map.get("GCVScaleType")));
        }
        if (map.containsKey("GCVColorType")) {
            this.setColorType(Integer.parseInt((String)map.get("GCVColorType")));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupListComparator
    implements Comparator<GlobalAlignGroup> {
        Organism ref_organism;

        GroupListComparator(Organism organism) {
            this.ref_organism = organism;
        }

        @Override
        public int compare(GlobalAlignGroup globalAlignGroup, GlobalAlignGroup globalAlignGroup2) {
            ColorDrawable colorDrawable = ColorFacade.getInstance().getPrimaryColorDrawable(globalAlignGroup.getCluster(), this.ref_organism);
            ColorDrawable colorDrawable2 = ColorFacade.getInstance().getPrimaryColorDrawable(globalAlignGroup2.getCluster(), this.ref_organism);
            if (colorDrawable.getNodeLabel().equals("Base Color") && !colorDrawable2.getNodeLabel().equals("Base Color")) {
                return -1;
            }
            if (colorDrawable2.getNodeLabel().equals("Base Color") && !colorDrawable.getNodeLabel().equals("Base Color")) {
                return 1;
            }
            return 0;
        }
    }
}

