/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.calc.NAType;
import cgdp.recog.util.RestrictTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NAPanel
extends JPanel
implements ActionListener {
    private JRadioButton ignoreButton;
    private JRadioButton aveButton;
    private JRadioButton specButton;
    private RestrictTextField specTextField;

    public NAPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.ignoreButton = new JRadioButton("Ignore");
        this.aveButton = new JRadioButton("Average");
        this.specButton = new JRadioButton("Specified value");
        this.ignoreButton.addActionListener(this);
        this.aveButton.addActionListener(this);
        this.specButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ignoreButton);
        buttonGroup.add(this.aveButton);
        buttonGroup.add(this.specButton);
        this.ignoreButton.setSelected(true);
        this.specTextField = new RestrictTextField(5);
        this.specTextField.setDecimal(true);
        this.specTextField.setNegative(true);
        this.setEnabledSpecTextField();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.ignoreButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.aveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.specButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.specTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
    }

    public void updateValue(int n, double d) {
        this.updateNaType(n);
        this.setEnabledSpecTextField();
        this.specTextField.setText(String.valueOf(d));
    }

    private void updateNaType(int n) {
        this.ignoreButton.setSelected(NAType.isIgnore(n));
        this.aveButton.setSelected(NAType.isAverage(n));
        this.specButton.setSelected(NAType.isSpec(n));
    }

    private void setEnabledSpecTextField() {
        this.specTextField.setEnabled(this.specButton.isSelected());
    }

    public int getNaType() {
        if (this.ignoreButton.isSelected()) {
            return 1;
        }
        if (this.aveButton.isSelected()) {
            return 2;
        }
        return 3;
    }

    public boolean isInputSpecValue() {
        try {
            Double.parseDouble(this.specTextField.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public double getSpecValue() {
        if (!this.isInputSpecValue()) {
            return 0.0;
        }
        return Double.parseDouble(this.specTextField.getText());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ignoreButton || actionEvent.getSource() == this.aveButton || actionEvent.getSource() == this.specButton) {
            this.setEnabledSpecTextField();
        }
    }
}

