/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.calc.CoefCondition;
import cgdp.recog.calc.CoefType;
import cgdp.recog.calc.DistanceComboBox;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoOptionLinkLabel;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ProfilePanel
extends JPanel
implements ActionListener {
    private Component parent;
    private JRadioButton patternButton;
    private JRadioButton genePropButton;
    private InfoTitleComboBox infoTitleComboBox;
    private DistanceComboBox distanceComboBox;
    private JLabel infoOptionLinkLabel;

    public ProfilePanel(Component component) {
        this.parent = component;
        this.init();
    }

    private void init() {
        JLabel jLabel = new JLabel("Type of distance");
        this.distanceComboBox = new DistanceComboBox();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createProfilePanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.distanceComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    private JPanel createProfilePanel() {
        JLabel jLabel = new JLabel("Profile");
        this.patternButton = new JRadioButton("Phylogenetic pattern");
        this.patternButton.addActionListener(this);
        this.genePropButton = new JRadioButton("Property");
        this.genePropButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.patternButton);
        buttonGroup.add(this.genePropButton);
        this.patternButton.setSelected(true);
        this.infoTitleComboBox = new InfoTitleComboBox();
        this.infoOptionLinkLabel = new InfoOptionLinkLabel("Option...", this.parent, this.infoTitleComboBox);
        this.setEnabledInfoTitleComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.patternButton, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.genePropButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.infoTitleComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.infoOptionLinkLabel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(Set set) {
        this.updateInfoTitleMap(set);
        this.setEnabledInfoTitleComboBox();
    }

    public void updateValue(Set set, AbstractInfoTitle abstractInfoTitle, String string) {
        this.updateInfoTitleMap(set);
        if (abstractInfoTitle != null) {
            this.infoTitleComboBox.setSelectedItem(abstractInfoTitle.getKey());
        }
        this.setEnabledInfoTitleComboBox();
        this.distanceComboBox.setSelectedItem(string);
        if (this.distanceComboBox.getSelectedIndex() == -1) {
            this.distanceComboBox.setSelectedIndex(0);
        }
    }

    private void updateInfoTitleMap(Set set) {
        List list = GeneInfoFacade.getGeneInfoTitleList(set);
        list.addAll(CellInfoFacade.getInfoTitleListByAnalysisKey("UseAllAnalysis"));
        list = InfoUtil.filterByType(list, 1);
        this.infoTitleComboBox.updateInfoTitleItems(list);
    }

    public void setSelectPattern(boolean bl) {
        this.patternButton.setSelected(bl);
        this.updateDistComboBox();
    }

    public void setEnabledGenePropButton(boolean bl) {
        this.genePropButton.setEnabled(bl);
    }

    public void setEnabledInfoTitleComboBox() {
        this.infoTitleComboBox.setEnabled(this.genePropButton.isSelected());
        this.infoOptionLinkLabel.setEnabled(this.genePropButton.isSelected());
    }

    private void updateDistComboBox() {
        if (CoefCondition.isPattern(this.getProfile())) {
            this.distanceComboBox.removeAllItems();
            for (int i = 0; i < CoefType.TYPE_DISTANCE_ITEMS.length; ++i) {
                this.distanceComboBox.addItem(CoefType.TYPE_DISTANCE_ITEMS[i]);
            }
        } else {
            this.distanceComboBox.removeAllItems();
            for (int i = 0; i < CoefType.TYPE_DISTANCE_ITEMS_FOR_PROPERTY.length; ++i) {
                this.distanceComboBox.addItem(CoefType.TYPE_DISTANCE_ITEMS_FOR_PROPERTY[i]);
            }
        }
    }

    public int getProfile() {
        int n = 1;
        if (this.genePropButton.isSelected()) {
            n = 2;
        }
        return n;
    }

    public int getDistTypeForHClust() {
        return this.distanceComboBox.getDistTypeForHClust();
    }

    public String getDistType() {
        return this.distanceComboBox.getDistType();
    }

    public AbstractInfoTitle getInfoTitle() {
        return this.infoTitleComboBox.getSelectedInfoTitle();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.patternButton || actionEvent.getSource() == this.genePropButton) {
            this.setEnabledInfoTitleComboBox();
            this.updateDistComboBox();
        }
    }
}

