/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

abstract class AbstractColorDrawable
implements ColorDrawable {
    protected MediatorImpl mediator;
    protected ClusterTbl clusterTbl;
    private int type = -1;
    private boolean active = true;
    protected Color borderLineColor;

    AbstractColorDrawable(MediatorImpl mediatorImpl, int n) {
        this.mediator = mediatorImpl;
        this.setType(n);
        this.init();
    }

    private void init() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        this.borderLineColor = ColorUtil.str2Color(optionValues.getBorderLineColorString());
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public Color getOutergroupColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getOutergroupColorString());
    }

    public Color getOutgroupAsIngroupColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getOutgroupIngroupColorString());
    }

    public boolean isShowOutgroupAsIngroup() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return optionValues.isOutgroupAsIngroupFlag();
    }

    public Color getSearchResultColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getSearchResultColorString());
    }

    public Color getGeneCountCellColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getGeneCountColor());
    }

    public boolean isShowGeneCountColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return optionValues.isGeneCountColorFlag();
    }

    public int getThresholdGeneCount() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return optionValues.getGeneCountColorMinCount();
    }

    public Color getBackgroundCellColor(Organism organism) {
        return this.getBackgroundCellColor(organism.getOrganismCode());
    }

    public Color getBackgroundCellColor(String string) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = this.getIngroupColor();
        Color color2 = ColorUtil.str2Color(optionValues.getOutgroupColorString());
        return this.clusterTbl.isOutgroup(string) ? color2 : color;
    }

    protected Color getIngroupColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getIngroupColorString());
        return color;
    }

    public Color getSelectLine1Color() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getSelectLine1ColorString());
    }

    public Color getSelectLine2Color() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return ColorUtil.str2Color(optionValues.getSelectLine2ColorString());
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setColorActive(boolean bl) {
        this.active = bl;
    }

    public boolean isColorActive() {
        return this.active;
    }

    public void flipColorActive() {
        this.setColorActive(!this.isColorActive());
    }

    protected void drawLocusTag(Graphics2D graphics2D, double d, double d2, double d3, List list, Color color) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(this.getLabelColor(d + 1.0, d2 + 1.0, color));
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            string = StringTool.adjustStringForDraw(fontMetrics, string, (int)d3, false);
            int n = (int)this.getDrawLabelStartX(fontMetrics, d, d3, string);
            graphics2D.drawString(string, n, (int)d2);
            d2 += (double)fontMetrics.getAscent();
        }
    }

    protected double getDrawLabelStartX(FontMetrics fontMetrics, double d, double d2, String string) {
        return d + d2 / 2.0 - (double)(fontMetrics.stringWidth(string) / 2);
    }

    private Color getLabelColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[1];
        float f2 = fArray[2];
        if (f2 >= f) {
            return Color.black;
        }
        return Color.white;
    }

    private Color getColor(int n, int n2, BufferedImage bufferedImage) {
        if (n >= 0 && n < bufferedImage.getWidth() && n2 >= 0 && n2 < bufferedImage.getHeight()) {
            return new Color(bufferedImage.getRGB(n, n2));
        }
        return Color.black;
    }

    private Color getLabelColor(double d, double d2, Color color) {
        return this.getLabelColor(color);
    }

    public boolean isEnablePPMLabel() {
        return false;
    }

    public Color getPPMLabelColor(Cluster cluster, int n) {
        return null;
    }
}

