/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.data.Cluster;
import cgdp.recog.organism.Organism;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

class BlankColorDrawable
extends AbstractColorDrawable {
    private static final Color BACKGROUND_COLOR = Color.white;

    BlankColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 931);
    }

    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        graphics2D.setColor(BACKGROUND_COLOR);
        graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        return BACKGROUND_COLOR;
    }

    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
    }

    public Color getColor(Cluster cluster, String string, String string2) {
        return this.getColor();
    }

    public Color getColor() {
        return null;
    }

    public static Color getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    public String getNodeLabel() {
        return "Blank";
    }

    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        return true;
    }

    public boolean isSyncEnable() {
        return false;
    }
}

