/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.MultiInfoCondition;
import cgdp.recog.info.MultiType;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.property.PropertyCondition;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneColorCondition
implements PropertyCondition,
MultiInfoCondition {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneColorCondition.class);
    public static final int ORDER_ORDER = 1;
    public static final int ORDER_VALUE = 2;
    private List colorValueList = new ArrayList();
    private Map colorValueMap = new HashMap();
    private Set organismCodeSet = new HashSet();
    private AbstractInfoTitle infoTitle;
    private int orderType = 1;
    private int multiInfoType = 1;
    private Map organismGeneInfoMap = new HashMap();
    private Map organismCellInfoMap = new HashMap();
    private Map clusterInfoMap = new HashMap();

    void addGeneInfoMap(String string, Map map) {
        this.organismGeneInfoMap.put(string, map);
    }

    void addOrganismCellInfoMap(String string, Map map) {
        this.organismCellInfoMap.put(string, map);
    }

    void setClusterInfoMap(Map map) {
        this.clusterInfoMap = map;
    }

    public int getColorValueCount() {
        return this.colorValueList.size();
    }

    ColorValue getColorValue(int n) {
        return (ColorValue)this.colorValueList.get(n);
    }

    public void setColorValue(int n, double d) {
        ColorValue colorValue = this.getColorValue(n);
        colorValue.setValue(new Float(d));
    }

    public List getColorValueList() {
        return this.colorValueList;
    }

    public List getCopyColorValueList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColorValue colorValue : this.getColorValueList()) {
            arrayList.add(colorValue.clone());
        }
        return arrayList;
    }

    public void setColorValueList(List list) {
        this.colorValueList = new ArrayList(list);
        this.initColorValueMap(list);
    }

    private void initColorValueMap(List list) {
        this.colorValueMap.clear();
        for (ColorValue colorValue : list) {
            this.colorValueMap.put(colorValue.getValue(), colorValue);
        }
    }

    public void setMinValue(double d) {
        this.setColorValue(0, d);
    }

    public double getMinValue() {
        return this.getMinColorValue().getValueAsDouble();
    }

    private ColorValue getMinColorValue() {
        return this.getColorValue(0);
    }

    public void setMaxValue(double d) {
        this.setColorValue(this.colorValueList.size() - 1, d);
    }

    public double getMaxValue() {
        return this.getMaxColorValue().getValueAsDouble();
    }

    private ColorValue getMaxColorValue() {
        return this.getColorValue(this.colorValueList.size() - 1);
    }

    public AbstractInfoTitle getInfoTitle() {
        return this.infoTitle;
    }

    public void setInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.infoTitle = abstractInfoTitle;
    }

    public void setOrganismCodeSet(Set set) {
        this.organismCodeSet = set;
    }

    public Set getOrganismCodeSet() {
        return this.organismCodeSet;
    }

    void addAllOrganismCode(Set set) {
        this.organismCodeSet.addAll(set);
    }

    public void removeOrganismCode(String string) {
        this.organismCodeSet.remove(string);
        this.organismGeneInfoMap.remove(string);
        this.organismCellInfoMap.remove(string);
    }

    public int getOrderType() {
        return this.orderType;
    }

    public void setOrderType(int n) {
        this.orderType = n;
    }

    public boolean isOrder() {
        return this.getOrderType() == 1;
    }

    public boolean isValue() {
        return this.getOrderType() == 2;
    }

    public int getMultiInfoType() {
        return this.multiInfoType;
    }

    public void setMultiInfoType(int n) {
        this.multiInfoType = n;
    }

    public boolean isMultiGeneInfoMax() {
        return MultiType.isMax(this.getMultiInfoType());
    }

    public boolean isMultiGeneInfoMin() {
        return MultiType.isMin(this.getMultiInfoType());
    }

    public boolean isMultiGeneInfoMedian() {
        return MultiType.isMedian(this.getMultiInfoType());
    }

    public boolean isMultiGeneInfoAve() {
        return MultiType.isAve(this.getMultiInfoType());
    }

    public int indexOfElement(Object object) {
        return this.getInfoTitle().indexOfElement(object);
    }

    public boolean isAsc() {
        return true;
    }

    public Color getColor(String string, Cluster cluster) {
        Object object;
        Cluster cluster2 = cluster;
        if (cluster instanceof SuperCluster && CollectionUtil.isNull((Collection)(object = ((SuperCluster)cluster).getSubClusterList()))) {
            return null;
        }
        object = (Map)this.organismCellInfoMap.get(string);
        if (MapUtil.isNull((Map)object)) {
            return null;
        }
        CellInfo cellInfo = (CellInfo)object.get(cluster2);
        if (cellInfo == null) {
            return null;
        }
        return this.getColor(cellInfo);
    }

    public Color getColor(Cluster cluster) {
        ClusterInfo clusterInfo = (ClusterInfo)this.clusterInfoMap.get(cluster);
        if (clusterInfo == null) {
            return null;
        }
        return this.getColor(clusterInfo);
    }

    public Color getColor(String string, String string2) {
        Map map = (Map)this.organismGeneInfoMap.get(string);
        if (MapUtil.isNull(map)) {
            return null;
        }
        GeneInfo geneInfo = (GeneInfo)map.get(string2);
        if (geneInfo == null) {
            return null;
        }
        return this.getColor(geneInfo);
    }

    private Color getColor(AbstractInfo abstractInfo) {
        if (this.getInfoTitle().isNumeric()) {
            Float f = (Float)GeneInfoMultiInfoManager.getValue(this, abstractInfo);
            if (f == null) {
                return null;
            }
            double d = f.doubleValue();
            ColorValue colorValue = this.getMinColorValue();
            if (colorValue.getValueByOrder(this.getOrderType()) >= d) {
                return colorValue.getColor();
            }
            ColorValue colorValue2 = this.getMaxColorValue();
            if (colorValue2.getValueByOrder(this.getOrderType()) <= d) {
                return colorValue2.getColor();
            }
            if (Double.isNaN(d)) {
                return colorValue.getColor();
            }
            ColorValue[] colorValueArray = this.getBothEndsColors(d);
            Color color = colorValueArray[0].getColor();
            Color color2 = colorValueArray[1].getColor();
            double d2 = colorValueArray[0].getValueByOrder(this.getOrderType());
            double d3 = colorValueArray[1].getValueByOrder(this.getOrderType());
            int n = this.calcColorComponent(color.getRed(), color2.getRed(), d2, d3, d);
            int n2 = this.calcColorComponent(color.getGreen(), color2.getGreen(), d2, d3, d);
            int n3 = this.calcColorComponent(color.getBlue(), color2.getBlue(), d2, d3, d);
            if (n3 > 255 || n2 > 255 || n > 255 || n3 < 0 || n2 < 0 || n < 0) {
                // empty if block
            }
            return new Color(n, n2, n3);
        }
        if (this.getInfoTitle().isEnum()) {
            Comparable comparable = GeneInfoMultiInfoManager.getValue(this, abstractInfo);
            ColorValue colorValue = (ColorValue)this.colorValueMap.get(comparable);
            Color color = null;
            if (colorValue != null) {
                color = colorValue.getColor();
            }
            return color;
        }
        return null;
    }

    private int calcColorComponent(int n, int n2, double d, double d2, double d3) {
        return (int)((double)(n2 - n) / (d2 - d) * (d3 - d) + (double)n);
    }

    private ColorValue[] getBothEndsColors(double d) {
        for (int i = 1; i < this.colorValueList.size(); ++i) {
            ColorValue colorValue = (ColorValue)this.colorValueList.get(i - 1);
            ColorValue colorValue2 = (ColorValue)this.colorValueList.get(i);
            if (!(colorValue.getValueByOrder(this.getOrderType()) <= d) || !(colorValue2.getValueByOrder(this.getOrderType()) >= d)) continue;
            return new ColorValue[]{colorValue, colorValue2};
        }
        return null;
    }

    public Map createDisplayOptionMap() {
        return null;
    }

    public static boolean isOrder(int n) {
        return n == 1;
    }

    public static boolean isValue(int n) {
        return n == 2;
    }

    public boolean equalsColorValueList(List list) {
        if (CollectionUtil.isNull(this.getColorValueList()) || CollectionUtil.isNull(list)) {
            return false;
        }
        if (this.getColorValueList().size() != list.size()) {
            return false;
        }
        for (int i = 0; i < this.getColorValueList().size(); ++i) {
            ColorValue colorValue;
            ColorValue colorValue2 = (ColorValue)this.getColorValueList().get(i);
            if (colorValue2.equalsColorValue(colorValue = (ColorValue)list.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsCondition(GeneColorCondition geneColorCondition) {
        if (!this.equalsColorValueList(geneColorCondition.getColorValueList())) {
            return false;
        }
        if (!this.getInfoTitle().equals(geneColorCondition.getInfoTitle())) {
            return false;
        }
        if (this.getOrderType() != geneColorCondition.getOrderType()) {
            return false;
        }
        return this.getMultiInfoType() == geneColorCondition.getMultiInfoType();
    }
}

