/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionGroup;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class GeneColorExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneColorExecuter.class);
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private List clusterList;
    private GeneColorCondition geneColorCondition;
    private int calcMethodType = -1;

    public GeneColorExecuter(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, List list, GeneColorCondition geneColorCondition, Color color, int n) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.clusterList = list;
        this.geneColorCondition = geneColorCondition;
        this.calcMethodType = n;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            if (GeneColorConditionGroup.isAllSpecies(this.calcMethodType)) {
                this.executeByAllOrganism(progressImpl);
            } else {
                this.executeByEveryOrganism(progressImpl);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to set ppm color by gene property.", exception);
        }
    }

    private void executeByAllOrganism(ProgressImpl progressImpl) throws Exception {
        Set set = this.geneColorCondition.getOrganismCodeSet();
        int n = set.size() * 2 + 10;
        progressImpl.setTotal(n);
        int n2 = 0;
        AbstractInfoTitle abstractInfoTitle = this.geneColorCondition.getInfoTitle();
        List list = abstractInfoTitle.isGene() ? this.setGeneInfoByAllOrganism(set, progressImpl, n2) : (abstractInfoTitle.isCell() ? this.setCellInfoByAllOrganism(set, progressImpl, n2) : this.setClusterInfoByAllOrganism(set, progressImpl, n2));
        if (progressImpl.isCanceled()) {
            this.setCancel(true);
            return;
        }
        n2 = set.size();
        Collections.sort(list, new InfoComparator(this.geneColorCondition.getInfoTitle()));
        n2 = n - 10;
        progressImpl.setCount(n2);
        progressImpl.increment();
        this.adjustRank(list, this.geneColorCondition);
        n2 = n - 5;
        progressImpl.setCount(n2);
        progressImpl.increment();
        n2 = n - 1;
        progressImpl.setCount(n2);
        progressImpl.increment();
    }

    private List setClusterInfoByAllOrganism(Set set, ProgressImpl progressImpl, int n) {
        Map map = ClusterInfoFacade.createClusterInfoMap(this.clusterList, (ClusterInfoTitle)this.geneColorCondition.getInfoTitle(), ClusterInfoFacade.createClusterInfoCalcCondition(this.clusterTbl));
        n = set.size();
        progressImpl.setCount(n);
        progressImpl.increment();
        this.geneColorCondition.setClusterInfoMap(map);
        ArrayList arrayList = new ArrayList(map.values());
        return arrayList;
    }

    private List setGeneInfoByAllOrganism(Set set, ProgressImpl progressImpl, int n) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (String string : set) {
            Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, this.geneColorCondition.getInfoTitle());
            progressImpl.setCount(++n);
            progressImpl.increment();
            arrayList.addAll(map.values());
            this.geneColorCondition.addGeneInfoMap(string, map);
            progressImpl.setCount(++n);
            progressImpl.increment();
            if (!progressImpl.isCanceled()) continue;
            this.setCancel(true);
            return arrayList;
        }
        return arrayList;
    }

    private void executeByEveryOrganism(ProgressImpl progressImpl) throws Exception {
        Set set = this.geneColorCondition.getOrganismCodeSet();
        int n = set.size() * 2 + 1;
        progressImpl.setTotal(n);
        int n2 = 0;
        AbstractInfoTitle abstractInfoTitle = this.geneColorCondition.getInfoTitle();
        if (abstractInfoTitle.isGene()) {
            this.setGeneInfoByEveryOrganism(set, progressImpl, n2);
        } else if (abstractInfoTitle.isCell()) {
            this.setCellInfoByEveryOrganism(set, progressImpl, n2);
        } else if (abstractInfoTitle.isCluster()) {
            this.setClusterInfoByEveryOrganism(set, progressImpl, n2);
        }
        if (progressImpl.isCanceled()) {
            this.setCancel(true);
            return;
        }
        n2 = n - 1;
        progressImpl.setCount(n2);
        progressImpl.increment();
    }

    private List setCellInfoByAllOrganism(Set set, ProgressImpl progressImpl, int n) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (String string : set) {
            Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)this.geneColorCondition.getInfoTitle());
            progressImpl.setCount(++n);
            progressImpl.increment();
            arrayList.addAll(map.values());
            this.geneColorCondition.addOrganismCellInfoMap(string, map);
            progressImpl.setCount(++n);
            progressImpl.increment();
            if (!progressImpl.isCanceled()) continue;
            this.setCancel(true);
            return arrayList;
        }
        return arrayList;
    }

    private void setCellInfoByEveryOrganism(Set set, ProgressImpl progressImpl, int n) {
        for (String string : set) {
            Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)this.geneColorCondition.getInfoTitle());
            progressImpl.setCount(++n);
            progressImpl.increment();
            ArrayList arrayList = new ArrayList(map.values());
            Collections.sort(arrayList, new InfoComparator(this.geneColorCondition.getInfoTitle()));
            this.adjustRank(arrayList, this.geneColorCondition);
            this.geneColorCondition.addOrganismCellInfoMap(string, map);
            progressImpl.setCount(++n);
            progressImpl.increment();
            if (!progressImpl.isCanceled()) continue;
            this.setCancel(true);
            return;
        }
    }

    private void setClusterInfoByEveryOrganism(Set set, ProgressImpl progressImpl, int n) {
        Map map = ClusterInfoFacade.createClusterInfoMap(this.clusterList, (ClusterInfoTitle)this.geneColorCondition.getInfoTitle(), ClusterInfoFacade.createClusterInfoCalcCondition(this.clusterTbl));
        n = set.size();
        progressImpl.setCount(n);
        progressImpl.increment();
        ArrayList arrayList = new ArrayList(map.values());
        Collections.sort(arrayList, new InfoComparator(this.geneColorCondition.getInfoTitle()));
        this.adjustRank(arrayList, this.geneColorCondition);
        this.geneColorCondition.setClusterInfoMap(map);
    }

    private void setGeneInfoByEveryOrganism(Set set, ProgressImpl progressImpl, int n) throws Exception {
        for (String string : set) {
            Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, this.geneColorCondition.getInfoTitle());
            progressImpl.setCount(++n);
            progressImpl.increment();
            ArrayList arrayList = new ArrayList(map.values());
            Collections.sort(arrayList, new InfoComparator(this.geneColorCondition.getInfoTitle()));
            this.adjustRank(arrayList, this.geneColorCondition);
            this.geneColorCondition.addGeneInfoMap(string, map);
            progressImpl.setCount(++n);
            progressImpl.increment();
            if (!progressImpl.isCanceled()) continue;
            this.setCancel(true);
            return;
        }
    }

    private void adjustRank(List list, GeneColorCondition geneColorCondition) {
        Object object;
        int n;
        if (!geneColorCondition.isOrder() || !geneColorCondition.getInfoTitle().isNumeric()) {
            return;
        }
        double d = -1.7976931348623157E308;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        block0: for (n = 0; n < list.size(); ++n) {
            object = (AbstractInfo)list.get(n);
            Comparable comparable = this.getValue(geneColorCondition, (AbstractInfo)object);
            double d2 = ((Float)comparable).doubleValue();
            if (d2 != d) {
                n3 += n4;
                n4 = 1;
                d = d2;
            } else {
                ++n4;
            }
            ((AbstractInfo)object).putInfo(geneColorCondition.getInfoTitle(), new Integer(n3));
            if (n2 >= geneColorCondition.getColorValueCount()) continue;
            ColorValue colorValue = geneColorCondition.getColorValue(n2);
            while (colorValue.getValueAsDouble() <= d2) {
                colorValue.setIndex(n3);
                if (++n2 >= geneColorCondition.getColorValueCount()) continue block0;
                colorValue = geneColorCondition.getColorValue(n2);
            }
        }
        for (n = n2; n < geneColorCondition.getColorValueCount(); ++n) {
            object = geneColorCondition.getColorValue(n);
            ((ColorValue)object).setIndex(n3);
        }
    }

    private Comparable getValue(GeneColorCondition geneColorCondition, AbstractInfo abstractInfo) {
        return GeneInfoMultiInfoManager.getValue(geneColorCondition, abstractInfo);
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageManager.showErrorMessage((Component)GeneColorExecuter.this.parent, GeneColorExecuter.this.getErrorMessages());
                }
            });
            return;
        }
        this.mediator.updateForGeneColor(this.geneColorCondition, this.calcMethodType);
    }
}

