/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionGroup;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoFacade;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

class GeneColorImporter
extends FileImporter {
    private static final String TITLE_PROPERTY_COLOR_GROUP = "PropertyColorGroup";
    private static final String TITLE_PROPERTY_COLOR = "PropertyColor";
    private static final String KEY_CALC_METHOD_TYPE = "#CalcMethodType";
    private static final String KEY_ORGANISM = "#Organism";
    private static final String KEY_PROPERTY_TYPE = "#PropertyType";
    private static final String KEY_PROPERTY_KEY = "#PropertyKey";
    private static final String KEY_ORDER_TYPE = "#OrderType";
    private static final String KEY_MULTI_INFO_TYPE = "#MultiInfoType";
    private static final String KEY_THRESHOLD = "#Threshold";
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_COMMA = ",";
    private static final String DELIMITER_COLOR_VALUE = ":";
    private static final String SEP_GROUP = "////";
    private static final String SEP_CONDITION = "//";
    private String filepath;
    private GeneColorConditionGroup geneColorConditionGroup;
    private GeneColorCondition geneColorCondition;
    private int cls;
    private boolean createDummyTitle = false;

    GeneColorImporter(String string, GeneColorConditionGroup geneColorConditionGroup) {
        this.filepath = string;
        this.geneColorConditionGroup = geneColorConditionGroup;
        this.setExistHeader(false);
    }

    public void setCreateDummyInfo(boolean bl) {
        this.createDummyTitle = bl;
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void parseDataLine(int n, String string) {
        if (string.startsWith(KEY_CALC_METHOD_TYPE)) {
            int n2 = Integer.parseInt(this.getValue(KEY_CALC_METHOD_TYPE, string));
            this.geneColorConditionGroup.setCalcMethodType(n2);
        } else if (string.startsWith(TITLE_PROPERTY_COLOR) && !string.startsWith(TITLE_PROPERTY_COLOR_GROUP)) {
            this.geneColorCondition = new GeneColorCondition();
        } else if (string.startsWith(KEY_ORGANISM)) {
            HashSet hashSet = new HashSet(StringTool.splitString(this.getValue(KEY_ORGANISM, string), DELIMITER_COMMA));
            this.geneColorCondition.addAllOrganismCode(hashSet);
        } else if (string.startsWith(KEY_PROPERTY_TYPE)) {
            this.cls = Integer.parseInt(this.getValue(KEY_PROPERTY_TYPE, string));
        } else if (string.startsWith(KEY_PROPERTY_KEY)) {
            String string2 = this.getValue(KEY_PROPERTY_KEY, string);
            AbstractInfoTitle abstractInfoTitle = InfoFacade.getInfoTitle(this.cls, this.geneColorCondition.getOrganismCodeSet(), string2, this.createDummyTitle);
            this.geneColorCondition.setInfoTitle(abstractInfoTitle);
        } else if (string.startsWith(KEY_ORDER_TYPE)) {
            int n3 = Integer.parseInt(this.getValue(KEY_ORDER_TYPE, string));
            this.geneColorCondition.setOrderType(n3);
        } else if (string.startsWith(KEY_MULTI_INFO_TYPE)) {
            int n4 = Integer.parseInt(this.getValue(KEY_MULTI_INFO_TYPE, string));
            this.geneColorCondition.setMultiInfoType(n4);
        } else if (string.startsWith(KEY_THRESHOLD)) {
            if (this.geneColorCondition.getInfoTitle() != null) {
                String string3 = this.getValue(KEY_THRESHOLD, string);
                List list = this.getColorValueList(string3, this.geneColorCondition.getInfoTitle());
                this.geneColorCondition.setColorValueList(list);
            }
        } else if (string.equals(SEP_CONDITION) && this.geneColorCondition.getInfoTitle() != null) {
            this.geneColorConditionGroup.addGeneColorCondition(this.geneColorCondition);
        }
    }

    private List getColorValueList(String string, AbstractInfoTitle abstractInfoTitle) {
        ArrayList<ColorValue> arrayList = new ArrayList<ColorValue>();
        Vector vector = StringTool.splitString(string, DELIMITER_COMMA);
        for (String string2 : vector) {
            Vector vector2 = StringTool.splitString(string2, DELIMITER_COLOR_VALUE);
            Color color = ColorUtil.str2Color((String)vector2.get(0));
            Object object = vector2.get(1);
            object = abstractInfoTitle.getValueAsType(object);
            ColorValue colorValue = new ColorValue(object, color);
            arrayList.add(colorValue);
        }
        return arrayList;
    }

    private String getValue(String string, String string2) {
        return string2.substring(string.length() + 1);
    }

    protected void parseHeaderLine(String string) {
    }
}

