/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorTreeController;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.controltree.ControlTreeRenderer;
import cgdp.recog.controltree.ControlTreeTransferHandler;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterTreeController;
import cgdp.recog.organism.DisplayOrganism;
import cgdp.recog.pattern.PatternTreeController;
import cgdp.recog.ppm.OrganismColumnTreeController;
import cgdp.recog.ppm.OrganismTreeNode;
import cgdp.recog.sort.SortTreeController;
import cgdp.recog.system.OS;
import cgdp.recog.util.AbstractTree;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ControlTree
extends AbstractTree {
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private DefaultTreeModel treeModel;
    private FilterTreeController filterTreeController;
    private ColorTreeController colorTreeController;
    private SortTreeController sortTreeController;
    private OrganismColumnTreeController organismColumnTreeController;
    private PatternTreeController patternTreeController;

    public ControlTree(Frame frame, MediatorImpl mediatorImpl) {
        super(OS.isWindows());
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.init();
        this.treeModel = new DefaultTreeModel(this.createTreeStructure());
        this.setModel(this.treeModel);
        this.setVisibleRoot();
        this.setCellRenderer(new ControlTreeRenderer());
        this.addMouseListener(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new ControlTreeTransferHandler(this.mediator));
    }

    private void init() {
        this.filterTreeController = new FilterTreeController(this.mediator);
        this.colorTreeController = new ColorTreeController(this.mediator);
        this.sortTreeController = new SortTreeController(this.mediator);
        this.organismColumnTreeController = new OrganismColumnTreeController(this.mediator);
        this.patternTreeController = new PatternTreeController(this.mediator);
    }

    protected MutableTreeNode createTreeStructure() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setUserObject("root");
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Filter", 10);
        defaultMutableTreeNode.add(controlTitleNode);
        this.filterTreeController.createTree(controlTitleNode);
        ControlTitleNode controlTitleNode2 = ControlTree.createControlTitleNode("Sort", 20);
        defaultMutableTreeNode.add(controlTitleNode2);
        this.sortTreeController.createTree(controlTitleNode2);
        ControlTitleNode controlTitleNode3 = ControlTree.createControlTitleNode("Color", 30);
        defaultMutableTreeNode.add(controlTitleNode3);
        this.colorTreeController.createTree(controlTitleNode3);
        ControlTitleNode controlTitleNode4 = ControlTree.createControlTitleNode("Phylogenetic Pattern", 100);
        defaultMutableTreeNode.add(controlTitleNode4);
        this.patternTreeController.createTree(controlTitleNode4);
        ControlTitleNode controlTitleNode5 = ControlTree.createControlTitleNode("Organism Column", 80);
        defaultMutableTreeNode.add(controlTitleNode5);
        this.organismColumnTreeController.createTree(controlTitleNode5);
        return defaultMutableTreeNode;
    }

    public static ControlTitleNode createControlTitleNode(String string, int n) {
        return new ControlTitleNode(string, n);
    }

    protected void setVisibleRoot() {
        this.setRootVisible(false);
    }

    protected void showPopup(Point point) {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        int n = this.getControlTitleType();
        JPopupMenu jPopupMenu = this.createPopupMenu(n);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private JPopupMenu createPopupMenu(int n) {
        JPopupMenu jPopupMenu = null;
        if (ControlTitleType.isFilter(n)) {
            jPopupMenu = this.filterTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isColor(n)) {
            jPopupMenu = this.colorTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isSort(n)) {
            jPopupMenu = this.sortTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isOrganismColumn(n)) {
            jPopupMenu = this.organismColumnTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isPattern(n)) {
            jPopupMenu = this.patternTreeController.createPopupMenu(this, this);
        }
        return jPopupMenu;
    }

    private int getControlTitleType() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null || treePath.getPathCount() <= 1) {
            return -1;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)treePath.getPathComponent(1);
        return controlTitleNode.getControlTitleType();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.filterTreeController.setClusterTbl(clusterTbl);
        this.colorTreeController.setClusterTbl(clusterTbl);
        this.sortTreeController.setClusterTbl(clusterTbl);
        this.organismColumnTreeController.setClusterTbl(clusterTbl);
        this.patternTreeController.setClusterTbl(clusterTbl);
        this.updateTree();
    }

    ClusterTbl getClusterTbl() {
        return this.clusterTbl;
    }

    public void updateFilterTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(10);
        controlTitleNode.removeAllChildren();
        this.filterTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateOrganismColumnTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        controlTitleNode.removeAllChildren();
        this.organismColumnTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateSortTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(20);
        controlTitleNode.removeAllChildren();
        this.sortTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateColorTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(30);
        controlTitleNode.removeAllChildren();
        this.colorTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updatePatternTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(100);
        controlTitleNode.removeAllChildren();
        this.patternTreeController.createTree(controlTitleNode);
        this.reload();
    }

    ControlTitleNode getTitleNode(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        return this.findTitleNode(defaultMutableTreeNode, n);
    }

    private ControlTitleNode findTitleNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!(defaultMutableTreeNode2 instanceof ControlTitleNode)) continue;
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode2;
            if (controlTitleNode.equalsControlTitleType(n)) {
                return controlTitleNode;
            }
            if ((controlTitleNode = this.findTitleNode(controlTitleNode, n)) == null) continue;
            return controlTitleNode;
        }
        return null;
    }

    public void updateSelection(int n, long l) {
        this.filterTreeController.updateSelection(this, n, l);
    }

    public void updateSelection(int n, long l, Collection collection) {
        this.filterTreeController.updateSelection(this, n, l, collection);
    }

    public List getControlTitleNodeList(List list) {
        ArrayList<ControlTitleNode> arrayList = new ArrayList<ControlTitleNode>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ControlTitleNode controlTitleNode = this.getTitleNode(n);
            if (controlTitleNode == null) continue;
            arrayList.add(controlTitleNode);
        }
        return arrayList;
    }

    public List getOrganismTreeNodeList() {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public List getDisplayOrganismList() {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            arrayList.add(((OrganismTreeNode)enumeration.nextElement()).getDisplayOrganism());
        }
        return arrayList;
    }

    public List getOrganismCodeList() {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            arrayList.add(((OrganismTreeNode)enumeration.nextElement()).getDisplayOrganism().getOrganismCode());
        }
        return arrayList;
    }

    public void setSelectOrganismColumn(Set set) {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        this.organismColumnTreeController.setSelectOrganismColumn(this, controlTitleNode, set);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.actionAfterDoubleClick();
        } else {
            this.actionAfterClick();
        }
    }

    private void actionAfterClick() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        int n = this.getControlTitleType();
        List list = this.getTreeNodeList(treePathArray);
        if (ControlTitleType.isOrganismColumn(n)) {
            this.organismColumnTreeController.actionAfterClick(list);
        }
    }

    private void actionAfterDoubleClick() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return;
        }
        int n = this.getControlTitleType();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (ControlTitleType.isFilter(n)) {
            this.filterTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isColor(n)) {
            this.colorTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isSort(n)) {
            this.sortTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isOrganismColumn(n)) {
            this.organismColumnTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isPattern(n)) {
            this.patternTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        }
    }
}

