/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

import cgdp.recog.active.ColorActivationHolder;
import cgdp.recog.active.FilterActivationHolder;
import cgdp.recog.active.OrganismColumnActivationHolder;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.controltree.TreeIconFactory;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.ppm.OrganismTreeNode;
import cgdp.recog.set.ElementSetGroupColorTreeNode;
import cgdp.recog.set.ElementSetGroupFilterTreeNode;
import cgdp.recog.taxonomy.TaxonomyIconSetter;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ControlTreeRenderer
extends DefaultTreeCellRenderer {
    private static final Color SP_NODE_COLOR_ALL = new Color(255, 128, 128);
    private static final Color SP_NODE_COLOR_ANY = new Color(128, 128, 255);
    private static final Color SP_NODE_COLOR_NONE = new Color(192, 192, 192);
    private static final Icon ELEMENT_SET_GROUP_DISABLE_ICON = TreeIconFactory.createElementSetGroupIcon(Color.lightGray);
    private TaxonomyIconSetter taxonomyIconSetter = new TaxonomyIconSetter(this);

    ControlTreeRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setText(string);
        this.selected = bl;
        this.hasFocus = bl4;
        if (object instanceof FilterActivationHolder) {
            this.setColorForgroundColor((FilterActivationHolder)object, bl);
        } else if (object instanceof ColorActivationHolder) {
            this.setColorForgroundColor((ColorActivationHolder)object, bl);
        } else if (object instanceof OrganismColumnActivationHolder) {
            this.setColorForgroundColor((OrganismColumnActivationHolder)object, bl);
        } else {
            this.setDefaultForgroundColor(bl);
        }
        if (object instanceof ElementSetGroupColorTreeNode) {
            Color color = ((ElementSetGroupColorTreeNode)object).getElementSetGroup().getColor();
            this.setElementSetGroupIcon(jTree, color);
        } else if (object instanceof ElementSetGroupFilterTreeNode) {
            Color color = ((ElementSetGroupFilterTreeNode)object).getElementSetGroup().getColor();
            this.setElementSetGroupIcon(jTree, color);
        } else if (object instanceof OrganismTreeNode) {
            ClusterTbl clusterTbl = ((ControlTree)jTree).getClusterTbl();
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)object;
            String string2 = organismTreeNode.getDisplayOrganism().getOrganismCode();
            boolean bl5 = false;
            boolean bl6 = false;
            if (clusterTbl != null) {
                bl5 = clusterTbl.isIngroup(string2);
                bl6 = clusterTbl.isOutgroup(string2);
            }
            this.taxonomyIconSetter.setTreeNodeIcon(jTree, bl3, bl2, bl5, bl6, string2);
        } else {
            this.setDefaultIcon(jTree, bl3, bl2);
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        return this;
    }

    private void setDefaultForgroundColor(boolean bl) {
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
    }

    private void setColorForgroundColor(FilterActivationHolder filterActivationHolder, boolean bl) {
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else if (filterActivationHolder.getFilterActivation().isFilterActive()) {
            this.setForeground(this.getTextNonSelectionColor());
        } else {
            this.setForeground(Color.gray);
        }
    }

    private void setColorForgroundColor(ColorActivationHolder colorActivationHolder, boolean bl) {
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else if (colorActivationHolder.getColorActivation().isColorActive()) {
            this.setForeground(this.getTextNonSelectionColor());
        } else {
            this.setForeground(Color.gray);
        }
    }

    private void setColorForgroundColor(OrganismColumnActivationHolder organismColumnActivationHolder, boolean bl) {
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else if (organismColumnActivationHolder.getOrganismColumnActivation().isOrganismColumnActive()) {
            if (organismColumnActivationHolder instanceof OrganismTreeNode) {
                this.setForeground(this.getNodeForgroundColor((OrganismTreeNode)organismColumnActivationHolder, bl));
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
        } else {
            this.setForeground(Color.gray);
        }
    }

    private void setDefaultIcon(JTree jTree, boolean bl, boolean bl2) {
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
    }

    private void setElementSetGroupIcon(JTree jTree, Color color) {
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            this.setDisabledIcon(ELEMENT_SET_GROUP_DISABLE_ICON);
        } else {
            this.setEnabled(true);
            this.setIcon(TreeIconFactory.createElementSetGroupIcon(color));
        }
    }

    private Color getNodeForgroundColor(OrganismTreeNode organismTreeNode, boolean bl) {
        FilterFacade filterFacade;
        Color color = null;
        color = organismTreeNode.isLeaf() ? ((filterFacade = FilterFacade.getInstance()).isAll(organismTreeNode.getOrganismCode()) ? SP_NODE_COLOR_ALL : (filterFacade.isNone(organismTreeNode.getOrganismCode()) ? SP_NODE_COLOR_NONE : (filterFacade.isAny(organismTreeNode.getOrganismCode()) ? SP_NODE_COLOR_ANY : (bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor())))) : (bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
        return color;
    }
}

