/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeFileUtil;
import cgdp.recog.coregenome.CoreGenomeServerAccessHelper;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.spgroup.SpGroup;
import cgdp.recog.spgroup.SpGroups;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ProgressServerConnection;
import cgdp.recog.util.ServerStatus;
import java.io.IOException;

public class CoreGenomeAlignmentExecuter
extends ProgressServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeAlignmentExecuter.class);
    private static final String SP_GROUP_DELIMITER = ":";
    private static final String SP_DELIMITER = ",";
    private String coreGenomeId;
    private String filepath;
    private StringBuffer sb;
    private String lineSeparator = FileUtil.LINE_SEPARETOR;
    private CoreGenomeAlignmentCondition condition;

    public CoreGenomeAlignmentExecuter(ProgressImpl progressImpl) {
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getCoreGenomeUrl());
        this.setProgressImpl(progressImpl);
        this.setIncreaseRate(1.1f);
        this.sb = new StringBuffer();
    }

    protected void beforeRunning() {
        this.sb = new StringBuffer();
        this.sb.append(CoreGenomeServerAccessHelper.createConditionString(this.condition));
    }

    protected void after() {
        if (this.isCanceled() || this.isError()) {
            return;
        }
        try {
            this.filepath = CoreGenomeFileUtil.getCoreGenomeFilepath(this.coreGenomeId, this.condition.getDomClustName(), this.condition.getOrganismList());
            FileUtil.outputFile(this.sb.toString(), this.filepath);
        }
        catch (IOException iOException) {
            logger.warn("Fail to write output file. " + this.filepath, iOException);
        }
    }

    public void parseOutputString(int n, String string) {
        this.sb.append(string);
        this.sb.append(this.lineSeparator);
    }

    public void setCondition(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        this.condition = coreGenomeAlignmentCondition;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLUST_TAB_ID=");
        stringBuffer.append(coreGenomeAlignmentCondition.getDomClustId());
        stringBuffer.append("&CONS_RATIO=");
        stringBuffer.append(coreGenomeAlignmentCondition.getOrthologRate());
        stringBuffer.append("&NBR_CONS_RATIO=");
        stringBuffer.append(coreGenomeAlignmentCondition.getConnectionRate());
        stringBuffer.append("&NBR_WIN=");
        stringBuffer.append(coreGenomeAlignmentCondition.getWindowSize());
        stringBuffer.append("&MIN_SPCOV=");
        stringBuffer.append(coreGenomeAlignmentCondition.getMinSpCov());
        stringBuffer.append("&SPCOV_REG_CUT=");
        stringBuffer.append(coreGenomeAlignmentCondition.getSpCovRegCut());
        stringBuffer.append("&SPCOV_SPRATIO=");
        stringBuffer.append(coreGenomeAlignmentCondition.getSpCovSpRatio());
        stringBuffer.append("&MIN_CLUSTCNT=");
        stringBuffer.append(coreGenomeAlignmentCondition.getMinClustSiz());
        stringBuffer.append("&OTHER_OPTIONS=");
        stringBuffer.append(coreGenomeAlignmentCondition.getOtherOptions());
        if (coreGenomeAlignmentCondition.isExistSpGroup() && coreGenomeAlignmentCondition.isUseSpGroup()) {
            String string = CoreGenomeAlignmentExecuter.parseSpGroupString(coreGenomeAlignmentCondition.getSpGroups());
            stringBuffer.append("&SP_GROUP=");
            stringBuffer.append(string);
        }
        System.err.println("SB=" + stringBuffer);
        this.setOptions(stringBuffer.toString());
    }

    private static String parseSpGroupString(SpGroups spGroups) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (SpGroup spGroup : spGroups.getSpGroupList()) {
            int n2 = 0;
            for (String string : spGroup.getSpList()) {
                stringBuffer.append(string);
                if (n2 != spGroup.getSpCount() - 1) {
                    stringBuffer.append(SP_DELIMITER);
                }
                ++n2;
            }
            if (n != spGroups.getSpGroupSize() - 1) {
                stringBuffer.append(SP_GROUP_DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getCoreGenomeId() {
        return this.coreGenomeId;
    }

    public void setCoreGenomeId(String string) {
        this.coreGenomeId = string;
    }

    protected int getProgress() {
        return super.getProgress() - 1;
    }

    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (super.setParameter(string)) {
            return true;
        }
        if (ServerStatus.isCoreGenomeId(string)) {
            this.setCoreGenomeId(ServerStatus.getCoreGenomeId(string));
            return true;
        }
        return false;
    }
}

