/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignment;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeAlignmentException;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.GenomeAlignGenerater;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class FileCoreGenomeAlignment
extends CoreGenomeAlignment {
    private static final ApplicationLogger logger = new ApplicationLogger(FileCoreGenomeAlignment.class);
    private static final String[] PROGRESS_MESSAGES = new String[]{"Create Connections.."};
    private List organismList;
    private String filepath;
    private GenomeAlign genomeAlign;
    private CoreGenomeAlignmentCondition condition;

    public FileCoreGenomeAlignment(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, String string, List list) {
        super(mediatorImpl, component, clusterTbl);
        this.filepath = string;
        this.organismList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        try {
            this.condition = new CoreGenomeAlignmentCondition();
            this.condition.setOrganismList(this.organismList);
            this.createGenomeAlignAndParameter(progressImpl);
            if (!this.validateGenomeAlign(this.genomeAlign)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MessageManager.showMessage(FileCoreGenomeAlignment.this.parent, "Ortholog group does not exist.");
                    }
                });
                return;
            }
            if (progressImpl.isCanceled()) {
                return;
            }
            CoreGenomeViewModel coreGenomeViewModel = this.createCoreGenomeViewModel();
            progressImpl.setCount(99);
            progressImpl.increment();
            ((ProgressDialog)progressImpl).setVisible(false);
            this.showCoreGenomeFrame(coreGenomeViewModel);
        }
        catch (CoreGenomeAlignmentException coreGenomeAlignmentException) {
            logger.warn(coreGenomeAlignmentException.getMessage(), coreGenomeAlignmentException);
            MessageManager.showErrorMessage(this.parent, coreGenomeAlignmentException.getMessage());
        }
        catch (Exception exception) {
            String string = "Fail to execute core genome alignment.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
        finally {
            this.mediator.updateMemory();
        }
    }

    private CoreGenomeViewModel createCoreGenomeViewModel() {
        ArrayList arrayList;
        Organism organism = this.condition.getReferenceOrganism();
        if (organism == null) {
            organism = (Organism)this.organismList.get(0);
            this.condition.setReferenceOrganism(organism);
        }
        if ((arrayList = this.condition.getViewOrganismList()) == null) {
            arrayList = new ArrayList(this.organismList);
            this.condition.setViewOrganismList(arrayList);
        }
        CoreGenomeViewModel coreGenomeViewModel = FileCoreGenomeAlignment.createCoreGenomeViewModel(this.genomeAlign, this.condition);
        coreGenomeViewModel.setViewOrthologGroupStartIndexOnMain(this.condition.getViewOrthologGroupStartIndexOnMain());
        return coreGenomeViewModel;
    }

    private void createGenomeAlignAndParameter(ProgressImpl progressImpl) throws Exception {
        GenomeAlignGenerater genomeAlignGenerater = new GenomeAlignGenerater();
        genomeAlignGenerater.setFilepath(this.filepath);
        genomeAlignGenerater.setClusterTbl(this.clusterTbl);
        genomeAlignGenerater.setCondition(this.condition);
        genomeAlignGenerater.execute(progressImpl);
        this.genomeAlign = genomeAlignGenerater.getGenomeAlign();
        this.genomeAlign.setOrganismList(this.organismList);
    }

    public String[] getProgressMessages() {
        return PROGRESS_MESSAGES;
    }
}

