/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeRenderer;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FoldCoreGenomeContext;
import cgdp.recog.coregenome.LegendRenderer;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class FoldCoreGenomeRenderer
extends CoreGenomeRenderer {
    private static final ApplicationLogger logger = new ApplicationLogger(FoldCoreGenomeRenderer.class);
    private LegendRenderer legendRenderer = new LegendRenderer();

    public void draw(Graphics2D graphics2D) {
        graphics2D.scale(this.coreGenomeContext.getScaleX(), this.coreGenomeContext.getScaleY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getFoldCoreGenomeContext().getPageIndex() == 0 || this.coreGenomeViewModel.isAllRowShowOrganismName()) {
            graphics2D.setFont(((FoldCoreGenomeContext)this.coreGenomeContext).createOrganismFont());
            this.coreGenomeContext.setOrganismNameWidth(this.calcOrganismNameSize(graphics2D));
        } else {
            this.coreGenomeContext.setOrganismNameWidth(0.0);
        }
        graphics2D.setFont(this.coreGenomeContext.createFont());
        this.coreGenomeContext.setGeneNameHeight(this.calcGeneNameHeight());
        if (this.coreGenomeContext.isResizeFlag()) {
            double d = this.coreGenomeContext.calcScaleX(this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign().getClusterCount());
            double d2 = this.coreGenomeContext.calcScaleY(this.coreGenomeViewModel.getViewOrganismSize(), this.coreGenomeContext.getGeneNameHeight());
            graphics2D.scale(d, d2);
            this.coreGenomeContext.setScaleX(d);
            this.coreGenomeContext.setScaleY(d2);
        }
        if (!this.getFoldCoreGenomeContext().isLastPageOnlyLegend()) {
            this.drawGeneName(graphics2D);
            this.drawDirection(graphics2D);
            this.drawOrganismName(graphics2D);
            this.drawMatrix(graphics2D);
        }
        this.drawLegend(graphics2D);
        graphics2D.scale(1.0 / this.coreGenomeContext.getScaleX(), 1.0 / this.coreGenomeContext.getScaleY());
        this.drawPageNumber(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    protected void drawOrganismName(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(((FoldCoreGenomeContext)this.coreGenomeContext).createOrganismFont());
        if (this.coreGenomeViewModel.isAllRowShowOrganismName()) {
            double d = this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
            double d2 = 0.0;
            this.getFoldCoreGenomeContext().getRowCountParPage();
            int n = this.getFoldCoreGenomeContext().isLastPage() ? this.getFoldCoreGenomeContext().getRowCountOfLastPage() : this.getFoldCoreGenomeContext().getRowCountParPage();
            for (int i = 0; i < n; ++i) {
                super.drawOrganismName(graphics2D);
                graphics2D.translate(0.0, d);
                d2 += d;
            }
            graphics2D.translate(0.0, -d2);
        } else {
            if (this.getFoldCoreGenomeContext().getPageIndex() != 0) {
                return;
            }
            super.drawOrganismName(graphics2D);
        }
        graphics2D.setFont(font);
    }

    protected void drawGeneName(Graphics2D graphics2D) {
        float f = (float)this.getFoldCoreGenomeContext().getGeneNameStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
        float f2 = (float)this.coreGenomeContext.getGeneNameStartY() + (float)this.coreGenomeContext.getVerticalPositionOfMain();
        graphics2D.setColor(Color.black);
        int n = Integer.MIN_VALUE;
        if (!this.getFoldCoreGenomeContext().isFirstPage()) {
            int n2 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(-1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            n = this.getGenomeAlign().getOrthologGroup(n2).getClusterNo();
        }
        List list = this.getCoreGenomeViewModel().getOrhotlogGroupLabelList();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.getFoldCoreGenomeContext().getColumnCountParPage(this.getGenomeAlign()); ++i) {
            int n5 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(i, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            boolean bl = false;
            int n6 = this.getGenomeAlign().getOrthologGroup(n5).getClusterNo();
            if (this.isChangeCluster(n6, n) && (i == 0 && !this.getFoldCoreGenomeContext().isFirstPage() || i != 0) && n3 != this.getFoldCoreGenomeContext().getColumnCountParRow(n4)) {
                f = (float)((double)f + this.coreGenomeContext.getClusterBlankWidth());
                ++n3;
                bl = true;
            }
            if (this.getFoldCoreGenomeContext().isFoldPoint(n5) && i != 0) {
                if (!this.getFoldCoreGenomeContext().isDrawMatrix(++n4)) break;
                f = this.coreGenomeViewModel.isAllRowShowOrganismName() ? (float)this.getFoldCoreGenomeContext().getGeneNameStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName()) : (float)this.getFoldCoreGenomeContext().getGeneNameStartXAgainstOneOrhotlogGroup() + (float)this.coreGenomeContext.getOrthologGroupIntervalX();
                f2 = (float)((double)f2 + this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize()));
                if (this.isChangeCluster(n6, n) && !bl) {
                    f = (float)((double)f + this.coreGenomeContext.getClusterBlankWidth());
                    n3 = 1;
                } else {
                    n3 = 0;
                }
            }
            n = n6;
            String string = (String)list.get(n5);
            this.drawGeneName(graphics2D, string, f, f2);
            f = (float)((double)f + this.coreGenomeContext.getDirectionWidth());
            ++n3;
        }
    }

    private void drawDirection(Graphics2D graphics2D) {
        int n;
        double d = this.getFoldCoreGenomeContext().getDirectionStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
        double d2 = this.coreGenomeContext.getDirectionStartY() + (double)((float)this.coreGenomeContext.getVerticalPositionOfMain());
        int n2 = Integer.MIN_VALUE;
        if (!this.getFoldCoreGenomeContext().isFirstPage()) {
            n = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(-1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            n2 = this.getGenomeAlign().getOrthologGroup(n).getClusterNo();
        }
        n = 0;
        int n3 = 0;
        graphics2D.translate(d, d2);
        for (int i = 0; i < this.getFoldCoreGenomeContext().getColumnCountParPage(this.getGenomeAlign()); ++i) {
            int n4 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(i, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            OrthologGroup orthologGroup = (OrthologGroup)this.getGenomeAlign().getOrthologGroupList().get(n4);
            boolean bl = false;
            int n5 = orthologGroup.getClusterNo();
            if (this.isChangeCluster(n5, n2) && (i == 0 && !this.getFoldCoreGenomeContext().isFirstPage() || i != 0) && n != this.getFoldCoreGenomeContext().getColumnCountParRow(n3)) {
                graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                d += this.coreGenomeContext.getClusterBlankWidth();
                ++n;
                bl = true;
            }
            if (this.getFoldCoreGenomeContext().isFoldPoint(n4) && i != 0) {
                if (!this.getFoldCoreGenomeContext().isDrawMatrix(++n3)) break;
                double d3 = this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
                double d4 = this.coreGenomeViewModel.isAllRowShowOrganismName() ? this.getFoldCoreGenomeContext().getDirectionStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName()) : this.coreGenomeContext.getOrthologGroupIntervalX();
                graphics2D.translate(-d + d4, d3);
                d = d4;
                d2 += d3;
                if (this.isChangeCluster(n5, n2) && i != 0 && !bl) {
                    graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    d += this.coreGenomeContext.getClusterBlankWidth();
                    n = 1;
                } else {
                    n = 0;
                }
            }
            n2 = n5;
            this.drawDirection(graphics2D, orthologGroup.getDirection(), orthologGroup.getCluster());
            graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
            d += this.coreGenomeContext.getDirectionWidth();
            ++n;
        }
        graphics2D.translate(-d, -d2);
    }

    private synchronized void drawMatrix(Graphics2D graphics2D) {
        int n;
        Shape shape = graphics2D.getClip();
        double d = this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
        double d2 = this.coreGenomeContext.getMatrixStartY();
        double d3 = 0.0;
        int n2 = Integer.MIN_VALUE;
        if (!this.getFoldCoreGenomeContext().isFirstPage()) {
            n = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(-1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            n2 = this.getGenomeAlign().getOrthologGroup(n).getClusterNo();
        }
        n = 0;
        int n3 = 0;
        boolean bl = false;
        graphics2D.translate(d, d2);
        double d4 = this.coreGenomeContext.getGeneNodeSize() + this.coreGenomeContext.getGeneNodeIntervalY();
        int n4 = 0;
        for (String string : this.coreGenomeViewModel.getViewOrganismCodeList()) {
            double d5;
            double d6;
            int n5;
            OrthologGroup orthologGroup;
            int n6;
            int n7;
            int n8 = this.getFoldCoreGenomeContext().getColumnCountParPage(this.getGenomeAlign());
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(n7, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
                orthologGroup = this.getGenomeAlign().getOrthologGroup(n6);
                bl = false;
                n5 = orthologGroup.getClusterNo();
                if (this.isChangeCluster(n5, n2) && n != this.getFoldCoreGenomeContext().getColumnCountParRow(n3)) {
                    graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    d += this.coreGenomeContext.getClusterBlankWidth();
                    ++n;
                    bl = true;
                }
                if (this.getFoldCoreGenomeContext().isFoldPoint(n6)) {
                    if (n7 != 0) {
                        this.drawLastRowConnection(graphics2D, string, d4, d2, n7, bl);
                        d6 = this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
                        d5 = this.coreGenomeViewModel.isAllRowShowOrganismName() ? this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName()) : this.coreGenomeContext.getMatrixStartXAgainstOrthologGroup() + this.coreGenomeContext.getOrthologGroupIntervalX();
                        graphics2D.translate(-d + d5, d6);
                        d = d5;
                        d2 += d6;
                        if (!this.getFoldCoreGenomeContext().isDrawMatrix(++n3)) break;
                        n = 0;
                    }
                    if (n7 == 0 && bl) {
                        graphics2D.translate(-this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    }
                    Shape shape2 = this.createMatrixClip(n3);
                    graphics2D.setClip(shape2);
                    if (n7 == 0 && bl) {
                        graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    }
                    if (this.isChangeCluster(n5, n2) && !bl) {
                        graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                        d += this.coreGenomeContext.getClusterBlankWidth();
                        n = 1;
                    }
                }
                n2 = n5;
                OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
                if (orthologSpNode != null && !this.drawConnection(graphics2D, d, orthologSpNode)) {
                    return;
                }
                graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
                d += this.coreGenomeContext.getDirectionWidth();
                ++n;
            }
            if (this.getFoldCoreGenomeContext().isDrawMatrix(n3)) {
                this.drawLastRowConnection(graphics2D, string, d4, d2, n8, bl);
            }
            graphics2D.translate(-(d - this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName())), -(d2 - this.coreGenomeContext.getMatrixStartY()));
            d2 = this.coreGenomeContext.getMatrixStartY();
            d = this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
            n = 0;
            n3 = 0;
            n2 = Integer.MIN_VALUE;
            if (!this.getFoldCoreGenomeContext().isFirstPage()) {
                n7 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(-1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
                n2 = this.getGenomeAlign().getOrthologGroup(n7).getClusterNo();
            }
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(n7, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
                orthologGroup = this.getGenomeAlign().getOrthologGroup(n6);
                bl = false;
                n5 = orthologGroup.getClusterNo();
                if (this.isChangeCluster(n5, n2) && n != this.getFoldCoreGenomeContext().getColumnCountParRow(n3)) {
                    graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    d += this.coreGenomeContext.getClusterBlankWidth();
                    ++n;
                    bl = true;
                }
                if (this.getFoldCoreGenomeContext().isFoldPoint(n6)) {
                    if (n7 != 0) {
                        d6 = this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
                        d5 = this.coreGenomeViewModel.isAllRowShowOrganismName() ? this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName()) : this.coreGenomeContext.getMatrixStartXAgainstOrthologGroup() + this.coreGenomeContext.getOrthologGroupIntervalX();
                        graphics2D.translate(-d + d5, d6);
                        d = d5;
                        d2 += d6;
                        if (!this.getFoldCoreGenomeContext().isDrawMatrix(++n3)) break;
                        n = 0;
                    }
                    if (n7 == 0 && bl) {
                        graphics2D.translate(-this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    }
                    Shape shape3 = this.createMatrixClip(n3);
                    graphics2D.setClip(shape3);
                    if (n7 == 0 && bl) {
                        graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    }
                    if (this.isChangeCluster(n5, n2) && !bl) {
                        graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                        d += this.coreGenomeContext.getClusterBlankWidth();
                        n = 1;
                    }
                }
                n2 = n5;
                OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
                if (orthologSpNode != null) {
                    this.drawGeneNode(graphics2D, orthologSpNode.getLocusTagCount());
                }
                graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
                d += this.coreGenomeContext.getDirectionWidth();
                ++n;
            }
            graphics2D.translate(-(d - this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName())), -(d2 - d4 - this.coreGenomeContext.getMatrixStartY()));
            d = this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
            d3 += d4;
            d2 = this.coreGenomeContext.getMatrixStartY();
            n = 0;
            n3 = 0;
            ++n4;
            n2 = Integer.MIN_VALUE;
            if (this.getFoldCoreGenomeContext().isFirstPage()) continue;
            n7 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(-1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            n2 = this.getGenomeAlign().getOrthologGroup(n7).getClusterNo();
        }
        graphics2D.setClip(shape);
        graphics2D.translate(-d, -(d3 + d2));
        graphics2D.setClip(shape);
    }

    private void drawLastRowConnection(Graphics2D graphics2D, String string, double d, double d2, int n, boolean bl) {
        double d3 = 0.0;
        int n2 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(n - 1, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
        int n3 = this.getGenomeAlign().getOrthologGroup(n2).getClusterNo();
        for (int i = n; i < n + this.coreGenomeViewModel.getWindowSize(); ++i) {
            n2 = this.getFoldCoreGenomeContext().convertOrthologGroupStartIndex(i, this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign());
            OrthologGroup orthologGroup = this.getGenomeAlign().getOrthologGroup(n2);
            int n4 = orthologGroup.getClusterNo();
            if (this.isChangeCluster(n4, n3) && !bl) {
                graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                d3 += this.coreGenomeContext.getClusterBlankWidth();
            }
            n3 = n4;
            OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
            if (orthologSpNode != null && !this.drawConnection(graphics2D, d3, orthologSpNode)) {
                return;
            }
            graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
            d3 += this.coreGenomeContext.getDirectionWidth();
        }
        graphics2D.translate(-d3, 0.0);
    }

    private Shape createMatrixClip(int n) {
        double d = this.getFoldCoreGenomeContext().getMatrixWidth(n);
        double d2 = (this.coreGenomeContext.getMarginTop() + this.coreGenomeContext.getMarginBottom()) / this.coreGenomeContext.getScaleY() + (this.calcHeight() - (this.coreGenomeContext.getMarginTop() + this.coreGenomeContext.getMarginBottom())) + this.coreGenomeContext.getDirectionStartY();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-this.coreGenomeContext.getOrthologGroupIntervalX(), -this.coreGenomeContext.getDirectionStartY(), d, d2);
        return double_;
    }

    private void drawLegend(Graphics2D graphics2D) {
        if (!this.getFoldCoreGenomeContext().isLastPage() || !this.coreGenomeViewModel.isShowLegend()) {
            return;
        }
        this.legendRenderer.setLegeneContext(this.getFoldCoreGenomeContext().getLegendContext());
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
        if (this.getFoldCoreGenomeContext().getLegendContext().isDrawNewLineRow()) {
            d = this.coreGenomeContext.getMarginLeft();
            d2 = this.coreGenomeContext.getGeneNameStartY() + d3 * (double)this.getFoldCoreGenomeContext().getRowCountOfLastPage();
        } else {
            double d4;
            double d5 = d4 = this.getFoldCoreGenomeContext().isOneRow() ? this.coreGenomeContext.getMatrixStartX() : this.coreGenomeContext.getMarginLeft();
            if (this.coreGenomeViewModel.isAllRowShowOrganismName()) {
                d4 += this.getFoldCoreGenomeContext().getMatrixStartXForFold(this.coreGenomeViewModel.isAllRowShowOrganismName());
            }
            d = d4 + (double)this.getFoldCoreGenomeContext().getLastColumnCount() * this.coreGenomeContext.getDirectionWidth();
            d2 = this.coreGenomeContext.getGeneNameStartY() + d3 * (double)(this.getFoldCoreGenomeContext().getRowCountOfLastPage() - 1);
        }
        graphics2D.translate(d, d2);
        this.legendRenderer.draw(graphics2D);
        graphics2D.translate(-d, -d2);
    }

    private void drawPageNumber(Graphics2D graphics2D) {
        if (!this.coreGenomeViewModel.isShowPageNumber()) {
            return;
        }
        Font font = new Font("Times New Roman", 0, 10);
        Font font2 = graphics2D.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        double d = this.getFoldCoreGenomeContext().getPanelZoomScaleX();
        double d2 = this.getFoldCoreGenomeContext().getPanelZoomScaleY();
        float f = (float)this.getFoldCoreGenomeContext().getImageableWidth() * (float)d / 2.0f;
        float f2 = (float)this.getFoldCoreGenomeContext().getImageableHeight() * (float)d2 - (float)this.coreGenomeContext.getMarginBottom() * (float)d2 / 4.0f;
        graphics2D.drawString(String.valueOf(this.getFoldCoreGenomeContext().getPageIndex() + 1), f, f2);
        graphics2D.setFont(font2);
    }

    public void setModel(CoreGenomeViewModel coreGenomeViewModel, FoldCoreGenomeContext foldCoreGenomeContext) {
        this.setCoreGenomeViewModel(coreGenomeViewModel);
        this.setFoldCoreGenomeContext(foldCoreGenomeContext);
    }

    public FoldCoreGenomeContext getFoldCoreGenomeContext() {
        return (FoldCoreGenomeContext)this.coreGenomeContext;
    }

    private void setFoldCoreGenomeContext(FoldCoreGenomeContext foldCoreGenomeContext) {
        this.coreGenomeContext = foldCoreGenomeContext;
    }
}

