/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignment;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeAlignmentException;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.DomClustReExecuter;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;

public class FullCoreGenomeAlignment
extends CoreGenomeAlignment {
    private static final ApplicationLogger logger = new ApplicationLogger(FullCoreGenomeAlignment.class);
    private static final String[] PROGRESS_MESSAGES = new String[]{"Core Genome Alignment...", "Create Connections.."};
    private List organismList;
    private CoreGenomeAlignmentCondition condition;

    public FullCoreGenomeAlignment(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, List list, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        super(mediatorImpl, component, clusterTbl);
        this.organismList = list;
        this.condition = coreGenomeAlignmentCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        try {
            String string = this.executeCoreGenomeOnServer(progressImpl, this.clusterTbl, this.condition);
            if (progressImpl.isCanceled()) {
                MessageManager.showMessage(this.parent, "Core genome alignment is canceled.");
                return;
            }
            if (this.isError()) {
                if (DomClustReExecuter.isNoClusterTable(this.getErrorNo())) {
                    DomClustReExecuter domClustReExecuter = new DomClustReExecuter(this.parent, this.mediator, this.clusterTbl.getFilepath());
                    domClustReExecuter.setErrorMessage("Fail to execute core genome alignment.");
                    domClustReExecuter.execute();
                } else {
                    MessageManager.showErrorMessage(this.parent, this.getErrorMessage());
                }
                return;
            }
            progressImpl.setCount(99);
            progressImpl.increment();
            progressImpl.nextProc();
            progressImpl.increment();
            GenomeAlign genomeAlign = FullCoreGenomeAlignment.createGenomeAlign(progressImpl, this.clusterTbl, string, this.condition);
            if (!this.validateGenomeAlign(genomeAlign)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MessageManager.showMessage(FullCoreGenomeAlignment.this.parent, "Ortholog group does not exist.");
                    }
                });
                return;
            }
            if (progressImpl.isCanceled()) {
                return;
            }
            CoreGenomeViewModel coreGenomeViewModel = FullCoreGenomeAlignment.createCoreGenomeViewModel(genomeAlign, this.condition);
            progressImpl.setCount(99);
            progressImpl.increment();
            ((ProgressDialog)progressImpl).setVisible(false);
            this.showCoreGenomeFrame(coreGenomeViewModel);
        }
        catch (CoreGenomeAlignmentException coreGenomeAlignmentException) {
            logger.warn(coreGenomeAlignmentException.getMessage(), coreGenomeAlignmentException);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageManager.showErrorMessage(FullCoreGenomeAlignment.this.parent, coreGenomeAlignmentException.getMessage());
                }
            });
        }
        catch (Exception exception) {
            logger.warn("Fail to execute core genome alignment.", exception);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageManager.showErrorMessage(FullCoreGenomeAlignment.this.parent, "Fail to execute core genome alignment.");
                }
            });
        }
        finally {
            this.mediator.updateMemory();
        }
    }

    public String[] getProgressMessages() {
        return PROGRESS_MESSAGES;
    }
}

