/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.color.BaseColorCondition;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionGroup;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTblCreater;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.data.ModifiedClusterManager;
import cgdp.recog.data.MultiCluster;
import cgdp.recog.data.SplitCluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.hcluster.HClustAdjuster;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustResult;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.DisplayOrganism;
import cgdp.recog.organism.MergeOrganism;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismCondition;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.organism.OrganismSplitCondition;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.organism.SplitOrganism;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternGroup;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelConditionFactory;
import cgdp.recog.ppm.PPMLabelConditionGroup;
import cgdp.recog.ppm.PPMSelectionManager;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchCondition;
import cgdp.recog.search.SearchResultGroup;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.sort.BasicSortCondition;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.GeneInfoSortable;
import cgdp.recog.sort.InfoSortCondition;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.sort.SortException;
import cgdp.recog.sort.SortOrder;
import cgdp.recog.sort.SortType;
import cgdp.recog.sort.Sortable;
import cgdp.recog.sort.SortableFactory;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterTbl {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterTbl.class);
    private ApplicationPropertyConf applicationPropertyConf;
    private String domClustOption;
    private OptionTbl m_optionTbl;
    private OrganismCondition organismCondition = new OrganismCondition();
    private List m_orderList;
    private List m_viewOrderList;
    private Map patternClusterMap;
    private List m_clusterList;
    private List m_viewClusterList;
    private List m_clusterList4release;
    private List m_viewClusterList4release;
    private List m_viewSuperClusterList;
    private HashMap m_viewSuperClusterMap;
    private Map m_viewClusterMap;
    private List m_noListForAggregate;
    private List m_noListForDisaggregate;
    private PPMSelectionManager ppmSelectionManager = new PPMSelectionManager();
    private SearchResultGroup searchResultGroup = new SearchResultGroup();
    private HClustResult hClustResult = new HClustResult();
    private SortCondition sortCondition;
    private int ppmHeaderSortOrder = 1;
    private NeighboringClustCondition neighboringClustCondition;
    private Map neighboringClusterMap;
    private boolean showNeighbor;
    private boolean hilightNeighbor;
    private GeneColorConditionGroup geneColorConditionGroup = new GeneColorConditionGroup();
    private BaseColorCondition baseColorCondition = new BaseColorCondition();
    private SetConditionGroup setConditionGroup = new SetConditionGroup();
    private HistogramCondition histogramCondition;
    private PPMLabelConditionGroup ppmLabelConditionGroup = new PPMLabelConditionGroup();
    private Map locusTagClusterMap = new HashMap();
    private ClusterInfo clusterInfo = new ClusterInfo();
    private boolean existHomCluster = false;
    private PatternGroup patternGroup = new PatternGroup();
    private ModifiedClusterManager modifiedClusterManager;

    protected ClusterTbl() {
        this.clear();
        this.modifiedClusterManager = new ModifiedClusterManager(this);
    }

    public ClusterTbl(String string) {
        this.setFilepath(string);
        this.clear();
    }

    private void clear() {
        this.m_optionTbl = OptionTbl.getInstance();
        this.m_orderList = new ArrayList();
        this.m_viewOrderList = new ArrayList();
        this.patternClusterMap = new HashMap();
        this.m_clusterList = new ArrayList();
        this.m_viewClusterList = new ArrayList();
        this.m_viewSuperClusterList = new ArrayList();
        this.m_viewSuperClusterMap = new HashMap();
        this.m_viewClusterMap = new HashMap();
        this.m_noListForAggregate = new ArrayList();
        this.m_noListForDisaggregate = new ArrayList();
        this.clearHClustResult();
        FilterFacade.clearCondition();
        this.locusTagClusterMap = new HashMap();
        this.ppmHeaderSortOrder = 1;
        ModifiedOrganismManager.getInstance().clear();
    }

    public void free() {
        try {
            this.organismCondition.clear();
            if (this.m_orderList != null) {
                this.m_orderList.clear();
            }
            if (this.m_viewOrderList != null) {
                this.m_viewOrderList.clear();
            }
            if (this.patternClusterMap != null) {
                for (Object object : this.patternClusterMap.keySet()) {
                    List list = (List)this.patternClusterMap.get(object);
                    if (list != null) {
                        list.clear();
                        list = null;
                    }
                    object.clear();
                    object = null;
                }
                this.patternClusterMap.clear();
            }
            if (this.m_clusterList != null) {
                this.m_clusterList.clear();
            }
            if (this.locusTagClusterMap != null) {
                this.locusTagClusterMap.clear();
            }
            if (this.m_viewClusterList != null) {
                this.m_viewClusterList.clear();
            }
            if (this.m_viewSuperClusterList != null) {
                this.m_viewSuperClusterList.clear();
            }
            if (this.m_viewSuperClusterMap != null) {
                this.m_viewSuperClusterMap.clear();
            }
            if (this.m_viewClusterMap != null) {
                for (Object object : this.m_viewClusterMap.values()) {
                    if (object == null) continue;
                    object.clear();
                    object = null;
                }
                this.m_viewClusterMap.clear();
            }
            if (this.m_noListForAggregate != null) {
                for (Object object : this.m_noListForAggregate) {
                    if (object == null) continue;
                    object.clear();
                    object = null;
                }
                this.m_noListForAggregate.clear();
            }
            if (this.m_noListForDisaggregate != null) {
                for (Object object : this.m_noListForDisaggregate) {
                    if (object == null) continue;
                    object.clear();
                    object = null;
                }
                this.m_noListForDisaggregate.clear();
            }
            this.clearHClustResult();
            System.gc();
        }
        catch (Exception exception) {
            logger.warn("Fail to free Cluster Information", exception);
        }
        catch (Error error) {
            logger.warn("Fail to free Cluster Information", error);
        }
    }

    public void updateForFilter() throws SortException {
        HClustCondition hClustCondition;
        if (this.isExistHClustResult() && !(hClustCondition = this.getHClustCondition()).isRestruct()) {
            this.clearHClustResult();
        }
        this.setViewOrderList();
        this.setViewClusterList();
    }

    public void setHClustResult(List list, HClustCondition hClustCondition, Map map) {
        this.hClustResult.setResult(list, hClustCondition, map, this);
        this.setSortCondition(hClustCondition);
    }

    public HClustCondition getHClustCondition() {
        return this.hClustResult.getUpgmaCondition();
    }

    public void updateForHClust() throws SortException {
        this.hClustResult.updateResult(this);
        this.sortClusterList(this.hClustResult.getUpgmaCondition(), new DummyProgressComponent());
    }

    public Set getExcludeOrganismSet() {
        HashSet hashSet = new HashSet(this.getOrganismCodeList());
        hashSet.removeAll(this.getViewOrganismCodeList());
        return hashSet;
    }

    public void setViewOrderList() throws SortException {
        FilterFacade filterFacade = FilterFacade.getInstance();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        HashMap<Map, List> hashMap = new HashMap<Map, List>();
        Set set = this.getExcludeOrganismSet();
        for (Map map : this.m_orderList) {
            List list;
            if (map.isEmpty() || CollectionUtil.isNull(list = (List)this.patternClusterMap.get(map))) continue;
            boolean bl = filterFacade.isTaxFilterMatch(map.keySet(), set);
            if (bl && filterFacade.isEnableOrganismCountFilter()) {
                boolean bl2 = bl = !CollectionUtil.isNull(list = filterFacade.getMatchOrganismCountCluster(list));
            }
            if (bl && filterFacade.isEnableGeneCountFilter()) {
                boolean bl3 = bl = !CollectionUtil.isNull(list = filterFacade.getMatchGeneCountCluster(list));
            }
            if (bl && this.searchResultGroup.isEnableFilterSearchResult()) {
                bl = this.isSearchResultCluster(map);
            }
            if (bl && filterFacade.isEnableSetFilter()) {
                bl = filterFacade.isMatchSetFilter(list);
            }
            if (bl && filterFacade.isEnableTaxMapFilter()) {
                bl = filterFacade.isMatchTaxMapFilter(list);
            }
            if (!bl || CollectionUtil.isNull(list)) continue;
            hashMap.put(map, list);
            arrayList.add(map);
        }
        this.m_viewOrderList.clear();
        this.m_viewClusterMap.clear();
        this.m_viewOrderList.addAll(arrayList);
        this.m_viewClusterMap.putAll(hashMap);
        if (this.isExistHClustResult() && !this.hClustResult.isExistMergedResult()) {
            this.updateForHClust();
        }
        this.filterByLimitForAggregate();
    }

    private void filterByLimitForAggregate() {
        if (!this.isLimitNoListForAggregate()) {
            return;
        }
        for (List list : this.m_noListForAggregate) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                arrayList.add(this.m_viewOrderList.get(n));
            }
            this.m_viewOrderList.clear();
            this.m_viewOrderList.addAll(arrayList);
            arrayList.clear();
            arrayList = null;
        }
    }

    public void setViewClusterList() throws SortException {
        FilterFacade filterFacade = FilterFacade.getInstance();
        this.m_viewClusterList.clear();
        Set set = this.getExcludeOrganismSet();
        for (Cluster cluster : this.m_clusterList) {
            boolean bl = filterFacade.isTaxFilterMatch(cluster.getSpSet(), set);
            if (bl && filterFacade.isEnableOrganismCountFilter()) {
                bl = filterFacade.isMatchOrganismCount(cluster);
            }
            if (bl && filterFacade.isEnableGeneCountFilter()) {
                bl = filterFacade.isMatchGeneCount(cluster);
            }
            if (bl && this.searchResultGroup.isEnableFilterSearchResult()) {
                bl = this.containsSearchResultCluster(cluster);
            }
            if (bl && filterFacade.isEnableSetFilter()) {
                bl = filterFacade.isMatchSetFilter(cluster);
            }
            if (bl && filterFacade.isEnableTaxMapFilter()) {
                bl = filterFacade.isMatchTaxMapFilter(cluster);
            }
            if (bl && filterFacade.isEnableFuncCatFilter()) {
                bl = filterFacade.isMatchFuncCatFilter(cluster);
            }
            if (!bl) continue;
            this.m_viewClusterList.add(cluster);
        }
        this.filterByLimitForDisaggregate();
        if (this.isExistHClustResult()) {
            this.updateForHClust();
        }
        this.recreateViewSuperClusterList();
    }

    private void recreateViewSuperClusterList() {
        this.createSuperClusterList(this.m_viewClusterList, 0, this.m_viewClusterList.size(), -1, 1);
    }

    private void filterByLimitForDisaggregate() {
        if (!this.isLimitNoListForDisaggregate()) {
            return;
        }
        for (List list : this.m_noListForDisaggregate) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                arrayList.add(this.m_viewClusterList.get(n));
            }
            this.m_viewClusterList.clear();
            this.m_viewClusterList.addAll(arrayList);
            arrayList.clear();
            arrayList = null;
        }
        this.recreateViewSuperClusterList();
    }

    public void setLimitNoListForAggregate(List list) throws SortException {
        this.m_noListForAggregate.add(list);
        this.setViewOrderList();
    }

    public void setLimitNoListForDisaggregate(List list) throws SortException {
        this.m_noListForDisaggregate.add(list);
        this.setViewClusterList();
    }

    public void setSearchResultList(SearchCondition searchCondition, List list) {
        this.searchResultGroup.setCondition(searchCondition);
        this.searchResultGroup.setSearchResultList(list);
    }

    public boolean isSearchResultCluster(Cluster cluster, String string) {
        if (!this.isEnableHighlightSearchResult()) {
            return false;
        }
        if (this.isSearchTypeCluster()) {
            return this.containsSearchResult(cluster);
        }
        return this.containsSearchResultOrganism(cluster, string);
    }

    public void filterHighlightBySearchResult() throws SortException {
        this.searchResultGroup.setColorActive(true);
        this.searchResultGroup.setFilterActive(true);
        this.setViewOrderList();
        this.setViewClusterList();
    }

    public void clearFilterHighlightBySearchResult() throws SortException {
        this.searchResultGroup.setColorActive(false);
        this.searchResultGroup.setFilterActive(false);
        this.setViewOrderList();
        this.setViewClusterList();
    }

    public void highlightBySearchResult() throws SortException {
        this.searchResultGroup.setColorActive(true);
    }

    public void clearHighlightBySearchResult() throws SortException {
        this.searchResultGroup.setColorActive(false);
    }

    public void filterBySearchResult() throws SortException {
        this.searchResultGroup.setFilterActive(true);
        this.setViewOrderList();
        this.setViewClusterList();
    }

    public void clearFilterBySearchResult() throws SortException {
        this.searchResultGroup.setFilterActive(false);
        this.setViewOrderList();
        this.setViewClusterList();
    }

    public boolean isSearchTypeCluster() {
        return this.searchResultGroup.isCluster();
    }

    public boolean isSearchTypeGene() {
        return this.searchResultGroup.isGene();
    }

    public boolean containsSearchResult(Cluster cluster) {
        return this.searchResultGroup.containsSearchResult(cluster);
    }

    public boolean containsSearchResultOrganism(Cluster cluster, String string) {
        return this.searchResultGroup.containsSearchResultOrganism(cluster, string);
    }

    public boolean containsSearchResultGene(Cluster cluster, String string) {
        return this.searchResultGroup.containsSearchResultGene(cluster, string);
    }

    public boolean isEnableHighlightSearchResult() {
        return this.searchResultGroup.isEnableHighlightSearchResult();
    }

    public boolean isShowSearchResult() {
        return this.searchResultGroup.isShowSearchResult();
    }

    public boolean isExistSearchResult() {
        return this.searchResultGroup.isExistSearchResult();
    }

    void setExistHomCluster(boolean bl) {
        this.existHomCluster = bl;
    }

    public boolean isExistHomCluster() {
        return this.existHomCluster;
    }

    void setDomClustOption(String string) {
        this.domClustOption = string;
    }

    public String getDomClustOption() {
        return this.domClustOption;
    }

    public String getDisplayDomClustName() {
        if (this.getApplicationPropertyConf() != null) {
            return this.getApplicationPropertyConf().getConfName();
        }
        return this.getDomClustName();
    }

    public String getDomClustName() {
        File file = new File(this.getFilepath());
        String string = file.getName();
        return FileUtil.removeExtension(string);
    }

    public List getViewOrganismCodeList() {
        return this.isExistTargetViewOrganismList() ? this.getTargetViewOrganismCodeList() : this.getOrganismCodeList();
    }

    public int getViewOrganismCount() {
        return this.getViewOrganismCodeList().size();
    }

    public List getViewOrganismList() {
        return this.isExistTargetViewOrganismList() ? this.getTargetViewOrganismList() : this.getOrganismList();
    }

    public List getViewIngroupOrganismCodeList() {
        List list = this.getViewOrganismCodeList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (this.isOutgroup(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List getViewOutgroupOrganismCodeList() {
        List list = this.getViewOrganismCodeList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!this.isOutgroup(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List getOrganismCodeList() {
        return this.organismCondition.getOrganismCodeList();
    }

    public Organism getOrganism(String string) {
        return this.organismCondition.getOrganism(string);
    }

    public List getOrganismList(Collection collection) {
        return this.organismCondition.getOrganismList(collection);
    }

    public List getOrganismList() {
        return this.organismCondition.getOrganismList();
    }

    public List getShowControlOrganismList() {
        return this.organismCondition.getShowControlOrganismList();
    }

    public int getOrganismCount() {
        return this.getViewOrganismCodeList().size();
    }

    public List getViewOrderList() {
        return this.m_viewOrderList;
    }

    public int indexOfViewOrderList(Map map) {
        return this.m_viewOrderList.indexOf(map);
    }

    public List getViewClusterList(Map map) {
        return (List)this.m_viewClusterMap.get(map);
    }

    void setMaxClusterId(int n) {
        this.modifiedClusterManager.setStartClusterId(n);
    }

    public List getClusterList() {
        return this.m_clusterList;
    }

    public List getClusterList(Set set) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : this.getClusterList()) {
            if (!set.contains(cluster.getConbinedClusterId())) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public List getClusterListRegardSubCluster(Set set) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : this.getClusterList()) {
            if (!set.contains(cluster.getCombinedClusterIdRegardSubCluster())) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public Map createClusterMap() {
        return this.createClusterMap(".");
    }

    private Map createClusterMap(String string) {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Cluster cluster : this.m_clusterList) {
            hashMap.put(cluster.getConbinedClusterId(string), cluster);
        }
        return hashMap;
    }

    public Map createLocusTagClusterMap(String string) {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Cluster cluster : this.m_clusterList) {
            List list = cluster.getLocusTagList(string);
            if (list == null) continue;
            for (String string2 : list) {
                hashMap.put(string2, cluster);
            }
        }
        return hashMap;
    }

    public Set createViewOrganismLocusTagKeySet() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.getViewClusterList();
        for (Cluster cluster : list) {
            for (String string : cluster.getSpSet()) {
                List list2 = cluster.getLocusTagWithoutDomainList(string);
                if (CollectionUtil.isNull(list2)) continue;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    String string2 = GeneUtil.removeDomainNo((String)iterator.next());
                    String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
                    hashSet.add(string3);
                }
            }
        }
        return hashSet;
    }

    public Cluster getViewCluster(int n) {
        if (n < 0 || this.m_viewClusterList.size() <= n) {
            return null;
        }
        return (Cluster)this.m_viewClusterList.get(n);
    }

    public List getViewClusterListInPattern(int n) {
        if (n < 0 || this.m_viewOrderList.size() <= n) {
            return null;
        }
        Map map = this.getViewOrder(n);
        return this.getViewClusterList(map);
    }

    public Map getViewOrder(int n) {
        if (n < 0 || this.m_viewOrderList.size() <= n) {
            return null;
        }
        return (Map)this.m_viewOrderList.get(n);
    }

    public List getViewClusterList(Collection collection) {
        Set set = GeneInfoUtil.createOrganismCodeLocusTagSet(collection);
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            for (Map map : this.getViewOrderList()) {
                List list = this.getViewClusterList(map);
                for (Cluster cluster : list) {
                    Set set2 = ClusterUtil.getOrganismCodeLocusTagSet(cluster);
                    set2.retainAll(set);
                    if (CollectionUtil.isNull(set2)) continue;
                    arrayList.add(cluster);
                }
            }
        } else {
            for (Cluster cluster : this.getViewClusterList()) {
                Set set3 = ClusterUtil.getOrganismCodeLocusTagSet(cluster);
                set3.retainAll(set);
                if (CollectionUtil.isNull(set3)) continue;
                arrayList.add(cluster);
            }
        }
        return arrayList;
    }

    public Cluster getViewCluster(String string, String string2) {
        Cluster cluster = null;
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            for (Map map : this.getViewClusterList()) {
                List list = this.getViewClusterList(map);
                for (Cluster cluster2 : list) {
                    if (!cluster2.containsGeneInfo(string, string2)) continue;
                    cluster = cluster2;
                    break;
                }
                if (cluster == null) continue;
                break;
            }
        } else {
            for (Cluster cluster3 : this.getViewClusterList()) {
                if (!cluster3.containsGeneInfo(string, string2)) continue;
                cluster = cluster3;
                break;
            }
        }
        return cluster;
    }

    public int getViewClusterIndex(Cluster cluster) {
        int n = -1;
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            List list = this.getViewOrderList();
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                List list2 = this.getViewClusterList(map);
                if (!list2.contains(cluster)) continue;
                n = i;
                break;
            }
        } else {
            n = this.getViewClusterList().indexOf(cluster);
        }
        return n;
    }

    public Map createViewClusterRowIndexMap() {
        HashMap<Cluster, Integer> hashMap = new HashMap<Cluster, Integer>();
        int n = 0;
        for (Cluster cluster : this.getViewClusterList()) {
            hashMap.put(cluster, new Integer(n));
            ++n;
        }
        return hashMap;
    }

    public int getViewPatternIndex(Map map) {
        int n = this.getViewOrderList().indexOf(map);
        return n;
    }

    public Map createPatternMapRowIndexMap() {
        HashMap<Map, Integer> hashMap = new HashMap<Map, Integer>();
        int n = 0;
        for (Map map : this.getViewOrderList()) {
            hashMap.put(map, new Integer(n));
            ++n;
        }
        return hashMap;
    }

    public List getViewClusterList() {
        return this.m_viewClusterList;
    }

    public List getViewSuperClusterList() {
        return this.m_viewSuperClusterList;
    }

    public int getRowCount() {
        int n = this.getViewOrderList().size();
        if (!this.m_optionTbl.getOptionValues().isIntensive()) {
            n = this.getViewClusterList().size();
        }
        return n;
    }

    public boolean isLimitNoListForAggregate() {
        return this.m_noListForAggregate.size() > 0;
    }

    public boolean isLimitNoListForDisaggregate() {
        return this.m_noListForDisaggregate.size() > 0;
    }

    public void limitReleaseForAggregate() throws SortException {
        for (List list : this.m_noListForAggregate) {
            list.clear();
            list = null;
        }
        this.m_noListForAggregate.clear();
        this.setViewOrderList();
    }

    public void limitReleaseForDisaggregate() throws SortException {
        for (List list : this.m_noListForDisaggregate) {
            list.clear();
            list = null;
        }
        this.m_noListForDisaggregate.clear();
        this.setViewClusterList();
    }

    private boolean isSearchResultCluster(Map map) {
        List list = this.getViewClusterList(map);
        if (list == null) {
            return false;
        }
        for (Cluster cluster : list) {
            if (!this.searchResultGroup.containsSearchResult(cluster)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSearchResultCluster(Cluster cluster) {
        return this.searchResultGroup.containsSearchResult(cluster);
    }

    public SearchCondition getSearchCondition() {
        return this.searchResultGroup.getCondition();
    }

    public SearchResultGroup getSearchResultGroup() {
        return this.searchResultGroup;
    }

    public List getSearchResultList(Cluster cluster) {
        return this.searchResultGroup.getSearchResultList(cluster);
    }

    public List getSearchResultLocusTagList(Cluster cluster, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getSearchResultList(cluster);
        if (CollectionUtil.isNull(list)) {
            return arrayList;
        }
        if (this.searchResultGroup.isCluster()) {
            return cluster.getLocusTagList(string);
        }
        for (KeywordSearchResult keywordSearchResult : list) {
            if (!keywordSearchResult.equalsOrganismCode(string)) continue;
            arrayList.add(keywordSearchResult.getLocusTag());
        }
        return arrayList;
    }

    void updateOrganismList(List list) {
        this.organismCondition.updateOrganismList(list);
    }

    void setIngroupOrganismList(List list) {
        this.organismCondition.setIngroupOrganismList(list);
    }

    void setOutgroupOrganismList(List list) {
        this.organismCondition.setOutgroupOrganismList(list);
    }

    void setClusterList(List list) {
        this.m_clusterList = list;
    }

    void setPatternClusterMap(Map map) {
        this.patternClusterMap = map;
    }

    private void setOrderList(List list) {
        this.m_orderList = list;
    }

    void updatePatternGroup() {
        this.patternGroup.clear();
        this.patternGroup.setDomClustId(this.getClusterId());
        this.patternGroup.setOrganismCodeList(this.getOrganismCodeList());
    }

    private void updateOrganismSetGroup() {
        OrganismSetGroup.getInstance().clear();
        OrganismSetGroup.getInstance().setOrganismCodeC(this.getOrganismCodeList());
    }

    List getDomClustAccessableList() {
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.add(this.organismCondition);
        arrayList.add(this.modifiedClusterManager);
        arrayList.add(this.setConditionGroup);
        arrayList.add(this.baseColorCondition);
        arrayList.add(this.geneColorConditionGroup);
        arrayList.add(this.patternGroup);
        arrayList.add(this.hClustResult.getHclustCondition());
        arrayList.add(OrganismSetGroup.getInstance());
        arrayList.add(FilterFacade.getInstance().getFilterConditionManager());
        arrayList.add(ColorFacade.getInstance().getColorDrawableManager());
        return arrayList;
    }

    void initPPMLabelConditionGroup() {
        this.ppmLabelConditionGroup.initCondition(this);
    }

    void setLocusTagClusterMap(Map map) {
        this.locusTagClusterMap = map;
    }

    private void updateLocusTagClusterMap() {
        this.locusTagClusterMap = ClusterTblCreater.updateClusterMap(this.getClusterList(), this.getOrganismCodeList());
    }

    public void updatePatternClusterMap() {
        this.patternClusterMap = new HashMap();
        List list = this.getClusterList();
        if (ClusterMode.isClusterMode()) {
            list = ClusterTbl.createSuperClusterListByCluster(this.getClusterList());
        }
        for (Cluster cluster : list) {
            Map map = cluster.getPatternMap();
            ArrayList<Cluster> arrayList = (ArrayList<Cluster>)this.patternClusterMap.get(map);
            if (arrayList == null) {
                arrayList = new ArrayList<Cluster>();
                this.patternClusterMap.put(map, arrayList);
            }
            if (cluster instanceof SuperCluster) {
                arrayList.addAll(((SuperCluster)cluster).getSubClusterList());
                continue;
            }
            arrayList.add(cluster);
        }
    }

    public Map getClusterMap() {
        return this.locusTagClusterMap;
    }

    public Cluster getCluster(String string, String string2) {
        return (Cluster)this.locusTagClusterMap.get(GeneUtil.createOrganismLocusTagKey(string, string2));
    }

    public List getClusterList(String string, String string2) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        Cluster cluster = this.getCluster(string, string2);
        if (cluster != null) {
            arrayList.add(cluster);
        } else {
            String string3;
            int n = 1;
            while ((cluster = this.getCluster(string, string3 = GeneUtil.combineLocusTagDomainNo(string2, n))) != null) {
                arrayList.add(cluster);
                ++n;
            }
        }
        return arrayList;
    }

    public static List createSuperClusterListByCluster(List list) {
        ArrayList<SuperCluster> arrayList = new ArrayList<SuperCluster>();
        HashMap<Integer, SuperCluster> hashMap = new HashMap<Integer, SuperCluster>();
        for (Cluster cluster : list) {
            SuperCluster superCluster = (SuperCluster)hashMap.get(new Integer(cluster.getClusterId()));
            if (superCluster == null) {
                superCluster = new SuperCluster();
                hashMap.put(new Integer(cluster.getClusterId()), superCluster);
                arrayList.add(superCluster);
            }
            superCluster.addSubCluster(cluster);
        }
        return arrayList;
    }

    public static List createSuperClusterListByHomCluster(List list) {
        ArrayList<SuperCluster> arrayList = new ArrayList<SuperCluster>();
        HashMap<Integer, SuperCluster> hashMap = new HashMap<Integer, SuperCluster>();
        for (Cluster cluster : list) {
            SuperCluster superCluster = (SuperCluster)hashMap.get(new Integer(cluster.getHomClusterId()));
            if (superCluster == null) {
                superCluster = new SuperCluster();
                hashMap.put(new Integer(cluster.getHomClusterId()), superCluster);
                arrayList.add(superCluster);
            }
            superCluster.addSubCluster(cluster);
        }
        return arrayList;
    }

    public List createSuperClusterList(List list, int n, int n2, int n3, int n4) {
        if (list.size() == 0) {
            return this.m_viewSuperClusterList;
        }
        this.m_viewSuperClusterList.clear();
        Cluster cluster = ClusterTbl.createSuperCluster((Cluster)list.get(n), list, 0, n);
        if (cluster == null) {
            return null;
        }
        this.m_viewSuperClusterMap.put(new Integer(cluster.getClusterId()), new Integer(this.m_viewSuperClusterList.size()));
        this.m_viewSuperClusterList.add(0, cluster);
        this.appendSuperCluster(list, cluster.getClusterId(), 0, n + 1, n + n2 - 1, n4);
        return this.m_viewSuperClusterList;
    }

    protected void appendSuperCluster(List list, int n, int n2, int n3, int n4, int n5) {
        for (int i = n3; i < list.size(); ++i) {
            if (n3 >= list.size()) {
                return;
            }
            if (n2 >= n5) {
                return;
            }
            Cluster cluster = ClusterTbl.createSuperCluster((Cluster)list.get(n3), list, n3, 0);
            if (n != cluster.getClusterId()) {
                this.m_viewSuperClusterMap.put(new Integer(cluster.getClusterId()), new Integer(this.m_viewSuperClusterList.size()));
                this.m_viewSuperClusterList.add(cluster);
                n = cluster.getClusterId();
            }
            n2 = n3 > n4 ? n2 + 1 : n2;
            ++n3;
        }
    }

    public static List createNbrClusterList(List list, int n, int n2, int n3, int n4) {
        ArrayList arrayList = new ArrayList();
        int n5 = list.size();
        for (int i = n3; i <= n4; ++i) {
            int n6;
            if (i == 0 || (n6 = i + n2 + n) < 0) continue;
            if (n6 >= n5) break;
            arrayList.add(list.get(n6));
        }
        return arrayList;
    }

    public static Map createLocusTagMap(List list, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            List list2;
            Cluster cluster = (Cluster)list.get(i);
            if (cluster == null || (list2 = cluster.getLocusTagList(string)) == null) continue;
            for (int j = 0; j < list2.size(); ++j) {
                String string2 = (String)list2.get(j);
                if (string2 == null || !GeneUtil.isDomain(string2) || hashMap.containsKey(string2 = GeneUtil.removeDomainNo(string2))) continue;
                hashMap.put(string2, string2);
            }
        }
        return hashMap;
    }

    public static Cluster createSuperCluster(Cluster cluster, List list, int n, int n2) {
        Cluster cluster2 = cluster;
        int n3 = 0;
        int n4 = cluster.getClusterId();
        SuperCluster superCluster = new SuperCluster();
        while (cluster2.getClusterId() == n4) {
            superCluster.addSubCluster(cluster2);
            if (n + n2 + ++n3 >= list.size()) break;
            cluster2 = (Cluster)list.get(n + n2 + n3);
        }
        return superCluster;
    }

    public int indexOfClusterListByCluster(List list, Cluster cluster) {
        if (cluster == null) {
            return -1;
        }
        int n = cluster.getClusterId();
        return (Integer)this.m_viewSuperClusterMap.get(new Integer(n));
    }

    private void createIntensiveData(int n) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        HashMap hashMap = new HashMap();
        List list = this.m_viewClusterList;
        if (ClusterMode.isBaseCluster(n)) {
            list = ClusterTbl.createSuperClusterListByCluster(this.m_viewClusterList);
        }
        for (Cluster cluster : list) {
            Map map = cluster.getPatternMap();
            if (map.isEmpty()) continue;
            ArrayList<Cluster> arrayList2 = (ArrayList<Cluster>)hashMap.get(map);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Cluster>();
                hashMap.put(map, arrayList2);
                arrayList.add(map);
            }
            if (ClusterMode.isBaseCluster(n)) {
                arrayList2.addAll(((SuperCluster)cluster).getSubClusterList());
                continue;
            }
            arrayList2.add(cluster);
        }
        this.m_viewClusterMap.clear();
        this.m_viewOrderList.clear();
        this.m_viewClusterMap.putAll(hashMap);
        this.m_viewOrderList.addAll(arrayList);
    }

    private void createUnintensiveData() {
        this.m_viewClusterList.clear();
        for (Map map : this.m_viewOrderList) {
            List list = (List)this.m_viewClusterMap.get(map);
            if (list == null) continue;
            if (this.isOutgroup()) {
                int n = ClusterMode.isClusterMode() ? 3 : 4;
                Collections.sort(list, new ClusterComparator(n));
            } else {
                Collections.sort(list, new ClusterComparator(3));
            }
            this.m_viewClusterList.addAll(list);
        }
        this.recreateViewSuperClusterList();
    }

    public void sortClusterList(SortCondition sortCondition, ProgressImpl progressImpl) throws SortException {
        if (SortType.isCluster(sortCondition.getSortType())) {
            Sortable sortable = SortableFactory.createClusterCountSortable(this.m_orderList, this.patternClusterMap);
            sortable.setProgressImpl(progressImpl);
            sortable.sort();
            this.updatePatternListBySort(sortable.getResultPatternList());
            this.createUnintensiveData();
        } else if (SortType.isGeneInfo(sortCondition.getSortType())) {
            InfoSortCondition infoSortCondition = (InfoSortCondition)sortCondition;
            Sortable sortable = SortableFactory.createGeneInfoSortable(infoSortCondition.getInoutType(), this.m_clusterList, infoSortCondition);
            sortable.setProgressImpl(progressImpl);
            sortable.sort();
            this.updateClusterListBySort(sortable.getResultClusterList());
            this.createIntensiveData(sortCondition.getInoutType());
        } else if (SortType.isPatternCoef(sortCondition.getSortType())) {
            GeneInfoSortConditionGroup geneInfoSortConditionGroup = (GeneInfoSortConditionGroup)sortCondition;
            Sortable sortable = SortableFactory.createPatternCoefSortable(geneInfoSortConditionGroup.getInoutType(), this.m_clusterList, geneInfoSortConditionGroup);
            sortable.setProgressImpl(progressImpl);
            sortable.sort();
            this.updateClusterListBySort(sortable.getResultClusterList());
            this.createIntensiveData(sortCondition.getInoutType());
            Map map = ((GeneInfoSortable)sortable).getClusterInfoMap();
            if (!MapUtil.isNull(map)) {
                HashSet<AbstractInfoTitle> hashSet = new HashSet<AbstractInfoTitle>();
                hashSet.add(ClusterInfoUtil.getPatternCoefTitle(2));
                hashSet.add(ClusterInfoUtil.getPatternCoefTitle(1));
                ClusterInfoFacade.removeCachedInfo(hashSet);
                ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)ClusterInfoUtil.getPatternCoefTitle(ClusterMode.getClusterMode());
                Map map2 = ClusterInfoUtil.convertClusterInfoKeyMap(map, clusterInfoTitle.getInfoType());
                ClusterInfoFacade.addClusterInfo(map2, clusterInfoTitle, clusterInfoTitle.getInfoType());
                this.setPPMLabelCondition(PPMLabelConditionFactory.createPatternCoefLabelCondition(this.isOutgroup()));
            }
        }
        this.setSortCondition(sortCondition);
        if (!(sortCondition instanceof HClustCondition)) {
            this.clearHClustResult();
        }
        System.gc();
    }

    private void updateClusterListBySort(List list) {
        this.m_clusterList.clear();
        this.m_clusterList.addAll(list);
        HashSet hashSet = new HashSet(this.m_viewClusterList);
        this.m_viewClusterList.clear();
        for (Cluster cluster : list) {
            if (!hashSet.contains(cluster)) continue;
            this.m_viewClusterList.add(cluster);
        }
        this.recreateViewSuperClusterList();
    }

    private void updatePatternListBySort(List list) {
        this.m_orderList.clear();
        this.m_orderList.addAll(list);
        HashSet hashSet = new HashSet(this.m_viewOrderList);
        this.m_viewOrderList.clear();
        for (Map map : list) {
            if (!hashSet.contains(map)) continue;
            this.m_viewOrderList.add(map);
        }
    }

    public boolean isIngroup(String string) {
        if (!this.organismCondition.isExistIngroup()) {
            return false;
        }
        return this.getIngroupSpList().contains(string);
    }

    public boolean isOutgroup(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        if (!this.organismCondition.isExistOutgroup()) {
            return false;
        }
        return this.getOutgroupSpList().contains(string);
    }

    public boolean isOutgroup(Organism organism) {
        return this.isOutgroup(organism.getOrganismCode());
    }

    public boolean isOutgroup() {
        return this.organismCondition.isExistOutgroup();
    }

    public void changeOrderOrganismList(List list) {
        this.organismCondition.changeOrderOrganismList(list);
    }

    public boolean isSyncOrganismSelect() {
        return this.organismCondition.isSyncOrganismSelect();
    }

    public void setSyncOrganismSelect(boolean bl) {
        this.organismCondition.setSyncOrganismSelect(bl);
    }

    public void addOrganismColumn(Collection collection) {
        this.organismCondition.addOrganismColumnSet(collection);
    }

    public void removeOrganismColumn(Collection collection) {
        this.organismCondition.removeOrganismColumnC(collection);
    }

    public void updateViewOrganismList() {
        this.organismCondition.updateViewOrganismList();
    }

    public List getTargetViewOrganismCodeList() {
        return this.organismCondition.getTargetViewOrganismCodeList();
    }

    private List getTargetViewOrganismList() {
        return this.organismCondition.getTargetViewOrganismList();
    }

    private boolean isExistTargetViewOrganismList() {
        return this.organismCondition.isExistTargetViewOrganismList();
    }

    public boolean isShowOrganismCode(String string) {
        return this.organismCondition.isShowOrganismCode(string);
    }

    public List getUpgmaRootNodeList() {
        return this.hClustResult.getViewRootNodeList();
    }

    public boolean isExistHClustResult() {
        return this.hClustResult.isExistResult();
    }

    public boolean isExistHClustMergedResult() {
        return this.hClustResult.isExistMergedResult();
    }

    public void clearHClustResult() {
        this.hClustResult.clear();
        this.m_clusterList4release = null;
        this.m_viewClusterList4release = null;
    }

    public double get_hClustMaxDist() {
        return this.hClustResult.getMaxDist();
    }

    private List getFilteredClusterList() {
        ArrayList arrayList = new ArrayList();
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            for (Map map : this.getViewOrderList()) {
                arrayList.addAll(this.getViewClusterList(map));
            }
        } else {
            arrayList.addAll(this.getViewClusterList());
        }
        return arrayList;
    }

    public Map createFilteredClusterMap() {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        List list = this.getFilteredClusterList();
        for (Cluster cluster : list) {
            hashMap.put(cluster.getConbinedClusterId(), cluster);
        }
        return hashMap;
    }

    public List getClusterList(int n) {
        List list = new ArrayList();
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            if (n < this.getViewOrderList().size()) {
                Map map = this.getViewPatternMap(n);
                list = new ArrayList(this.getViewClusterList(map));
            }
        } else {
            list = this.getClusterListForExtensiveBySameClusterID(n);
        }
        return list;
    }

    public List getClusterListForIntensiveBySamePattern(int n) {
        return this.getViewClusterList((Map)this.getViewOrderList().get(n));
    }

    public List getClusterListForExtensiveBySameClusterID(int n) {
        Cluster cluster = (Cluster)this.getViewClusterList().get(n);
        return this.getClusterListForExtensiveBySameClusterID(n, cluster);
    }

    public List getClusterListForExtensiveBySameClusterID(Cluster cluster) {
        int n = this.getViewClusterIndex(cluster);
        return this.getClusterListForExtensiveBySameClusterID(n, cluster);
    }

    private List getClusterListForExtensiveBySameClusterID(int n, Cluster cluster) {
        Cluster cluster2;
        int n2;
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        arrayList.add(cluster);
        for (n2 = n - 1; n2 >= 0 && cluster.equalsClusterId(cluster2 = (Cluster)this.getViewClusterList().get(n2)); --n2) {
            arrayList.add(cluster2);
        }
        for (n2 = n + 1; n2 < this.getViewClusterList().size() && cluster.equalsClusterId(cluster2 = (Cluster)this.getViewClusterList().get(n2)); ++n2) {
            arrayList.add(cluster2);
        }
        return arrayList;
    }

    public List getClusterListForExtensiveBySameHomClusterID(int n) {
        Cluster cluster;
        int n2;
        Cluster cluster2 = (Cluster)this.getViewClusterList().get(n);
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        arrayList.add(cluster2);
        for (n2 = n - 1; n2 >= 0 && cluster2.equalsHomClusterId(cluster = (Cluster)this.getViewClusterList().get(n2)); --n2) {
            arrayList.add(cluster);
        }
        for (n2 = n + 1; n2 < this.getViewClusterList().size() && cluster2.equalsHomClusterId(cluster = (Cluster)this.getViewClusterList().get(n2)); ++n2) {
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public List getIngroupSpList() {
        return this.organismCondition.getIngroupOrganismCodeList();
    }

    public int getIngroupSpCount() {
        return this.organismCondition.getIngroupSize();
    }

    public List getOutgroupSpList() {
        return this.organismCondition.getOutgroupOrganismCodeList();
    }

    public int getOutgroupSpCount() {
        return this.organismCondition.getOutgroupSize();
    }

    public Set getLocusTagWithoutDomainList(String string) {
        HashSet hashSet = new HashSet();
        for (Cluster cluster : this.m_clusterList) {
            List list = cluster.getLocusTagWithoutDomainList(string);
            if (list == null) continue;
            hashSet.addAll(list);
        }
        return hashSet;
    }

    public int getClusterCountOnAggregateMode(int n) {
        return ((List)this.m_viewClusterMap.get(this.m_viewOrderList.get(n))).size();
    }

    public Map getViewPatternMap(int n) {
        if (n < 0 || n > this.m_viewOrderList.size()) {
            return null;
        }
        return (Map)this.m_viewOrderList.get(n);
    }

    public void setSortCondition(SortCondition sortCondition) {
        this.sortCondition = sortCondition;
    }

    public SortCondition getSortCondition() {
        return this.sortCondition;
    }

    public void flipPppmHeaderSortOrder(String string) {
        this.ppmHeaderSortOrder = this.getSortCondition() != null && this.getSortCondition().getSortName().equals(string) ? (SortOrder.isAsc(this.ppmHeaderSortOrder) ? 2 : 1) : 1;
    }

    public int getPpmHeaderSortOrder() {
        return this.ppmHeaderSortOrder;
    }

    public Map createGeneDomainMap() {
        HashMap hashMap = new HashMap();
        for (Cluster cluster : this.m_clusterList) {
            hashMap.putAll(cluster.createGeneDomainMap());
        }
        return hashMap;
    }

    public Map getNeighboringClusterMap() {
        return this.neighboringClusterMap;
    }

    public int getNeighborGroupId(Cluster cluster, String string) {
        int n = -1;
        if (!this.isExistNeighboringCluster()) {
            return n;
        }
        List list = cluster.getGeneInformationList(string);
        if (list == null || list.isEmpty()) {
            return n;
        }
        for (GeneInformation geneInformation : list) {
            if (!this.neighboringClusterMap.containsKey(geneInformation)) continue;
            int n2 = (Integer)this.neighboringClusterMap.get(geneInformation);
            if (n == -1) {
                n = n2;
                continue;
            }
            n = n > n2 ? n2 : n;
        }
        return n;
    }

    public int getNeighborGroupId(GeneInformation geneInformation) {
        int n = -1;
        if (!this.isExistNeighboringCluster()) {
            return n;
        }
        if (geneInformation == null) {
            return n;
        }
        if (this.neighboringClusterMap.containsKey(geneInformation)) {
            n = (Integer)this.neighboringClusterMap.get(geneInformation);
        }
        return n;
    }

    public Map getNeighborGroupLocusTagMap(Cluster cluster, String string) {
        Object object2;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        List list = cluster.getGeneInformationList(string);
        if (list == null || list.isEmpty()) {
            return linkedHashMap;
        }
        HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
        for (Object object2 : list) {
            int n = this.getNeighborGroupId((GeneInformation)object2);
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(new Integer(n), arrayList);
            }
            arrayList.add(((GeneInformation)object2).getLocusTag());
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        if (arrayList.size() != 1 && (Integer)arrayList.get(0) == -1) {
            arrayList.remove(0);
            arrayList.add(new Integer(-1));
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Integer n = (Integer)object2.next();
            linkedHashMap.put(n, hashMap.get(n));
        }
        return linkedHashMap;
    }

    public void setNeighboringClusterMap(Map map) {
        this.neighboringClusterMap = map;
    }

    public NeighboringClustCondition getNeighboringClustCondition() {
        return this.neighboringClustCondition;
    }

    public void setNeighboringClustCondition(NeighboringClustCondition neighboringClustCondition) {
        this.neighboringClustCondition = neighboringClustCondition;
    }

    public boolean isShowNeighboringCluster() {
        return this.showNeighbor;
    }

    public boolean isExistNeighboringCluster() {
        return !MapUtil.isNull(this.neighboringClusterMap);
    }

    public boolean isEnableNeighboringCluster() {
        return this.isShowNeighboringCluster() && this.isExistNeighboringCluster();
    }

    public void setShowNeighboringCluster(boolean bl) {
        this.showNeighbor = bl;
    }

    public boolean isHilightNeighboringGene() {
        return this.hilightNeighbor;
    }

    public void setHilightNeighboringGene(boolean bl) {
        this.hilightNeighbor = bl;
    }

    public void clearNeighboringCluster() {
        this.setShowNeighboringCluster(false);
        this.setNeighboringClusterMap(null);
        this.setNeighboringClustCondition(null);
        this.setHilightNeighboringGene(false);
    }

    public boolean isShowGeneInfoColor() {
        return this.geneColorConditionGroup.isEnableShow();
    }

    public void setShowGeneColor(boolean bl) {
        this.geneColorConditionGroup.setShowGeneColor(bl);
    }

    public boolean isShowGeneColor() {
        return this.geneColorConditionGroup.isShowGeneColor();
    }

    public boolean isEnableGeneColor() {
        return this.geneColorConditionGroup.isEnableShow();
    }

    public boolean isExistGeneColor() {
        return this.geneColorConditionGroup.isExistGeneColor();
    }

    public void setGeneColorConditionInfo(int n) {
        this.geneColorConditionGroup.setCalcMethodType(n);
    }

    public void addGeneColorCondition(GeneColorCondition geneColorCondition) {
        this.geneColorConditionGroup.addGeneColorCondition(geneColorCondition);
    }

    public void saveGeneColorConditionGroup() {
        if (StringTool.isNull(this.getClusterId())) {
            return;
        }
        try {
            ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
            arrayList.add(this.geneColorConditionGroup);
            arrayList.add(ColorFacade.getInstance().getColorDrawableManager());
            ApplicationPropertyFacade.saveProperty(this.getClusterId(), arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save taxonomy filter condition.", iOException);
        }
    }

    public Color getGeneColor(Cluster cluster, String string, String string2) {
        return this.geneColorConditionGroup.getColor(cluster, string, GeneUtil.removeDomainNo(string2));
    }

    public GeneColorCondition getGeneColorCommonCondition(Set hashSet) {
        if (CollectionUtil.isNull(hashSet)) {
            hashSet = new HashSet(this.getViewOrganismCodeList());
        }
        return this.geneColorConditionGroup.getGeneColorCommonCondition(hashSet);
    }

    public void removeGeneColorCondition(Set set) {
        this.geneColorConditionGroup.removeGeneColorCondition(set);
    }

    public void clearGeneColorCondition() {
        this.geneColorConditionGroup.clear();
    }

    public Map getColorLocusTagMap(String string, List list) {
        return this.geneColorConditionGroup.getColorLocusTagMap(string, list);
    }

    public Color getColorByCell(String string, Cluster cluster) {
        return this.geneColorConditionGroup.getColorByCell(string, cluster);
    }

    public Map getClusterColorMap(String string, Cluster cluster) {
        return this.geneColorConditionGroup.getClusterColorMap(string, cluster);
    }

    public GeneColorConditionGroup getGeneColorConditionGroup() {
        return this.geneColorConditionGroup;
    }

    public AbstractInfoTitle getGeneColorInfoTitle(String string) {
        return this.geneColorConditionGroup.getInfoTitle(string);
    }

    public void setHistogramCondition(HistogramCondition histogramCondition) {
        this.histogramCondition = histogramCondition;
    }

    public HistogramCondition getHistogramCondition() {
        return this.histogramCondition;
    }

    public PPMLabelCondition getSelectedPpmLabelCondition() {
        return this.ppmLabelConditionGroup.getSelectedCondition();
    }

    public void setSelectedPpmLabelCondition(PPMLabelCondition pPMLabelCondition) {
        this.ppmLabelConditionGroup.setSelectedCondition(pPMLabelCondition);
    }

    public List getPpmLabelConditionList() {
        return this.ppmLabelConditionGroup.getConditionList();
    }

    public boolean isExistPatternCoef() {
        return this.ppmLabelConditionGroup.isExistPatternCoef();
    }

    public boolean containsInfoTitleInSelectedPPPMLabel(AbstractInfoTitle abstractInfoTitle) {
        return this.ppmLabelConditionGroup.constainsInfoTitleInSelectedPPPMLabel(abstractInfoTitle);
    }

    public void initPPMLabel() {
        this.ppmLabelConditionGroup.initCondition(this);
    }

    public boolean equalsSelectedPPMLabelCondition(PPMLabelCondition pPMLabelCondition) {
        return this.ppmLabelConditionGroup.equalsSelectedPPMLabelCondition(pPMLabelCondition);
    }

    public void setPPMLabelCondition(PPMLabelCondition pPMLabelCondition) {
        this.ppmLabelConditionGroup.setCondition(pPMLabelCondition, this);
    }

    public String getFilepath() {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_filepath");
        return (String)this.clusterInfo.getInfo(clusterInfoTitle);
    }

    void setFilepath(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_filepath");
        this.clusterInfo.putInfo(clusterInfoTitle, string);
    }

    public String getServerUrl() {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_exec_server_url");
        return (String)this.clusterInfo.getInfo(clusterInfoTitle);
    }

    public void setServerUrl(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_exec_server_url");
        this.clusterInfo.putInfo(clusterInfoTitle, string);
    }

    public String getClusterId() {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_id");
        return (String)this.clusterInfo.getInfo(clusterInfoTitle);
    }

    void setClusterId(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_id");
        this.clusterInfo.putInfo(clusterInfoTitle, string);
        ModifiedOrganismManager.getInstance().setDomClustId(string);
    }

    public String getClusterViewId() {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_view_id");
        return (String)this.clusterInfo.getInfo(clusterInfoTitle);
    }

    void setClusterViewId(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_view_id");
        this.clusterInfo.putInfo(clusterInfoTitle, string);
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public int getMaxGeneCount() {
        int n = 0;
        for (Cluster cluster : this.getClusterList()) {
            n = Math.max(n, cluster.getGeneCount());
        }
        return n;
    }

    public void clearSetCondition() {
        this.setConditionGroup.clearSetCondition();
        this.saveSetCondition();
    }

    public List getSetConditionList() {
        return this.setConditionGroup.getSetConditionList();
    }

    public List getSetConditionList(int n) {
        return this.setConditionGroup.getSetConditionList(n);
    }

    public SetConditionGroup getSetConditionGroup() {
        return this.setConditionGroup;
    }

    public boolean isExistSetCondition(int n) {
        return this.setConditionGroup.isExistSetCondition(n);
    }

    public boolean isEnableSetColor() {
        return this.setConditionGroup.isEnableColor();
    }

    public void saveSetCondition() {
        if (StringTool.isNull(this.getClusterId())) {
            return;
        }
        try {
            ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
            arrayList.add(this.setConditionGroup);
            arrayList.add(FilterFacade.getInstance().getFilterConditionManager());
            arrayList.add(ColorFacade.getInstance().getColorDrawableManager());
            ApplicationPropertyFacade.saveProperty(this.getClusterId(), arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save taxonomy filter condition.", iOException);
        }
    }

    public BaseColorCondition getBaseColorCondition() {
        return this.baseColorCondition;
    }

    public PPMSelectionManager getPpmSelectionManager() {
        return this.ppmSelectionManager;
    }

    public boolean containsSelectedIndex(int n) {
        return this.getPpmSelectionManager().containsSelectedIndex(n);
    }

    public boolean isExistSelectedCluster() {
        return this.getPpmSelectionManager().isExistSelectedCluster();
    }

    public int getSelectedRowIndex() {
        return this.getPpmSelectionManager().getSelectedRow();
    }

    public int getSelectedBaseRowIndex() {
        return this.getPpmSelectionManager().getBaseRowIndex();
    }

    public Cluster getSelectedBaseCluster() {
        int n = this.getSelectedBaseRowIndex();
        return this.getViewCluster(n);
    }

    public Map getSelectedBasePattern() {
        int n = this.getSelectedBaseRowIndex();
        return this.getViewPatternMap(n);
    }

    public String getSelectedOrganismCode() {
        return this.getPpmSelectionManager().getSelectedOrganismCode();
    }

    public Set getSelectedOrganismCodeSet() {
        return this.getPpmSelectionManager().getSelectedOrganismSet();
    }

    public boolean isSelectedOrganismCode() {
        return this.getPpmSelectionManager().isExistSelectedOrganism();
    }

    public void setSelectedCluster(String string, Collection collection) {
        this.getPpmSelectionManager().setSelectedCluster(string, collection, this);
    }

    public List getSelectedClusterList() {
        return this.getPpmSelectionManager().getSelectedClusterList(this);
    }

    public void addSelectedCluster(String string, Collection collection) {
        this.getPpmSelectionManager().addSelectedCluster(string, collection, this);
    }

    public void flipSelectedCluster(String string, Collection collection) {
        this.getPpmSelectionManager().flipSelectedCluster(string, collection, this);
    }

    public void clearSelection() {
        this.getPpmSelectionManager().clearSelection();
    }

    public void saveOrganismColumn() {
        if (StringTool.isNull(this.getClusterId())) {
            return;
        }
        try {
            ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.organismCondition);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save organism condition.", iOException);
        }
    }

    public PatternGroup getPatternGroup() {
        return this.patternGroup;
    }

    public void addPatern(Pattern pattern) {
        this.patternGroup.addPattern(pattern);
    }

    public void removePattern(Set set) {
        this.patternGroup.removePattern(set);
    }

    public void removePattern(Pattern pattern) {
        this.patternGroup.removePattern(pattern);
    }

    public void savePattern() {
        try {
            ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.patternGroup);
        }
        catch (IOException iOException) {
            String string = "Fail to save pattern.";
            logger.warn(string, iOException);
        }
    }

    public void replacePattern(Pattern pattern, Pattern pattern2) {
        this.patternGroup.replacePattern(pattern, pattern2);
    }

    public boolean updateInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        boolean bl = false;
        if (this.getSortCondition().containsInfo(abstractInfoTitle)) {
            BasicSortCondition basicSortCondition = SortConditionFactory.createFrequencyClusterCondition(ClusterMode.getClusterMode());
            this.setSortCondition(basicSortCondition);
            bl = true;
        }
        if (this.getSearchResultGroup().containsInfoTitle(abstractInfoTitle)) {
            this.getSearchResultGroup().clearSearchResult();
            bl = true;
        }
        if (this.getHistogramCondition() != null && this.getHistogramCondition().containsInfoTitle(abstractInfoTitle)) {
            this.setHistogramCondition(null);
            bl = true;
        }
        if (this.containsInfoTitleInSelectedPPPMLabel(abstractInfoTitle)) {
            this.initPPMLabel();
        }
        if (this.getGeneColorConditionGroup().containsInfoTitle(abstractInfoTitle)) {
            this.getGeneColorConditionGroup().clear();
            bl = true;
        }
        return bl;
    }

    public ApplicationPropertyConf getApplicationPropertyConf() {
        return this.applicationPropertyConf;
    }

    public void setApplicationPropertyConf(ApplicationPropertyConf applicationPropertyConf) {
        this.applicationPropertyConf = applicationPropertyConf;
    }

    void updatePatternInfo() {
        HashMap<Map, ArrayList<Cluster>> hashMap = new HashMap<Map, ArrayList<Cluster>>();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (Cluster cluster : this.m_clusterList) {
            Map map = cluster.getPatternMap();
            ArrayList<Cluster> arrayList2 = (ArrayList<Cluster>)hashMap.get(map);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Cluster>();
                hashMap.put(map, arrayList2);
                arrayList.add(map);
            }
            arrayList2.add(cluster);
        }
        this.setPatternClusterMap(hashMap);
        this.setOrderList(arrayList);
    }

    public Cluster mergeCluster(Collection collection) throws Exception {
        MultiCluster multiCluster = this.createMultiCluster(collection);
        Cluster cluster = (Cluster)collection.iterator().next();
        int n = this.m_clusterList.indexOf(cluster);
        this.m_clusterList.add(n, multiCluster);
        n = this.m_viewClusterList.indexOf(cluster);
        if (n != -1) {
            this.m_viewClusterList.add(n, multiCluster);
        }
        this.m_clusterList.removeAll(collection);
        this.m_viewClusterList.removeAll(collection);
        this.updatePatternInfo();
        this.clearHClustResult();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
        return multiCluster;
    }

    public void mergeAllCluster(double d) throws Exception {
        if (this.hClustResult.isExistMergedResult()) {
            this.releaseMergeCluster4All();
        }
        this.m_clusterList4release = new ArrayList(this.m_clusterList);
        this.m_viewClusterList4release = new ArrayList(this.m_viewClusterList);
        List list = HClustAdjuster.createCopyRootNodeList(this.hClustResult.getViewRootNodeList());
        for (ClusterNode clusterNode : list) {
            this.pruning(clusterNode, d);
        }
        this.hClustResult.setMergedRootNodeList(list);
        this.updatePatternInfo();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
    }

    private void pruning(ClusterNode clusterNode, double d) throws Exception {
        if (clusterNode.getMaxDist() <= d) {
            ClusterNode clusterNode2 = (ClusterNode)clusterNode.getParent();
            if (clusterNode2 != null) {
                HashSet hashSet = new HashSet();
                List list = NodeUtil.getLeafNodeList(clusterNode2);
                for (Object object : list) {
                    hashSet.addAll(((ClusterNode)object).getClusterSet());
                }
                if (hashSet.size() > 1) {
                    try {
                        Object object;
                        Cluster cluster = this.mergeCluster4All(hashSet);
                        object = new HashSet();
                        object.add(cluster);
                        clusterNode2.setClusterSet((Set)object);
                        HashSet<String> hashSet2 = new HashSet<String>();
                        hashSet2.add(String.valueOf(cluster.getClusterId()));
                        clusterNode2.setViewClusterIdSet(hashSet2);
                        clusterNode2.setDist(clusterNode2.getMaxDist());
                        clusterNode2.clearChildNode();
                    }
                    catch (Exception exception) {
                        logger.warn("Fail to merge Cluster.", exception);
                    }
                }
            }
        } else {
            if (clusterNode.getNode1() != null) {
                this.pruning((ClusterNode)clusterNode.getNode1(), d);
            }
            if (clusterNode.getNode2() != null) {
                this.pruning((ClusterNode)clusterNode.getNode2(), d);
            }
        }
    }

    private Cluster mergeCluster4All(Set set) throws Exception {
        MultiCluster multiCluster = this.createMultiCluster(set);
        Cluster cluster = (Cluster)set.iterator().next();
        int n = this.m_clusterList.indexOf(cluster);
        this.m_clusterList.add(n, multiCluster);
        n = this.m_viewClusterList.indexOf(cluster);
        if (n != -1) {
            this.m_viewClusterList.add(n, multiCluster);
        }
        this.m_clusterList.removeAll(set);
        this.m_viewClusterList.removeAll(set);
        return multiCluster;
    }

    public void releaseMergeCluster4All() throws Exception {
        this.m_clusterList = this.m_clusterList4release;
        this.m_viewClusterList = this.m_viewClusterList4release;
        this.hClustResult.clearMergedRootNodeList();
        this.updatePatternInfo();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
    }

    public Set releaseMergeCluster(Collection collection) throws Exception {
        HashSet hashSet = new HashSet();
        for (MultiCluster multiCluster : collection) {
            List list = multiCluster.getSubClusterList();
            int n = this.m_clusterList.indexOf(multiCluster);
            this.m_clusterList.addAll(n, list);
            n = this.m_viewClusterList.indexOf(multiCluster);
            if (n != -1) {
                this.m_viewClusterList.addAll(n, list);
            }
            hashSet.addAll(list);
        }
        this.m_clusterList.removeAll(collection);
        this.m_viewClusterList.removeAll(collection);
        this.updatePatternInfo();
        this.clearHClustResult();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
        return hashSet;
    }

    public List getMergeClusterList() {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : this.getClusterList()) {
            if (!cluster.isTypeMergeCluster()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public Set releaseAllMergeCluster() throws Exception {
        List list = this.getMergeClusterList();
        Set set = this.releaseMergeCluster(list);
        return set;
    }

    private MultiCluster createMultiCluster(Collection collection) {
        int n = this.modifiedClusterManager.createClusterId();
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (Cluster cluster : collection) {
            if (cluster.isTypeMergeCluster()) {
                hashSet.addAll(((MultiCluster)cluster).getSubClusterList());
                continue;
            }
            hashSet.add(cluster);
        }
        MultiCluster multiCluster = new MultiCluster(n, hashSet);
        return multiCluster;
    }

    public List splitCluster(Cluster cluster, Collection collection) throws Exception {
        List list = this.createSplitCluster(cluster, collection);
        int n = this.m_clusterList.indexOf(cluster);
        this.m_clusterList.addAll(n, list);
        n = this.m_viewClusterList.indexOf(cluster);
        if (n != -1) {
            this.m_viewClusterList.addAll(n, list);
        }
        this.m_clusterList.remove(cluster);
        this.m_viewClusterList.remove(cluster);
        this.updatePatternInfo();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
        return list;
    }

    private List createSplitCluster(Cluster cluster, Collection collection) {
        Object object;
        Object object2;
        Object object3;
        Set set = GeneInfoUtil.createOrganismCodeLocusTagSet(collection);
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> hashMap2 = new HashMap<String, ArrayList<Object>>();
        for (String string : cluster.getSpSet()) {
            object3 = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull((Collection)object3)) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                List<Object> list;
                object = (GeneInformation)object2.next();
                String string2 = GeneUtil.createOrganismLocusTagKey(string, ((GeneInformation)object).getLocusTag());
                if (set.contains(string2)) {
                    list = (ArrayList<Object>)hashMap.get(string);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        hashMap.put(string, (ArrayList<Object>)list);
                    }
                    list.add(object);
                    continue;
                }
                list = (List)hashMap2.get(string);
                if (list == null) {
                    list = new ArrayList();
                    hashMap2.put(string, (ArrayList<Object>)list);
                }
                list.add(object);
            }
        }
        int n = this.modifiedClusterManager.createClusterId();
        int n2 = this.modifiedClusterManager.createClusterId();
        object3 = new SplitCluster(n, cluster, hashMap);
        object2 = new SplitCluster(n2, cluster, hashMap2);
        object = new ArrayList();
        object.add(object3);
        object.add(object2);
        return object;
    }

    public Set releaseSplitCluster(Collection collection) throws Exception {
        Set set = ClusterUtil.getSplitBaseClusterList(collection);
        List list = this.getSplitClusterList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            Cluster cluster = ((SplitCluster)object).getCluster();
            if (!set.contains(cluster)) continue;
            arrayList.add(object);
        }
        HashSet hashSet = new HashSet();
        for (SplitCluster splitCluster : arrayList) {
            Cluster cluster = splitCluster.getCluster();
            if (hashSet.contains(cluster)) continue;
            int n = this.m_clusterList.indexOf(splitCluster);
            this.m_clusterList.add(n, cluster);
            int n2 = this.m_viewClusterList.indexOf(splitCluster);
            if (n2 != -1) {
                this.m_viewClusterList.add(n2, cluster);
            }
            hashSet.add(cluster);
        }
        this.m_clusterList.removeAll(arrayList);
        this.m_viewClusterList.removeAll(arrayList);
        this.updatePatternInfo();
        this.clearHClustResult();
        this.setViewOrderList();
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), this.modifiedClusterManager);
        this.recreateViewSuperClusterList();
        return hashSet;
    }

    public Set releaseAllSplitCluster() throws Exception {
        List list = this.getSplitClusterList();
        Set set = this.releaseSplitCluster(list);
        return set;
    }

    public List getSplitClusterList() {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : this.getClusterList()) {
            if (!cluster.isTypeSplitCluster()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    void setMergeClusterList(List list) throws SortException {
        HashSet hashSet = new HashSet();
        for (MultiCluster multiCluster : list) {
            List list2 = multiCluster.getSubClusterList();
            Cluster cluster = (Cluster)list2.get(0);
            int n = this.m_clusterList.indexOf(cluster);
            this.m_clusterList.add(n, multiCluster);
            int n2 = this.m_viewClusterList.indexOf(cluster);
            if (n2 != -1) {
                this.m_viewClusterList.add(n2, multiCluster);
            }
            hashSet.addAll(list2);
        }
        this.m_clusterList.removeAll(hashSet);
        this.m_viewClusterList.removeAll(hashSet);
        this.updatePatternInfo();
        this.setViewOrderList();
        this.recreateViewSuperClusterList();
    }

    void setSplitClusterList(List list) throws SortException {
        Map map = ClusterUtil.createSplitClusterMap(list);
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (Cluster cluster : map.keySet()) {
            List list2 = (List)map.get(cluster);
            int n = this.m_clusterList.indexOf(cluster);
            this.m_clusterList.addAll(n, list2);
            int n2 = this.m_viewClusterList.indexOf(cluster);
            if (n2 != -1) {
                this.m_viewClusterList.addAll(n2, list2);
            }
            hashSet.add(cluster);
        }
        this.m_clusterList.removeAll(hashSet);
        this.m_viewClusterList.removeAll(hashSet);
        this.updatePatternInfo();
        this.setViewOrderList();
        this.recreateViewSuperClusterList();
    }

    private boolean isExistMergeCluster() {
        return !CollectionUtil.isNull(this.getMergeClusterList());
    }

    private boolean isExistSplitCluster() {
        return !CollectionUtil.isNull(this.getSplitClusterList());
    }

    public boolean isExistModifiedCluster() {
        return this.isExistMergeCluster() || this.isExistSplitCluster();
    }

    public void mergeOrganism(MergeOrganism mergeOrganism) throws Exception {
        HashSet<MergeOrganism> hashSet = new HashSet<MergeOrganism>();
        hashSet.add(mergeOrganism);
        this.mergeOrganism(hashSet);
        this.updateAfterModifiedOrganism();
    }

    void mergeOrganism(Collection collection) throws Exception {
        for (MergeOrganism mergeOrganism : collection) {
            String string = mergeOrganism.getOrganismCode();
            for (Cluster cluster : this.getClusterList()) {
                for (Organism organism : mergeOrganism.getOrganismList()) {
                    String string2 = organism.getOrganismCode();
                    List list = cluster.getGeneInformationList(string2);
                    if (CollectionUtil.isNull(list)) continue;
                    cluster.addGeneInfo(string, list);
                }
            }
            this.organismCondition.replaceMergeOrganism(mergeOrganism.getOrganismCodeList(), mergeOrganism);
            ModifiedOrganismManager.getInstance().addMergeOrganism(mergeOrganism);
        }
    }

    public void releaseMergeOrganism(Collection collection) throws Exception {
        for (Organism organism : collection) {
            MergeOrganism mergeOrganism = organism instanceof DisplayOrganism ? (MergeOrganism)((DisplayOrganism)organism).getOrganism() : (MergeOrganism)organism;
            for (Cluster cluster : this.getClusterList()) {
                cluster.removeOrganism(mergeOrganism.getOrganismCode());
            }
            this.organismCondition.replaceSplitOrganism(mergeOrganism.getOrganismCode(), mergeOrganism.getOrganismList());
            ModifiedOrganismManager.getInstance().removeMergeOrganism(mergeOrganism);
            ModifiedOrganismManager.getInstance().removeModifiedOrganismFile(this.getClusterId(), organism);
        }
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), ModifiedOrganismManager.getInstance());
        this.updateAfterModifiedOrganism();
    }

    public void splitOrganism(OrganismSplitCondition organismSplitCondition) throws Exception {
        String string = organismSplitCondition.getOrganismCode();
        for (Cluster cluster : this.getClusterList()) {
            List list = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull(list)) continue;
            for (GeneInformation geneInformation : list) {
                String string2 = geneInformation.getLocusTagWithoutDomain();
                Organism organism = organismSplitCondition.findSplitOrganism(string, string2);
                cluster.addGeneInfo(organism.getOrganismCode(), geneInformation);
            }
        }
        this.organismCondition.replaceSplitOrganism(string, organismSplitCondition.getAllSplitOrganismList());
        ModifiedOrganismManager.getInstance().addAllSplitOrganism(organismSplitCondition.getAllSplitOrganismList());
        this.updateAfterModifiedOrganism();
    }

    void splitOrganism(Collection collection) throws Exception {
        Map map = OrganismUtil.createSplitOrganismListMap(collection);
        for (Organism organism : map.keySet()) {
            List list = (List)map.get(organism);
            for (SplitOrganism splitOrganism : list) {
                String string = splitOrganism.getOrganismCode();
                GeneTbl geneTbl = new GeneTbl(string);
                geneTbl.read();
                for (Cluster cluster : this.getClusterList()) {
                    List list2 = cluster.getGeneInformationList(organism.getOrganismCode());
                    if (CollectionUtil.isNull(list2)) continue;
                    for (GeneInformation geneInformation : list2) {
                        String string2 = geneInformation.getLocusTagWithoutDomain();
                        if (!geneTbl.containsKey(string2)) continue;
                        cluster.addGeneInfo(splitOrganism.getOrganismCode(), geneInformation);
                    }
                }
            }
            this.organismCondition.replaceSplitOrganism(organism.getOrganismCode(), list);
            ModifiedOrganismManager.getInstance().addAllSplitOrganism(list);
        }
    }

    public void releaseSplitOrganism(Collection collection) throws Exception {
        Object object;
        Object object2;
        HashSet<Organism> hashSet = new HashSet<Organism>();
        for (Organism organism : collection) {
            object2 = organism instanceof DisplayOrganism ? (SplitOrganism)((DisplayOrganism)organism).getOrganism() : (SplitOrganism)organism;
            object = ((SplitOrganism)object2).getParentOrganism();
            hashSet.add((Organism)object);
        }
        for (Organism organism : hashSet) {
            object2 = ModifiedOrganismManager.getInstance().getSplitOrganismSet(organism.getOrganismCode());
            object = new ArrayList(OrganismUtil.getOrganismCodeList((Collection)object2));
            for (Cluster cluster : this.getClusterList()) {
                cluster.removeAllOrganism((Collection)object);
            }
            this.organismCondition.replaceMergeOrganism((List)object, organism);
            ModifiedOrganismManager.getInstance().removeSplitOrganism((Collection)object2);
            ModifiedOrganismManager.getInstance().removeModifiedOrganismFile(this.getClusterId(), (Collection)object2);
        }
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), ModifiedOrganismManager.getInstance());
        this.updateAfterModifiedOrganism();
    }

    private void updateAfterModifiedOrganism() throws Exception {
        this.updatePatternInfo();
        this.setViewOrderList();
        this.updatePatternGroup();
        this.updateOrganismSetGroup();
        GeneInfoFacade.registerNumDomain(this.getClusterList());
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.add(this.patternGroup);
        arrayList.add(OrganismSetGroup.getInstance());
        arrayList.add(this.organismCondition);
        ApplicationPropertyFacade.saveProperty(this.getClusterId(), arrayList);
        this.updateLocusTagClusterMap();
    }

    public DomClustAnalysis createDomClustProperty() {
        Project project = ProjectAccesser.getSelectedProject();
        DomClustAnalysis domClustAnalysis = new DomClustAnalysis();
        domClustAnalysis.setDomClustId(this.getClusterId());
        domClustAnalysis.setName(this.getDomClustName());
        domClustAnalysis.setProject(project);
        return domClustAnalysis;
    }

    public Set getClusterSetByFuncCat(FuncCat funcCat) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (int i = 0; i < this.m_clusterList.size(); ++i) {
            Cluster cluster = (Cluster)this.m_clusterList.get(i);
            if (funcCat.getFunctionCategoryNo().compareTo(cluster.getFunctionCategory()) != 0) continue;
            hashSet.add(cluster);
        }
        return hashSet;
    }
}

