/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterTblCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterTblCreater.class);
    private String domClustFilepath;
    private String domClustId;
    private String clusterViewId;
    private List ingroupList;
    private List outgroupList;
    private List clusterList;
    private String serverUrl;
    private boolean existHomCluster;
    private String domClustOption;
    private ApplicationPropertyConf conf;
    private ClusterTbl clusterTbl;

    public ClusterTblCreater(String string, String string2, String string3, List list, List list2, List list3, String string4, boolean bl, String string5, ApplicationPropertyConf applicationPropertyConf) {
        this.domClustFilepath = string;
        this.domClustId = string2;
        this.clusterViewId = string3;
        this.clusterList = list3;
        this.ingroupList = list;
        this.outgroupList = list2;
        this.serverUrl = string4;
        this.existHomCluster = bl;
        this.domClustOption = string5;
        this.conf = applicationPropertyConf;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            ClusterTbl clusterTbl = new ClusterTbl();
            clusterTbl.setFilepath(this.domClustFilepath);
            clusterTbl.setClusterId(this.domClustId);
            clusterTbl.setClusterViewId(this.clusterViewId);
            clusterTbl.setApplicationPropertyConf(this.conf);
            this.updateOrganismList(clusterTbl);
            clusterTbl.setServerUrl(this.serverUrl);
            clusterTbl.setDomClustOption(this.domClustOption);
            clusterTbl.setExistHomCluster(this.existHomCluster);
            clusterTbl.setClusterList(this.clusterList);
            clusterTbl.setMaxClusterId(ClusterUtil.getMaxClusterId(this.clusterList));
            int n = 2;
            GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createFuncCatGeneNameConditionGroup(n);
            clusterTbl.sortClusterList(geneInfoSortConditionGroup, new DummyProgressComponent());
            clusterTbl.setSortCondition(geneInfoSortConditionGroup);
            GeneInfoFacade.clear();
            GeneInfoFacade.registerNumDomain(this.clusterList);
            ClusterInfoFacade.clear();
            clusterTbl.updatePatternInfo();
            clusterTbl.updatePatternGroup();
            this.updateOrganismSetGroup();
            FilterFacade.clearCondition();
            FilterFacade.setClusterTbl(clusterTbl);
            ColorFacade.clearCondition();
            ColorFacade.setClusterTbl(clusterTbl);
            ApplicationPropertyFacade.updateDomClustAccessable(this.domClustId, ModifiedOrganismManager.getInstance());
            ModifiedOrganismManager.getInstance().replaceOriginalOrganism(clusterTbl);
            clusterTbl.mergeOrganism(ModifiedOrganismManager.getInstance().getMergeOrganismList());
            clusterTbl.splitOrganism(ModifiedOrganismManager.getInstance().getSplitOrganismList());
            this.updateCondition(clusterTbl);
            clusterTbl.initPPMLabelConditionGroup();
            GeneInfoFacade.clear();
            GeneInfoFacade.registerNumDomain(this.clusterList);
            clusterTbl.setViewOrderList();
            clusterTbl.setViewClusterList();
            clusterTbl.setLocusTagClusterMap(this.updateClusterMap());
            this.clusterTbl = clusterTbl;
        }
        catch (Exception exception) {
            String string = "Fail to create cluster model.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public static ClusterTbl createTmpClusterTbl(String string, String string2, String string3, List list, List list2, List list3, boolean bl) {
        ClusterTbl clusterTbl = new ClusterTbl();
        clusterTbl.setFilepath(string);
        clusterTbl.setClusterId(string2);
        clusterTbl.setClusterViewId(string3);
        ClusterTblCreater.updateOrganismList(clusterTbl, list, list2);
        clusterTbl.setExistHomCluster(bl);
        clusterTbl.setClusterList(list3);
        return clusterTbl;
    }

    private void updateOrganismList(ClusterTbl clusterTbl) {
        ClusterTblCreater.updateOrganismList(clusterTbl, this.ingroupList, this.outgroupList);
    }

    private static void updateOrganismList(ClusterTbl clusterTbl, List list, List list2) {
        List list3 = ClusterTblCreater.createOrganismList(list, list2);
        clusterTbl.updateOrganismList(list3);
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        ArrayList<Organism> arrayList2 = new ArrayList<Organism>();
        for (Organism organism : list3) {
            if (list.contains(organism.getOrganismCode())) {
                arrayList.add(organism);
                continue;
            }
            arrayList2.add(organism);
        }
        clusterTbl.setIngroupOrganismList(arrayList);
        clusterTbl.setOutgroupOrganismList(arrayList2);
    }

    private static List createOrganismList(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(OrganismUtil.convertDisplayOrganismList(OrganismUtil.getOrganismList(list, 2, false)));
        if (!CollectionUtil.isNull(list2)) {
            arrayList.addAll(OrganismUtil.convertDisplayOrganismList(OrganismUtil.getOrganismList(list2, 3, false)));
        }
        return arrayList;
    }

    private void updateOrganismSetGroup() {
        OrganismSetGroup.getInstance().clear();
        OrganismSetGroup.getInstance().setOrganismCodeC(this.getOrganismCodeList());
    }

    private List getOrganismCodeList() {
        ArrayList arrayList = new ArrayList(this.ingroupList);
        arrayList.addAll(this.outgroupList);
        return arrayList;
    }

    private void updateCondition(ClusterTbl clusterTbl) {
        List list = clusterTbl.getDomClustAccessableList();
        ApplicationPropertyFacade.updateDomClustAccessable(this.domClustId, list);
    }

    public static void saveCondition(ClusterTbl clusterTbl) throws IOException {
        if (clusterTbl == null) {
            return;
        }
        List list = clusterTbl.getDomClustAccessableList();
        ApplicationPropertyFacade.saveProperty(clusterTbl.getClusterId(), list);
    }

    private Map updateClusterMap() {
        return ClusterTblCreater.updateClusterMap(this.clusterList, this.getOrganismCodeList());
    }

    static Map updateClusterMap(List list, List list2) {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Cluster cluster : list) {
            for (String string : cluster.getSpSet()) {
                List list3 = cluster.getLocusTagList(string);
                if (list3 == null) continue;
                for (String string2 : list3) {
                    hashMap.put(GeneUtil.createOrganismLocusTagKey(string, string2), cluster);
                }
            }
        }
        return hashMap;
    }

    public ClusterTbl getClusterTbl() {
        return this.clusterTbl;
    }

    public void done() {
    }
}

