/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustExecuteValidator;
import cgdp.recog.domclust.DomClustExecuter;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.process.SingleTaskManager;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JOptionPane;

public class DomClustReExecuter {
    private Component parent;
    private MediatorImpl mediator;
    private String domClustFilepath;
    private String errorMessage;

    public DomClustReExecuter(Component component, MediatorImpl mediatorImpl, String string) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.domClustFilepath = string;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    private String getErrorMessage() {
        return this.errorMessage;
    }

    public static boolean isNoClusterTable(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        if (string.length() != 5) {
            return false;
        }
        String string2 = string.substring(1, 5);
        return string2.endsWith("0101");
    }

    public boolean execute() throws Exception {
        DomClustCondition domClustCondition = this.createDomClustCondition(this.domClustFilepath);
        domClustCondition.setConditionName("<<Last Parameters>>");
        if (!this.isExecuteDomClust(domClustCondition)) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessage());
            return false;
        }
        SingleTaskManager singleTaskManager = SingleTaskManager.getInstance();
        if (singleTaskManager.isExecuteTask()) {
            String string = "<HTML><BODY>" + this.getMainMessage() + "<BR>After the domclust running is finish, execute domclust again.</BODY></HTML>";
            MessageManager.showWarningMessage(this.parent, string);
            return false;
        }
        Object[] objectArray = new String[]{"Execute DomClust", "Cancel"};
        String string = objectArray[0];
        int n = JOptionPane.showOptionDialog(this.parent, "<HTML><BODY>" + this.getMainMessage() + "<BR>Execute DomClust?</BODY></HTML>", "Confirm", 0, 3, null, objectArray, string);
        if (n == objectArray.length - 1) {
            return false;
        }
        this.mediator.domClust(domClustCondition);
        return true;
    }

    private String getMainMessage() {
        return "Because the gene data is updated on RECOG Server, you need to execute DomClust again.";
    }

    public boolean isExecuteDomClust(DomClustCondition domClustCondition) throws Exception {
        if (!AccessServer.getInstance().isEnableAccess()) {
            return false;
        }
        domClustCondition.setNoexec(true);
        DomClustExecuter domClustExecuter = new DomClustExecuter(domClustCondition, (ProgressImpl)new DummyProgressComponent(), (Map)null);
        domClustExecuter.setIntervalWait(false);
        domClustExecuter.execute();
        domClustCondition.setNoexec(false);
        if (domClustExecuter.isError()) {
            String string = domClustExecuter.getErrorNo();
            if (DomClustExecuteValidator.isErrorNoSpec(string)) {
                String string2 = this.getErrorMessage() + "\nThe following genome is not registered in the server:\n " + domClustExecuter.getMessage();
                this.setErrorMessage(string2);
            }
            return false;
        }
        return true;
    }

    private DomClustCondition createDomClustCondition(String string) throws IOException {
        AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string);
        abstractDomClustImporter.setParameterOnly(true);
        abstractDomClustImporter.execute();
        String string2 = abstractDomClustImporter.getDomClustConditionString();
        if (StringTool.isNull(string2)) {
            DomClustCondition domClustCondition = new DomClustCondition();
            domClustCondition.setIngroupOrganismCodeSet(new HashSet(abstractDomClustImporter.getIngroupOrganismCodeList()));
            domClustCondition.setOutgroupOrganismCodeSet(new HashSet(abstractDomClustImporter.getOutgroupOrganismCodeList()));
            domClustCondition.setDomClustViewId(abstractDomClustImporter.getClusterViewId());
            return domClustCondition;
        }
        DomClustCondition domClustCondition = DomClustQuery.createDomClustCondition(string2);
        String string3 = new File(string).getName();
        string3 = FileUtil.removeExtension(string3);
        domClustCondition.setDomClustName(string3);
        domClustCondition.setDomClustViewId(abstractDomClustImporter.getClusterViewId());
        return domClustCondition;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:\\Documents and Settings\\093031_101071.IBIS\\RECOG.1\\project\\Demo\\cluster_20081119.cluster";
            DomClustReExecuter domClustReExecuter = new DomClustReExecuter(null, null, string);
            domClustReExecuter.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

