/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.active.FilterActivationHolder;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.AnyThresholdEachItem;
import cgdp.recog.filter.AnyThresholdItem;
import cgdp.recog.filter.CountFilterPopupItem;
import cgdp.recog.filter.CountFilterTreeNode;
import cgdp.recog.filter.FilterDeleteItem;
import cgdp.recog.filter.FilterEnableItem;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.filter.FilterMenuFactory;
import cgdp.recog.filter.FilterMultiEnableItem;
import cgdp.recog.filter.FilterSetConditionDeleteItem;
import cgdp.recog.filter.SearchFilterTreeNode;
import cgdp.recog.filter.SetFilterTreeNode;
import cgdp.recog.filter.SpCodeTreeNode;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.filter.TaxFilterConditionGroup;
import cgdp.recog.filter.TaxFilterConditionTreeNode;
import cgdp.recog.funccat.FuncCatFilterDeleteItem;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.ptree.bean.filter.FilterNameEditItem;
import cgdp.recog.search.KeywordSearchItem;
import cgdp.recog.search.KeywordSearchResultItem;
import cgdp.recog.search.SearchResultGroup;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupFilterTreeNode;
import cgdp.recog.set.ElementSetGroupTreeNode;
import cgdp.recog.set.SetCondElementDeleteItem;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetFilterMenu;
import cgdp.recog.set.SetType;
import cgdp.recog.set.color.SetFilerColorItem;
import cgdp.recog.taxonomy.map.TaxMapFilterDeleteItem;
import cgdp.recog.tree.AbstractTreeController;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterTreeController
extends AbstractTreeController {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public FilterTreeController(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        this.createTaxonomyFilterTree(defaultMutableTreeNode, FilterFacade.getInstance().getTaxFilterConditionGroup());
        this.createCountFilterTree(defaultMutableTreeNode);
        this.createSearchFilterTree(defaultMutableTreeNode);
        this.createGeneSetFilterTree(defaultMutableTreeNode, "Gene Set Filter", 14);
        this.createGeneSetFilterTree(defaultMutableTreeNode, "Cluster Set Filter", 15);
        this.createFuncCatFilterTree(defaultMutableTreeNode);
        this.createTaxMapFilterTree(defaultMutableTreeNode);
    }

    protected void createTaxonomyFilterTree(DefaultMutableTreeNode defaultMutableTreeNode, TaxFilterConditionGroup taxFilterConditionGroup) {
        TaxFilterCondition taxFilterCondition;
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Taxonomy Filter", 11);
        defaultMutableTreeNode.add(controlTitleNode);
        TaxFilterCondition taxFilterCondition2 = taxFilterConditionGroup.getAllCondition();
        if (taxFilterCondition2 != null) {
            controlTitleNode.add(FilterTreeController.createFilterTreeStructure(taxFilterCondition2, this.clusterTbl));
        }
        if ((taxFilterCondition = taxFilterConditionGroup.getNoneCondition()) != null) {
            controlTitleNode.add(FilterTreeController.createFilterTreeStructure(taxFilterCondition, this.clusterTbl));
        }
        for (TaxFilterCondition taxFilterCondition3 : taxFilterConditionGroup.getAnyConditionList()) {
            controlTitleNode.add(FilterTreeController.createFilterTreeStructure(taxFilterCondition3, this.clusterTbl));
        }
    }

    private static TaxFilterConditionTreeNode createFilterTreeStructure(TaxFilterCondition taxFilterCondition, ClusterTbl clusterTbl) {
        ArrayList arrayList = new ArrayList(taxFilterCondition.getSpSet());
        Collections.sort(arrayList);
        TaxFilterConditionTreeNode taxFilterConditionTreeNode = new TaxFilterConditionTreeNode(taxFilterCondition, clusterTbl);
        for (String string : arrayList) {
            String string2 = taxFilterCondition.getSpName(string);
            SpCodeTreeNode spCodeTreeNode = new SpCodeTreeNode(taxFilterCondition, string, string2);
            taxFilterConditionTreeNode.add(spCodeTreeNode);
        }
        return taxFilterConditionTreeNode;
    }

    private static boolean isAllAnyCondition(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
            if (!(mutableTreeNode instanceof TaxFilterConditionTreeNode)) {
                return false;
            }
            TaxFilterConditionTreeNode taxFilterConditionTreeNode = (TaxFilterConditionTreeNode)mutableTreeNode;
            if (taxFilterConditionTreeNode.getTaxFilterCondition().isAny()) continue;
            return false;
        }
        return true;
    }

    private static List getAnyConditionList(TreePath[] treePathArray) {
        ArrayList<TaxFilterCondition> arrayList = new ArrayList<TaxFilterCondition>();
        for (int i = 0; i < treePathArray.length; ++i) {
            TaxFilterConditionTreeNode taxFilterConditionTreeNode;
            TaxFilterCondition taxFilterCondition;
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(mutableTreeNode instanceof TaxFilterConditionTreeNode) || !(taxFilterCondition = (taxFilterConditionTreeNode = (TaxFilterConditionTreeNode)mutableTreeNode).getTaxFilterCondition()).isAny()) continue;
            arrayList.add(taxFilterCondition);
        }
        return arrayList;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void updateSelection(JTree jTree, int n, long l) {
        TaxFilterCondition taxFilterCondition = FilterFacade.getInstance().getTaxFilterCondition(n, l);
        if (this.clusterTbl == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxFilterConditionTreeNode taxFilterConditionTreeNode;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof TaxFilterConditionTreeNode) || !(taxFilterConditionTreeNode = (TaxFilterConditionTreeNode)enumeration.nextElement()).equalsFilterId(taxFilterCondition.getId())) continue;
            TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(taxFilterConditionTreeNode));
            jTree.setSelectionPath(treePath);
        }
    }

    public void updateSelection(JTree jTree, int n, long l, Collection collection) {
        TaxFilterCondition taxFilterCondition = FilterFacade.getInstance().getTaxFilterCondition(n, l);
        if (taxFilterCondition == null) {
            return;
        }
        this.setSelectSpCodeTreeNode(jTree, taxFilterCondition.getId(), collection);
    }

    private void setSelectSpCodeTreeNode(JTree jTree, long l, Collection collection) {
        if (this.clusterTbl == null) {
            return;
        }
        jTree.clearSelection();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxFilterConditionTreeNode taxFilterConditionTreeNode = (TaxFilterConditionTreeNode)enumeration.nextElement();
            if (!taxFilterConditionTreeNode.equalsFilterId(l)) continue;
            Enumeration<TreeNode> enumeration2 = taxFilterConditionTreeNode.children();
            while (enumeration2.hasMoreElements()) {
                SpCodeTreeNode spCodeTreeNode = (SpCodeTreeNode)enumeration2.nextElement();
                if (!collection.contains(spCodeTreeNode.getSp())) continue;
                TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(spCodeTreeNode));
                jTree.addSelectionPath(treePath);
            }
        }
    }

    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowFilterMenu(treePathArray)) {
            this.createFilterMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowTaxonomyFilterMenu(treePathArray)) {
            this.createTaxonomyMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowCountFilterMenu(treePathArray)) {
            this.createCountMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowSearchFilterMenu(treePathArray)) {
            this.createSearchMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowGeneSetMenu(treePathArray) || this.isShowClusterSetMenu(treePathArray)) {
            this.createSetFilterMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowGeneSetTitleMenu(treePathArray) || this.isShowClusterSetTitleMenu(treePathArray)) {
            this.createSetFilterTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowGeneSetConditionMenu(treePathArray) || this.isShowClusterSetConditionMenu(treePathArray)) {
            this.createSetFilterConditionMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowTaxMapFilterTitleMenu(treePathArray)) {
            this.createTaxMapFilterTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowTaxMapFilterMenu(treePathArray)) {
            this.createTaxMapFilterTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowFuncCatFilterTitleMenu(treePathArray)) {
            this.createFuncCatFilterTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowFuncCatFilterMenu(treePathArray)) {
            this.createFuncCatFilterTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        return jPopupMenu;
    }

    private JMenu createAnyThresholdMenu(ActionListener actionListener, TreePath[] treePathArray) {
        JMenu jMenu = new JMenu("Any Threshold");
        List list = FilterTreeController.getAnyConditionList(treePathArray);
        AnyThresholdItem anyThresholdItem = new AnyThresholdItem(actionListener, this.mediator, 1.0, true, true, list, "One or more");
        AnyThresholdItem anyThresholdItem2 = new AnyThresholdItem(actionListener, this.mediator, 0.2, false, true, list, "20% or more");
        AnyThresholdItem anyThresholdItem3 = new AnyThresholdItem(actionListener, this.mediator, 0.4, false, true, list, "40% or more");
        AnyThresholdItem anyThresholdItem4 = new AnyThresholdItem(actionListener, this.mediator, 0.6, false, true, list, "60% or more");
        AnyThresholdItem anyThresholdItem5 = new AnyThresholdItem(actionListener, this.mediator, 0.8, false, true, list, "80% or more");
        AnyThresholdItem anyThresholdItem6 = new AnyThresholdItem(actionListener, this.mediator, 0.2, false, false, list, "20% or less");
        AnyThresholdItem anyThresholdItem7 = new AnyThresholdItem(actionListener, this.mediator, 0.4, false, false, list, "40% or less");
        AnyThresholdItem anyThresholdItem8 = new AnyThresholdItem(actionListener, this.mediator, 0.6, false, false, list, "60% or less");
        AnyThresholdItem anyThresholdItem9 = new AnyThresholdItem(actionListener, this.mediator, 0.8, false, false, list, "80% or less");
        if (FilterTreeController.isAllAnyCondition(treePathArray)) {
            AnyThresholdEachItem anyThresholdEachItem = new AnyThresholdEachItem(actionListener, this.mediator, list, "Edit");
            jMenu.add(anyThresholdEachItem);
            jMenu.addSeparator();
        }
        jMenu.add(new JLabel("For all Any Conditions"));
        jMenu.add(anyThresholdItem);
        jMenu.add(anyThresholdItem2);
        jMenu.add(anyThresholdItem3);
        jMenu.add(anyThresholdItem4);
        jMenu.add(anyThresholdItem5);
        jMenu.add(anyThresholdItem6);
        jMenu.add(anyThresholdItem7);
        jMenu.add(anyThresholdItem8);
        jMenu.add(anyThresholdItem9);
        return jMenu;
    }

    private Map getFilterIDMap(TreePath[] treePathArray) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < treePathArray.length; ++i) {
            TaxFilterCondition taxFilterCondition;
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[i].getLastPathComponent();
            if (mutableTreeNode instanceof TaxFilterConditionTreeNode) {
                defaultMutableTreeNode = (TaxFilterConditionTreeNode)mutableTreeNode;
                taxFilterCondition = ((TaxFilterConditionTreeNode)defaultMutableTreeNode).getTaxFilterCondition();
                hashMap.put(new Long(taxFilterCondition.getId()), new HashSet(taxFilterCondition.getSpSet()));
                continue;
            }
            if (!(mutableTreeNode instanceof SpCodeTreeNode)) continue;
            defaultMutableTreeNode = (SpCodeTreeNode)mutableTreeNode;
            taxFilterCondition = ((SpCodeTreeNode)defaultMutableTreeNode).getFilterCondition();
            Long l = new Long(taxFilterCondition.getId());
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(l, hashSet);
            }
            hashSet.add(((SpCodeTreeNode)defaultMutableTreeNode).getSp());
        }
        return hashMap;
    }

    private void createCountFilterTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Gene/Organism Count Filter", 12);
        defaultMutableTreeNode.add(controlTitleNode);
        FilterFacade filterFacade = FilterFacade.getInstance();
        CountFilterTreeNode countFilterTreeNode = new CountFilterTreeNode(filterFacade.getOrganismCountFilterCondition());
        controlTitleNode.add(countFilterTreeNode);
        CountFilterTreeNode countFilterTreeNode2 = new CountFilterTreeNode(filterFacade.getGeneCountFilterCondition());
        controlTitleNode.add(countFilterTreeNode2);
    }

    private void createSearchFilterTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!this.clusterTbl.isExistSearchResult()) {
            return;
        }
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Keyword Search", 13);
        defaultMutableTreeNode.add(controlTitleNode);
        SearchFilterTreeNode searchFilterTreeNode = new SearchFilterTreeNode(this.clusterTbl.getSearchCondition(), this.clusterTbl.getSearchResultGroup());
        controlTitleNode.add(searchFilterTreeNode);
    }

    private void createGeneSetFilterTree(DefaultMutableTreeNode defaultMutableTreeNode, String string, int n) {
        FilterFacade filterFacade = FilterFacade.getInstance();
        if (ControlTitleType.isFilterGeneSet(n) && !filterFacade.isExistGeneSetCondition()) {
            return;
        }
        if (ControlTitleType.isFilterClusterSet(n) && !filterFacade.isExistClusterSetCondition()) {
            return;
        }
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode(string, n);
        defaultMutableTreeNode.add(controlTitleNode);
        int n2 = SetType.getSetTypeFromControlTitleType(n);
        List list = FilterFacade.getInstance().getSetConditionList(n2);
        for (SetCondition setCondition : list) {
            SetFilterTreeNode setFilterTreeNode = new SetFilterTreeNode(filterFacade.getFilterSetConditionGroup(), setCondition);
            controlTitleNode.add(setFilterTreeNode);
            for (ElementSetGroup elementSetGroup : setCondition.getElementSetGroupList()) {
                ElementSetGroupFilterTreeNode elementSetGroupFilterTreeNode = new ElementSetGroupFilterTreeNode(elementSetGroup);
                setFilterTreeNode.add(elementSetGroupFilterTreeNode);
            }
        }
    }

    private void createTaxMapFilterTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        FilterFacade filterFacade = FilterFacade.getInstance();
        if (!filterFacade.isExistTaxMapSetCondition()) {
            return;
        }
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Taxonomy Mapping Filter", 16);
        defaultMutableTreeNode.add(controlTitleNode);
        SetCondition setCondition = FilterFacade.getInstance().getTaxMapSetCondition();
        SetFilterTreeNode setFilterTreeNode = new SetFilterTreeNode(filterFacade.getFilterSetConditionGroup(), setCondition);
        controlTitleNode.add(setFilterTreeNode);
    }

    private void createFuncCatFilterTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        FilterFacade filterFacade = FilterFacade.getInstance();
        if (!filterFacade.isExistFuncCatSetCondition()) {
            return;
        }
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Function Category Filter", 17);
        defaultMutableTreeNode.add(controlTitleNode);
        SetCondition setCondition = FilterFacade.getInstance().getFuncCatSetCondition();
        SetFilterTreeNode setFilterTreeNode = new SetFilterTreeNode(filterFacade.getFilterSetConditionGroup(), setCondition);
        controlTitleNode.add(setFilterTreeNode);
    }

    private boolean isShowFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilter(controlTitleNode.getControlTitleType());
    }

    private boolean isShowTaxonomyFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterTaxonomy(controlTitleNode.getControlTitleType());
    }

    private void createFilterMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>();
        arrayList.addAll(FilterFacade.getInstance().getConditionList());
        arrayList.add(this.clusterTbl.getSearchResultGroup());
        this.createTaxonomyFilterMenu(actionListener, jPopupMenu);
        jPopupMenu.add(new CountFilterPopupItem(actionListener, this.mediator));
        jPopupMenu.add(new KeywordSearchItem(actionListener, this.mediator, "Keyword Search Filter..."));
        jPopupMenu.add(new SetFilterMenu(actionListener, this.mediator, this.clusterTbl, "Gene Set Filter...", 1));
        jPopupMenu.add(new SetFilterMenu(actionListener, this.mediator, this.clusterTbl, "Cluster Set Filter...", 2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, arrayList, 1));
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, arrayList, 2));
    }

    private void createTaxonomyMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.clusterTbl == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
        if (mutableTreeNode instanceof ControlTitleNode && ControlTitleType.isFilterTaxonomy(((ControlTitleNode)mutableTreeNode).getControlTitleType())) {
            object4 = FilterFacade.getInstance().getTaxFilterConditionList();
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, (List)object4, 1));
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, (List)object4, 2));
            object3 = new HashMap();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (TaxFilterCondition)object2.next();
                object3.put(new Long(((TaxFilterCondition)object).getId()), ((TaxFilterCondition)object).getSpSet());
            }
            object2 = new FilterDeleteItem(actionListener, this.mediator, (Map)object3);
            jPopupMenu.add((JMenuItem)object2);
        }
        if (mutableTreeNode instanceof TaxFilterConditionTreeNode) {
            object4 = (TaxFilterConditionTreeNode)mutableTreeNode;
            object3 = ((TaxFilterConditionTreeNode)object4).getTaxFilterCondition();
            if (((TaxFilterConditionTreeNode)object4).getTaxFilterCondition().isAny()) {
                object2 = new FilterNameEditItem(actionListener, this.mediator, (TaxFilterCondition)object3, "Rename");
                jPopupMenu.add((JMenuItem)object2);
                jPopupMenu.add(this.createAnyThresholdMenu(actionListener, treePathArray));
                jPopupMenu.addSeparator();
            }
            object2 = new FilterEnableItem(actionListener, this.mediator, (FilterActivation)object3);
            jPopupMenu.add((JMenuItem)object2);
            object = this.getFilterIDMap(treePathArray);
            FilterDeleteItem filterDeleteItem = new FilterDeleteItem(actionListener, this.mediator, (Map)object);
            jPopupMenu.add(filterDeleteItem);
        }
    }

    private boolean isShowCountFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterCount(controlTitleNode.getControlTitleType());
    }

    private void createCountMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
        if (mutableTreeNode instanceof ControlTitleNode && ControlTitleType.isFilterCount(((ControlTitleNode)mutableTreeNode).getControlTitleType())) {
            List list = FilterFacade.getInstance().getCountFilterConditionList();
            jPopupMenu.add(new CountFilterPopupItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 1));
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 2));
        } else if (mutableTreeNode instanceof CountFilterTreeNode) {
            jPopupMenu.add(new CountFilterPopupItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            CountFilterTreeNode countFilterTreeNode = (CountFilterTreeNode)mutableTreeNode;
            FilterActivation filterActivation = countFilterTreeNode.getFilterActivation();
            jPopupMenu.add(new FilterEnableItem(actionListener, this.mediator, filterActivation));
        }
    }

    private boolean isShowSearchFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterSearch(controlTitleNode.getControlTitleType());
    }

    private void createSearchMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
        if (mutableTreeNode instanceof ControlTitleNode && ControlTitleType.isFilterSearch(((ControlTitleNode)mutableTreeNode).getControlTitleType())) {
            ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>();
            arrayList.add(this.clusterTbl.getSearchResultGroup());
            jPopupMenu.add(new KeywordSearchItem(actionListener, this.mediator, "Keyword Search Filter..."));
            jPopupMenu.add(new KeywordSearchResultItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, arrayList, 1));
            jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, arrayList, 2));
        } else if (mutableTreeNode instanceof SearchFilterTreeNode) {
            jPopupMenu.add(new KeywordSearchItem(actionListener, this.mediator));
            jPopupMenu.add(new KeywordSearchResultItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new FilterEnableItem(actionListener, this.mediator, this.clusterTbl.getSearchResultGroup()));
        }
    }

    private boolean isShowGeneSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterGeneSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowGeneSetTitleMenu(TreePath[] treePathArray) {
        ControlTitleNode controlTitleNode;
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        if (!(defaultMutableTreeNode instanceof SetFilterTreeNode)) {
            return false;
        }
        SetFilterTreeNode setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode;
        if (!ControlTitleType.isFilterGeneSet(setFilterTreeNode.getFilterControlTitleType())) {
            return false;
        }
        return !(treePath.getPathComponent(2) instanceof ControlTitleNode) || (controlTitleNode = (ControlTitleNode)treePath.getPathComponent(2)).getControlTitleType() != 16;
    }

    private boolean isShowGeneSetConditionMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(4);
        if (!(defaultMutableTreeNode instanceof ElementSetGroupFilterTreeNode)) {
            return false;
        }
        ElementSetGroupFilterTreeNode elementSetGroupFilterTreeNode = (ElementSetGroupFilterTreeNode)defaultMutableTreeNode;
        return elementSetGroupFilterTreeNode.isGeneSet();
    }

    private boolean isShowClusterSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterClusterSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowClusterSetTitleMenu(TreePath[] treePathArray) {
        ControlTitleNode controlTitleNode;
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        if (!(defaultMutableTreeNode instanceof SetFilterTreeNode)) {
            return false;
        }
        SetFilterTreeNode setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode;
        if (!ControlTitleType.isFilterClusterSet(setFilterTreeNode.getFilterControlTitleType())) {
            return false;
        }
        return !(treePath.getPathComponent(2) instanceof ControlTitleNode) || (controlTitleNode = (ControlTitleNode)treePath.getPathComponent(2)).getControlTitleType() != 17;
    }

    private boolean isShowClusterSetConditionMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(4);
        if (!(defaultMutableTreeNode instanceof ElementSetGroupFilterTreeNode)) {
            return false;
        }
        ElementSetGroupFilterTreeNode elementSetGroupFilterTreeNode = (ElementSetGroupFilterTreeNode)defaultMutableTreeNode;
        return elementSetGroupFilterTreeNode.isClusterSet();
    }

    private void createSetFilterMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)treePathArray[0].getLastPathComponent();
        List list = this.getAccessableList(controlTitleNode);
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 1));
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 2));
    }

    private void createSetFilterTitleMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        SetFilterTreeNode setFilterTreeNode = (SetFilterTreeNode)treePathArray[0].getLastPathComponent();
        SetCondition setCondition = setFilterTreeNode.getSetCondition();
        List list = setCondition.getElementSetGroupList();
        jPopupMenu.add(new SetFilerColorItem(actionListener, this.mediator, setCondition));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 1));
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new FilterSetConditionDeleteItem(actionListener, this.mediator, setCondition));
    }

    private void createSetFilterConditionMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        ElementSetGroupFilterTreeNode elementSetGroupFilterTreeNode = (ElementSetGroupFilterTreeNode)treePathArray[0].getLastPathComponent();
        SetFilterTreeNode setFilterTreeNode = (SetFilterTreeNode)elementSetGroupFilterTreeNode.getParent();
        SetCondition setCondition = setFilterTreeNode.getSetCondition();
        List list = this.getElementSetGroupList(setCondition, treePathArray);
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 1));
        jPopupMenu.add(new FilterMultiEnableItem(actionListener, this.mediator, list, 2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new SetCondElementDeleteItem(actionListener, this.mediator, setCondition, list));
    }

    private List getElementSetGroupList(SetCondition setCondition, TreePath[] treePathArray) {
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        for (int i = 0; i < treePathArray.length; ++i) {
            ElementSetGroupFilterTreeNode elementSetGroupFilterTreeNode;
            SetFilterTreeNode setFilterTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ElementSetGroupFilterTreeNode) || !(setFilterTreeNode = (SetFilterTreeNode)(elementSetGroupFilterTreeNode = (ElementSetGroupFilterTreeNode)defaultMutableTreeNode).getParent()).getSetCondition().equals(setCondition)) continue;
            ElementSetGroup elementSetGroup = elementSetGroupFilterTreeNode.getElementSetGroup();
            arrayList.add(elementSetGroup);
        }
        return arrayList;
    }

    private void createTaxonomyFilterMenu(ActionListener actionListener, JPopupMenu jPopupMenu) {
        if (!this.clusterTbl.isSelectedOrganismCode()) {
            JMenu jMenu = new JMenu("Taxonomy Filter");
            jMenu.setEnabled(false);
            jPopupMenu.add(jMenu);
            return;
        }
        Map map = OrganismUtil.createOrganismNameMap(this.clusterTbl.getSelectedOrganismCodeSet());
        String string = (String)map.get(this.clusterTbl.getSelectedOrganismCode());
        FilterMenuFactory.createTaxonomyMenu(actionListener, this.mediator, this.clusterTbl, string, this.clusterTbl.getSelectedOrganismCodeSet(), map, jPopupMenu);
    }

    private boolean isShowTaxMapFilterTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterTaxMap(controlTitleNode.getControlTitleType());
    }

    private boolean isShowTaxMapFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        if (!ControlTitleType.isFilterTaxMap(controlTitleNode.getControlTitleType())) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        return defaultMutableTreeNode2 instanceof SetFilterTreeNode;
    }

    private void createTaxMapFilterTitleMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        SetFilterTreeNode setFilterTreeNode = null;
        if (defaultMutableTreeNode instanceof ControlTitleNode) {
            setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode.children().nextElement();
        } else if (defaultMutableTreeNode instanceof SetFilterTreeNode) {
            setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode;
        } else {
            return;
        }
        SetCondition setCondition = setFilterTreeNode.getSetCondition();
        jPopupMenu.add(new FilterEnableItem(actionListener, this.mediator, setCondition));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new TaxMapFilterDeleteItem(actionListener, this.mediator, setCondition));
    }

    private boolean isShowFuncCatFilterTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isFilterFuncCat(controlTitleNode.getControlTitleType());
    }

    private boolean isShowFuncCatFilterMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        if (!ControlTitleType.isFilterFuncCat(controlTitleNode.getControlTitleType())) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        return defaultMutableTreeNode2 instanceof SetFilterTreeNode;
    }

    private void createFuncCatFilterTitleMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        SetFilterTreeNode setFilterTreeNode = null;
        if (defaultMutableTreeNode instanceof ControlTitleNode) {
            setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode.children().nextElement();
        } else if (defaultMutableTreeNode instanceof SetFilterTreeNode) {
            setFilterTreeNode = (SetFilterTreeNode)defaultMutableTreeNode;
        } else {
            return;
        }
        SetCondition setCondition = setFilterTreeNode.getSetCondition();
        jPopupMenu.add(new FilterEnableItem(actionListener, this.mediator, setCondition));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new FuncCatFilterDeleteItem(actionListener, this.mediator, setCondition));
    }

    private List getAccessableList(ControlTitleNode controlTitleNode) {
        ArrayList<ColorActivation> arrayList = new ArrayList<ColorActivation>();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode instanceof SetFilterTreeNode) {
                object = (SetFilterTreeNode)defaultMutableTreeNode;
                arrayList.add(((SetFilterTreeNode)object).getSetCondition());
                continue;
            }
            if (defaultMutableTreeNode instanceof ControlTitleNode) {
                object = this.getAccessableList((ControlTitleNode)defaultMutableTreeNode);
                arrayList.addAll((Collection<ColorActivation>)object);
                continue;
            }
            if (!(defaultMutableTreeNode instanceof ElementSetGroupFilterTreeNode)) continue;
            object = (ElementSetGroupFilterTreeNode)defaultMutableTreeNode;
            arrayList.add(((ElementSetGroupTreeNode)object).getElementSetGroup());
        }
        return arrayList;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode instanceof FilterActivationHolder && defaultMutableTreeNode.isLeaf()) {
            FilterActivationHolder filterActivationHolder = (FilterActivationHolder)((Object)defaultMutableTreeNode);
            this.mediator.activeFilter(filterActivationHolder.getFilterActivation());
        }
    }
}

