/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.active.FilterActivation;
import cgdp.recog.filter.AbstractFilterNode;
import cgdp.recog.search.SearchCondition;
import cgdp.recog.search.SearchResultGroup;

public class SearchFilterTreeNode
extends AbstractFilterNode {
    private SearchCondition searchCondition;

    public SearchFilterTreeNode(SearchCondition searchCondition, SearchResultGroup searchResultGroup) {
        super(searchResultGroup);
        this.searchCondition = searchCondition;
        this.setUserObject(this.getLabelText());
    }

    private String getLabelText() {
        return "Keyword Search[" + this.searchCondition.getLabel() + "]";
    }

    private SearchCondition getSearchCondition() {
        return this.searchCondition;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SearchFilterTreeNode)) {
            return false;
        }
        SearchFilterTreeNode searchFilterTreeNode = (SearchFilterTreeNode)object;
        return this.getFilterActivation().equals(searchFilterTreeNode.getFilterActivation()) && this.getSearchCondition().equals(searchFilterTreeNode.getSearchCondition());
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getFilterActivation().hashCode();
        n = n * 31 + this.getSearchCondition().hashCode();
        return n;
    }

    private class SearchResultWrapper
    implements FilterActivation {
        private SearchResultGroup searchResultGroup;

        SearchResultWrapper(SearchResultGroup searchResultGroup) {
            this.searchResultGroup = searchResultGroup;
        }

        public void flipFilterActive() {
            this.searchResultGroup.flipFilterActive();
        }

        public boolean isFilterActive() {
            return this.searchResultGroup.isFilterActive();
        }

        public void setFilterActive(boolean bl) {
            this.searchResultGroup.setFilterActive(bl);
        }

        public boolean isSyncEnable() {
            return false;
        }
    }
}

