/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.funccat.FuncCatTable;
import cgdp.recog.gmap.GenomeMapCondition;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class GenomeMapOptionDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(GenomeMapOptionDialog.class);
    private static final String TITLE = "Genome Map Options";
    private MediatorImpl mediator;
    private GenomeMapCondition genomeMapCondition;
    private JRadioButton functionCategoryButton;
    private JRadioButton innerOuterButton;
    private JRadioButton ppmButton;
    private FuncCatTable funcCatTable;
    private ColorLegendPanel innerColorLegendPanel;
    private ColorLegendPanel outerColorLegendPanel;

    GenomeMapOptionDialog(Frame frame, MediatorImpl mediatorImpl, GenomeMapCondition genomeMapCondition) {
        super(frame);
        this.mediator = mediatorImpl;
        this.genomeMapCondition = genomeMapCondition;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JPanel jPanel = this.createColorPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateValue() {
        if (this.genomeMapCondition.isFunctionCategory()) {
            this.functionCategoryButton.setSelected(true);
        } else if (this.genomeMapCondition.isIngroupOutgroup()) {
            this.innerOuterButton.setSelected(true);
        } else {
            this.ppmButton.setSelected(true);
        }
    }

    private JPanel createColorPanel() {
        this.functionCategoryButton = new JRadioButton("Function Category");
        this.innerOuterButton = new JRadioButton("Positive/Negative");
        this.ppmButton = new JRadioButton("Use the color of the control tree");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.functionCategoryButton);
        buttonGroup.add(this.innerOuterButton);
        buttonGroup.add(this.ppmButton);
        this.funcCatTable = new FuncCatTable(this.mediator);
        JLabel jLabel = new JLabel("Positive");
        this.outerColorLegendPanel = new ColorLegendPanel(this.genomeMapCondition.getPositiveColor());
        JLabel jLabel2 = new JLabel("Negative");
        this.innerColorLegendPanel = new ColorLegendPanel(this.genomeMapCondition.getNegativeColor());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        jPanel.add((Component)this.outerColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        jPanel.add((Component)this.innerColorLegendPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.functionCategoryButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.funcCatTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.innerOuterButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.ppmButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        return jPanel2;
    }

    private Color getPositiveColor() {
        return this.outerColorLegendPanel.getBackground();
    }

    private Color getNegativeColor() {
        return this.innerColorLegendPanel.getBackground();
    }

    private int getColorType() {
        int n = this.functionCategoryButton.isSelected() ? 1 : (this.innerOuterButton.isSelected() ? 2 : 3);
        return n;
    }

    protected boolean apply() {
        this.setVisible(false);
        try {
            this.genomeMapCondition.setColorType(this.getColorType());
            this.genomeMapCondition.setPositiveColor(this.getPositiveColor());
            this.genomeMapCondition.setNegativeColor(this.getNegativeColor());
            ApplicationPropertyFacade.saveProperty(this.genomeMapCondition.getDomClustId(), this.genomeMapCondition);
        }
        catch (IOException iOException) {
            String string = "Fail to save genome map option to application conf file.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage((Component)this, string);
        }
        return true;
    }
}

