/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.gmap.GenomeMapFrame;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.util.JLicenserTool;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class GenomeMapZoomOutTool
extends JButton
implements CommandImpl,
MouseListener {
    private MediatorImpl mediator;
    private GenomeMapFrame genomeMapFrame;

    GenomeMapZoomOutTool(ActionListener actionListener, MediatorImpl mediatorImpl, GenomeMapFrame genomeMapFrame) {
        this.setToolTipText("Zoom Out");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setFont(new Font("Monospaced", 0, 10));
        try {
            this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/zoomOut.png")));
        }
        catch (Exception exception) {
            this.setText("0");
        }
        this.addActionListener(actionListener);
        this.addMouseListener(this);
        this.mediator = mediatorImpl;
        this.genomeMapFrame = genomeMapFrame;
    }

    private void showPopup(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"X2", "X4", "X8"};
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionTbl.getInstance().getOptionValues().setZoomOut2(actionEvent.getActionCommand());
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this, n, n2);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = OptionTbl.getInstance().getOptionValues().getZoomOut2();
        int n = this.getSize().width - fontMetrics.stringWidth(string) - 2;
        int n2 = this.getSize().height - 2;
        graphics.setColor(Color.black);
        graphics.drawString(string, n, n2);
    }

    public void execute() {
        this.genomeMapFrame.zoomOut();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

