/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.ProfilePanel;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class HClustDialog
extends AbstractApplyDialog {
    private static HClustDialog HCLUST_DIALOG;
    private static final int PROBABILITY_CUTOFF_WIDTH = 80;
    private static final Double[] PROBABILITY_CUTOFF_LIST;
    private MediatorImpl mediator;
    private boolean outgourpFlag;
    private JPanel optionPanel;
    private JRadioButton localRadioButton;
    private JRadioButton serverRadioButton;
    private JRadioButton clusterRadioButton;
    private JRadioButton subClusterRadioButton;
    private SliderTextPanel organismTextPanel;
    private SliderTextPanel cutoffSliderTextPanel;
    private SliderTextPanel missDistRatioSliderTextPanel;
    private JComboBox probabilityCutoffComboBox;
    private ProfilePanel profilePanel;
    private JCheckBox targetFilterClusterListCheckBox;
    private JCheckBox userCacheCheckBox;
    private JButton optionButton;

    private HClustDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        HCLUST_DIALOG = new HClustDialog(frame, mediatorImpl);
    }

    public static HClustDialog getInstance() {
        return HCLUST_DIALOG;
    }

    private void createComponents() {
        this.setTitle("Confirm");
        this.setModal(true);
        this.setApplyButtonName("Run");
        this.setCloseButtonName("Cancel");
        JLabel jLabel = new JLabel("Phylogenetic Pattern Clustering (PhyloPatClust)?");
        jLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.serverRadioButton = new JRadioButton("Server");
        this.serverRadioButton.addActionListener(this);
        this.localRadioButton = new JRadioButton("Local");
        this.localRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.serverRadioButton);
        buttonGroup.add(this.localRadioButton);
        JLabel jLabel2 = new JLabel("Execute:");
        JPanel jPanel = this.createExecEnvPanel();
        JLabel jLabel3 = new JLabel("Target:");
        JPanel jPanel2 = this.createTargetPanel();
        this.targetFilterClusterListCheckBox = new JCheckBox("Use displayed clusters only");
        this.profilePanel = new ProfilePanel(this);
        this.optionPanel = this.createOptionPanel();
        this.optionPanel.setBorder(BorderFactory.createTitledBorder("PhyloPatClust Parmeters"));
        this.optionPanel.setVisible(false);
        this.optionButton = new JButton(">> Parameters");
        this.optionButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this.optionButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel3.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 20, 10, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 10, 20), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 20, 15, 10), 20, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 15, 20), 0, 0));
        this.getContentPane().add((Component)this.profilePanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 15, 20), 0, 0));
        this.getContentPane().add((Component)this.targetFilterClusterListCheckBox, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 10), 0, 0));
        this.getContentPane().add((Component)jPanel3, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)this.optionPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createExecEnvPanel() {
        this.serverRadioButton = new JRadioButton("Server");
        this.serverRadioButton.addActionListener(this);
        this.localRadioButton = new JRadioButton("Local");
        this.localRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.serverRadioButton);
        buttonGroup.add(this.localRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.localRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.serverRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createTargetPanel() {
        this.clusterRadioButton = new JRadioButton("Cluster");
        this.subClusterRadioButton = new JRadioButton("Sub Cluster");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.clusterRadioButton);
        buttonGroup.add(this.subClusterRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.subClusterRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.clusterRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createOptionPanel() {
        JLabel jLabel = new JLabel("Minimum number of organisms");
        this.organismTextPanel = new SliderTextPanel();
        this.organismTextPanel.setMinimum(1);
        this.organismTextPanel.setMaximum(10);
        this.organismTextPanel.setTextColumns(3);
        this.organismTextPanel.setPaintTicks(true);
        this.organismTextPanel.setPaintLabels(true);
        JLabel jLabel2 = new JLabel("Cut off");
        this.cutoffSliderTextPanel = SliderTextPanel.createOneSliderTextPanel();
        JLabel jLabel3 = new JLabel("Miss Dist Ratio(%)");
        this.missDistRatioSliderTextPanel = SliderTextPanel.createRatioSliderTextPanel();
        JLabel jLabel4 = new JLabel("Probability Cutoff(%)");
        this.probabilityCutoffComboBox = new JComboBox<Double>(PROBABILITY_CUTOFF_LIST);
        this.probabilityCutoffComboBox.setEditable(true);
        this.probabilityCutoffComboBox.setRenderer(new DoubleCellRenderer());
        this.probabilityCutoffComboBox.setPreferredSize(new Dimension(80, this.probabilityCutoffComboBox.getPreferredSize().height));
        this.userCacheCheckBox = new JCheckBox("Use cache file");
        this.userCacheCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.organismTextPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.cutoffSliderTextPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.missDistRatioSliderTextPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.probabilityCutoffComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.userCacheCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    public void updateValue(Set set, boolean bl, HClustCondition hClustCondition) {
        this.outgourpFlag = bl;
        int n = set.size();
        this.organismTextPanel.setMaximum(n);
        int n2 = String.valueOf(n).length() > 3 ? String.valueOf(n).length() : 3;
        this.organismTextPanel.setTextColumns(n2);
        boolean bl2 = HClustCondition.isServer(hClustCondition.getExecEnv());
        this.serverRadioButton.setSelected(bl2);
        this.localRadioButton.setSelected(!bl2);
        this.organismTextPanel.setLabelTable(n - 1);
        int n3 = hClustCondition.getMinExist();
        this.organismTextPanel.setValue(n3);
        this.cutoffSliderTextPanel.setValue(hClustCondition.getCutoff());
        int n4 = (int)(hClustCondition.getMissDistRatio() * 100.0);
        this.missDistRatioSliderTextPanel.setValue(n4);
        this.clusterRadioButton.setSelected(hClustCondition.isModeCluster());
        this.subClusterRadioButton.setSelected(hClustCondition.isModeSubCluster());
        this.probabilityCutoffComboBox.setSelectedItem(new Double(hClustCondition.getProbabilityCutoff()));
        AbstractInfoTitle abstractInfoTitle = hClustCondition.getInfoTitle();
        this.profilePanel.updateValue(set, abstractInfoTitle, hClustCondition.getTypeDistance());
        this.setProfileEnable();
        this.targetFilterClusterListCheckBox.setSelected(hClustCondition.isTargetFilteredClusterList());
        this.userCacheCheckBox.setSelected(hClustCondition.isUseCache());
        this.setOptionPanelStatus();
    }

    private boolean isLocal() {
        return this.localRadioButton.isSelected();
    }

    private boolean isServer() {
        return this.serverRadioButton.isSelected();
    }

    private boolean isCluster() {
        return this.clusterRadioButton.isSelected();
    }

    private boolean isSubCluster() {
        return this.subClusterRadioButton.isSelected();
    }

    private boolean isTargetFilteredClusterList() {
        return this.targetFilterClusterListCheckBox.isSelected();
    }

    private boolean isUseCache() {
        return this.userCacheCheckBox.isSelected();
    }

    private int getMinExist() {
        return (int)this.organismTextPanel.getValue();
    }

    private double getCutoff() {
        return this.cutoffSliderTextPanel.getValue();
    }

    private double getMissDistRatio() {
        return this.missDistRatioSliderTextPanel.getValue() / 100.0;
    }

    private double getProbabilibyCutoff() {
        return Double.parseDouble(String.valueOf(this.probabilityCutoffComboBox.getSelectedItem()));
    }

    public HClustCondition createHClustCondition() {
        HClustCondition hClustCondition = new HClustCondition();
        if (this.isServer()) {
            hClustCondition.setExecEnvServer();
            AccessServer accessServer = AccessServer.getInstance();
            hClustCondition.setExecServer(accessServer.getHost());
            hClustCondition.setExecPort(accessServer.getPort());
        } else {
            hClustCondition.setExecEnvLocal();
            hClustCondition.setExecServer("Local");
            hClustCondition.setExecPort(0);
        }
        hClustCondition.setMinExist(this.getMinExist());
        hClustCondition.setCutoff(this.getCutoff());
        hClustCondition.setMissDistRatio(this.getMissDistRatio());
        hClustCondition.setProbabilityCutoff(this.getProbabilibyCutoff());
        hClustCondition.setProfile(this.profilePanel.getProfile());
        hClustCondition.setTypeDistance(this.profilePanel.getDistType());
        hClustCondition.setInfoTitle(this.profilePanel.getInfoTitle());
        if (this.isCluster()) {
            hClustCondition.setModeCluster();
        } else {
            hClustCondition.setModeSubCluster();
        }
        hClustCondition.setTargetFilteredClusterList(this.isTargetFilteredClusterList());
        hClustCondition.setUseCache(this.isUseCache());
        hClustCondition.updateCalcOption(this.profilePanel.getInfoTitle());
        return hClustCondition;
    }

    protected boolean check() {
        if (this.getMissDistRatio() == 0.0) {
            MessageManager.showErrorMessage((Component)this, "Can't specify zero on Miss Dist Ratio.");
            return false;
        }
        try {
            Double.parseDouble(String.valueOf(this.probabilityCutoffComboBox.getSelectedItem()));
        }
        catch (NumberFormatException numberFormatException) {
            MessageManager.showErrorMessage((Component)this, "Probability cutoff is invalid.");
            return false;
        }
        return super.check();
    }

    protected boolean apply() {
        return true;
    }

    private void showOption() {
        this.optionPanel.setVisible(!this.optionPanel.isVisible());
        if (this.optionPanel.isVisible()) {
            this.optionButton.setText("<< Parameters");
        } else {
            this.optionButton.setText(">> Parameters");
        }
        this.pack();
    }

    private void setOptionPanelStatus() {
        if (this.outgourpFlag) {
            this.clusterRadioButton.setEnabled(true);
            this.subClusterRadioButton.setEnabled(true);
        } else {
            this.clusterRadioButton.setEnabled(true);
            this.subClusterRadioButton.setEnabled(false);
            this.clusterRadioButton.setSelected(true);
        }
        this.pack();
    }

    private void setProfileEnable() {
        if (this.serverRadioButton.isSelected()) {
            this.profilePanel.setSelectPattern(true);
        }
        this.profilePanel.setEnabledGenePropButton(this.localRadioButton.isSelected());
        this.profilePanel.setEnabledInfoTitleComboBox();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.optionButton) {
            this.showOption();
        } else if (actionEvent.getSource() == this.localRadioButton) {
            this.setOptionPanelStatus();
            this.setProfileEnable();
        } else if (actionEvent.getSource() == this.serverRadioButton) {
            this.setOptionPanelStatus();
            this.setProfileEnable();
        }
    }

    static {
        PROBABILITY_CUTOFF_LIST = new Double[]{new Double(1.0E-4), new Double(5.0E-4), new Double(0.001), new Double(0.005), new Double(0.01), new Double(0.05), new Double(0.1), new Double(0.5), new Double(1.0)};
    }

    private class DoubleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private DecimalFormat df1 = new DecimalFormat();
        private DecimalFormat df2 = new DecimalFormat();

        public DoubleCellRenderer() {
            this.df1.applyPattern("0.###");
            this.df2.applyPattern("0.0#E0");
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            double d = (Double)object;
            if (d >= 0.001) {
                this.setText(this.df1.format(d));
            } else {
                this.setText(this.df2.format(d));
            }
            return this;
        }
    }
}

