/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.hcluster.AbstractHClustImporter;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ServerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OldHClustImporter
extends AbstractHClustImporter {
    private String treeString = "";
    private int dataRecordCount = 0;
    private List rootNodeList = new ArrayList();

    OldHClustImporter(String string) {
        super(string);
    }

    protected void parseDataLine(int n, String string) {
        if (this.isHeaderLine(string) && this.dataRecordCount != 0) {
            this.convertTreeStructure();
        } else if (!this.isHeaderLine(string)) {
            if (this.dataRecordCount != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.treeString);
                stringBuffer.append(string);
                String string2 = stringBuffer.toString();
                this.treeString = this.treeParser.createTreeStructure(string2, string2.length() - string.length());
            } else {
                this.treeString = string;
            }
            ++this.dataRecordCount;
        }
    }

    protected void afterProcess() {
        this.convertTreeStructure();
    }

    protected void parseHeaderLine(String string) {
    }

    protected void parseParameterLine(String string) {
        if (!ServerStatus.isParameter(string)) {
            this.setReadParameter(true);
            return;
        }
        if (ServerStatus.isStartData(string)) {
            this.setReadParameter(true);
            return;
        }
        this.setParameter(string);
    }

    private void convertTreeStructure() {
        this.treeParser.createTreeStructure(this.treeString, this.treeString.length());
        Node node = this.treeParser.getRootNode();
        this.rootNodeList.add(node);
        this.treeString = "";
        this.dataRecordCount = 0;
        this.treeParser.clearRootNode();
    }

    public void aggregateSamePattern(ClusterTbl clusterTbl, HClustCondition hClustCondition) {
        Map map = this.createClusterIdMap(clusterTbl, hClustCondition);
        for (ClusterNode clusterNode : this.rootNodeList) {
            this.setClusterInfo(clusterNode, map, hClustCondition);
            NodeUtil.aggregatePatternNode(clusterNode, null);
        }
    }

    private Map createClusterIdMap(ClusterTbl clusterTbl, HClustCondition hClustCondition) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (hClustCondition.isModeCluster()) {
            for (Cluster cluster : clusterTbl.getClusterList()) {
                String string = String.valueOf(cluster.getClusterId());
                ArrayList<Cluster> arrayList = (ArrayList<Cluster>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Cluster>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(cluster);
            }
        } else {
            for (Cluster cluster : clusterTbl.getClusterList()) {
                String string = cluster.getConbinedClusterId("_");
                hashMap.put(string, cluster);
            }
        }
        return hashMap;
    }

    private void setClusterInfo(ClusterNode clusterNode, Map map, HClustCondition hClustCondition) {
        List list = NodeUtil.getLeafNodeList(clusterNode);
        for (ClusterNode clusterNode2 : list) {
            Cluster cluster;
            Collection<String> collection;
            if (hClustCondition.isModeCluster()) {
                collection = (List)map.get(clusterNode2.getName());
                cluster = new SuperCluster();
                ((SuperCluster)cluster).setSubClusterList((List)collection);
            } else {
                cluster = (Cluster)map.get(clusterNode2.getName());
            }
            clusterNode2.setPatternMap(cluster.getPatternMap());
            collection = new HashSet();
            collection.add(clusterNode2.getName());
            clusterNode2.setClusterIdSet((Set)collection);
        }
    }

    public List getLeafNodeList() {
        return NodeUtil.getLeafNodeList(this.getRootNodeList());
    }

    public List getRootNodeList() {
        return this.rootNodeList;
    }
}

