/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster.tree;

import cgdp.recog.tree.Node;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClusterNode
extends Node {
    private Set clusterSet = new HashSet();
    private Set clusterIdSet = new HashSet();
    private Set viewClusterIdSet = new HashSet();
    private Map patternMap = new HashMap();
    private boolean aggregateMode = true;
    private boolean displayTree = true;

    public int getClusterCount() {
        return this.clusterSet.size();
    }

    public Set getClusterSet() {
        return this.clusterSet;
    }

    public void setClusterSet(Set set) {
        this.clusterSet = set;
    }

    public Set getClusterIdSet() {
        return this.clusterIdSet;
    }

    public void setClusterIdSet(Set set) {
        this.clusterIdSet = set;
    }

    public Set getViewClusterIdSet() {
        return this.viewClusterIdSet;
    }

    public void setViewClusterIdSet(Set set) {
        this.viewClusterIdSet = set;
    }

    public boolean isExistViewClusterId() {
        return CollectionUtil.isNull(this.getViewClusterIdSet());
    }

    public void setPatternMap(Map map) {
        this.patternMap = map;
    }

    public Map getPatternMap() {
        return this.patternMap;
    }

    public void setAggregateMode(boolean bl) {
        this.aggregateMode = bl;
        if (this.getNode1() != null) {
            ((ClusterNode)this.getNode1()).setAggregateMode(bl);
        }
        if (this.getNode2() != null) {
            ((ClusterNode)this.getNode2()).setAggregateMode(bl);
        }
    }

    public boolean isAggregateMode() {
        return this.aggregateMode;
    }

    public int getChildCount() {
        int n = 0;
        if (this.getNode1() != null) {
            n += this.getNode1().getChildCount();
        }
        if (this.getNode2() != null) {
            n += this.getNode2().getChildCount();
        }
        if (this.isLeaf()) {
            n = this.isAggregateMode() ? ++n : (n += this.getClusterCount());
        }
        return n;
    }

    public boolean isDisplayTree() {
        return this.displayTree;
    }

    public void setDisplayTree(boolean bl) {
        this.displayTree = bl;
    }

    public static ClusterNode createClusterNode(Node node) {
        ClusterNode clusterNode = new ClusterNode();
        clusterNode.setDist(node.getDist());
        clusterNode.setId(node.getId());
        clusterNode.setName(node.getName());
        clusterNode.setNode1(node.getNode1());
        clusterNode.setNode2(node.getNode2());
        clusterNode.setParent(node.getParent());
        return clusterNode;
    }

    public static ClusterNode createClusterNodeByClusterNode(ClusterNode clusterNode) {
        ClusterNode clusterNode2 = new ClusterNode();
        clusterNode2.copy(clusterNode);
        return clusterNode2;
    }

    public void copy(Node node) {
        super.copy(node);
        if (node instanceof ClusterNode) {
            ClusterNode clusterNode = (ClusterNode)node;
            this.setAggregateMode(clusterNode.isAggregateMode());
            if (!CollectionUtil.isNull(clusterNode.getClusterSet())) {
                this.setClusterSet(new HashSet(clusterNode.getClusterSet()));
            }
            this.setDisplayTree(clusterNode.isDisplayTree());
            if (!MapUtil.isNull(clusterNode.getPatternMap())) {
                this.setPatternMap(new HashMap(clusterNode.getPatternMap()));
            }
            if (!CollectionUtil.isNull(clusterNode.getClusterIdSet())) {
                this.setClusterIdSet(new HashSet(clusterNode.getClusterIdSet()));
            }
            if (!CollectionUtil.isNull(clusterNode.getViewClusterIdSet())) {
                this.setViewClusterIdSet(new HashSet(clusterNode.getViewClusterIdSet()));
            }
        }
    }

    public static void printClusterNode(ClusterNode clusterNode, int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        System.out.println(string + "vid=   " + clusterNode.getViewClusterIdSet());
        System.out.println(string + "Mdist= " + clusterNode.getMaxDist() + "  dist= " + clusterNode.getDist());
        System.out.println(string + "Disp=  " + clusterNode.isDisplayTree());
        System.out.println(string + "node1= " + clusterNode.getNode1());
        System.out.println(string + "node2= " + clusterNode.getNode2());
        if (clusterNode.getNode1() != null) {
            ClusterNode.printClusterNode((ClusterNode)clusterNode.getNode1(), n + 1);
        }
        if (clusterNode.getNode2() != null) {
            ClusterNode.printClusterNode((ClusterNode)clusterNode.getNode2(), n + 1);
        }
    }
}

