/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.ClusterMap;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.histogram.AbstractHistogramRenderer;
import cgdp.recog.histogram.HistogramContext;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FuncFrequencyRenderer
extends AbstractHistogramRenderer {
    private HistogramContext context = new HistogramContext();

    public void setContext(HistogramContext histogramContext) {
        this.context = histogramContext;
    }

    public HistogramContext getContext() {
        return this.context;
    }

    public void draw(Graphics2D graphics2D) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        graphics2D.setFont(this.context.getFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.context.getWidth(), this.context.getHeight());
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getBorderLineColorString());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = this.context.getViewOrderList();
        double d = this.context.calcIntervalY(list.size());
        double d2 = this.context.calcScaleX();
        double d3 = d < 1.0 ? 1.0 : d;
        double d4 = this.context.getOffsetTop();
        boolean bl = ClusterMap.isDrawLabel(d3, fontMetrics.getAscent() + fontMetrics.getDescent());
        for (int i = 0; i < list.size() && i < this.context.getRowCount(); ++i) {
            int n;
            int n2;
            int n3;
            String string;
            Map map = (Map)list.get(i + this.context.getStartRow());
            int n4 = i + this.context.getStartRow();
            ArrayList arrayList = this.context.getClusterList(map);
            arrayList = this.context.getClusterList(map) == null ? new ArrayList() : new ArrayList(arrayList);
            int n5 = ClusterUtil.getClusterComparatorType(this.context.isOutgroup());
            Collections.sort(arrayList, new ClusterComparator(n5));
            if (bl) {
                string = String.valueOf(this.context.getClusterSize(map));
                n3 = fontMetrics.stringWidth(string);
                n2 = this.context.getOffsetX() - 5 - n3;
                n = (int)(d4 + (d3 > 1.0 ? d3 - 1.0 : d3) / 2.0) + fontMetrics.getAscent() / 2;
                graphics2D.setColor(this.context.isSelectedRow(n4) ? Color.red : Color.black);
                graphics2D.drawString(string, n2, n);
            }
            string = "-1";
            n3 = 0;
            n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                Cluster cluster = (Cluster)arrayList.get(n);
                String string2 = ClusterUtil.getFunctionCategoryNo(cluster, this.context.isOutgroup());
                if (!string.equals(string2)) {
                    if (n2 == 0) {
                        string = string2;
                        n3 = n;
                        n2 = 1;
                        continue;
                    }
                    double d5 = (double)n3 * d2 + (double)this.context.getOffsetX();
                    double d6 = (double)n2 * d2;
                    d6 = d6 < 1.0 ? 1.0 : d6;
                    graphics2D.setColor(FunctionColorUtil.getFuncCatColor(string));
                    graphics2D.fill(new Rectangle2D.Double(d5, d4, d6, d3 > 1.0 ? d3 - 1.0 : d3));
                    n2 = 0;
                    --n;
                    continue;
                }
                ++n2;
            }
            if (n2 != 0) {
                double d7 = (double)n3 * d2 + (double)this.context.getOffsetX();
                double d8 = (double)n2 * d2;
                d8 = d8 < 1.0 ? 1.0 : d8;
                graphics2D.setColor(FunctionColorUtil.getFuncCatColor(string));
                graphics2D.fill(new Rectangle2D.Double(d7, d4, d8, d3));
            }
            if (optionValues.isBorderLineView()) {
                graphics2D.setColor(color);
                graphics2D.draw(new Line2D.Double(0.0, d4 + d3 - 1.0, this.context.getWidth() - 1, d4 + d3 - 1.0));
            }
            if (this.context.isSelectedRow(n4)) {
                double d9 = (double)arrayList.size() * d2;
                graphics2D.setColor(Color.black);
                graphics2D.draw(new Rectangle2D.Double(this.context.getOffsetX(), d4, d9, d3 > 1.0 ? d3 - 1.0 : d3));
            }
            d4 += d;
        }
    }
}

