/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.data.Cluster;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.histogram.HistogramContext;
import cgdp.recog.util.axis.TickUnitUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.List;

public class GeneValueHistogramContext
extends HistogramContext {
    private static final Font ORGANIAM_FONT = new Font("Times New Roman", 2, 12);
    private static final int DEFAULT_SPLIT_SCALE = 5;
    private static final int DEFAULT_SCALE_HEIGHT = 3;
    private static final int DEFAULT_LABEL_INTERVAL_Y = 15;
    private HistogramCondition condition;
    private double tickX;
    private double scaleMin;
    private double scaleMax;
    private int splitScale = 5;
    private int scaleHeight = 3;

    public void setCondition(HistogramCondition histogramCondition) {
        this.condition = histogramCondition;
    }

    public int getSplitScale() {
        return this.splitScale;
    }

    public void updateScaleStatus() {
        double d = Math.abs(this.condition.getMaxValue() - this.condition.getMinValue());
        double d2 = d / (double)this.getSplitScale();
        this.tickX = TickUnitUtil.getScaleUnit(d2);
        this.scaleMin = (int)Math.floor(this.condition.getMinValue());
        this.scaleMax = (int)Math.ceil(this.condition.getMaxValue());
    }

    public double getTickX() {
        return this.tickX;
    }

    public double getScaleMax() {
        return this.scaleMax;
    }

    public double getScaleMin() {
        return this.scaleMin;
    }

    public double getScaleRange() {
        return this.getScaleMax() - this.getScaleMin();
    }

    public double calcScaleX() {
        double d = (double)(this.getWidth() - this.getOffsetX() - 5) / this.getScaleRange();
        return d;
    }

    public double calcX(double d, double d2) {
        return (d2 - this.getScaleMin()) * d + (double)this.getOffsetX();
    }

    public List getValueOrganismCodeList() {
        return this.condition.getValueOrganismCodeList();
    }

    public String getValueOrganismCode() {
        return (String)this.condition.getValueOrganismCodeList().get(0);
    }

    public String getPrimaryOrganismCode() {
        return this.condition.getPrimaryOrganismCode();
    }

    public String getSecondaryOrganismCode() {
        return this.condition.getSecondaryOrganismCode();
    }

    boolean containsValue(Cluster cluster) {
        return this.condition.containsValue(cluster);
    }

    public double getValue(Cluster cluster) {
        return this.condition.getValue(cluster);
    }

    boolean containsValue(Cluster cluster, String string) {
        return this.condition.containsValue(cluster, string);
    }

    public double getValue(Cluster cluster, String string) {
        return this.condition.getValue(cluster, string);
    }

    public Color getPositiveColor() {
        return this.condition.getPositiveColor();
    }

    public Color getNegativeColor() {
        return this.condition.getNegativeColor();
    }

    public boolean isShowDataLabel() {
        return this.condition.isShowDataLable();
    }

    public boolean isValue() {
        return this.condition.isValue();
    }

    public boolean isDiff() {
        return this.condition.isDiff();
    }

    public int getScaleHeight() {
        return this.scaleHeight;
    }

    public int getScaleTitleStartY() {
        return this.getOffsetTop() + 15;
    }

    public int getOrganismTitleStartY() {
        return this.getOffsetTop() + 30;
    }

    public Font getOrganismFont() {
        return ORGANIAM_FONT;
    }

    public static GeneValueHistogramContext createCondition(HistogramCondition histogramCondition, HistogramContext histogramContext) {
        GeneValueHistogramContext geneValueHistogramContext = new GeneValueHistogramContext();
        geneValueHistogramContext.setCondition(histogramCondition);
        geneValueHistogramContext.copyHistogramContext(histogramContext);
        geneValueHistogramContext.updateScaleStatus();
        return geneValueHistogramContext;
    }

    public boolean isShowOrganism(String string) {
        return this.getClusterTbl().isShowOrganismCode(string);
    }
}

