/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleDeleteRequester;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class InfoDeleteRequestExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(InfoDeleteRequestExecuter.class);
    private Component parent;
    private Collection infoTitleC;
    private List unableDeleteTitleList = new ArrayList();

    public InfoDeleteRequestExecuter(Component component, Collection collection) {
        this.parent = component;
        this.infoTitleC = collection;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.infoTitleC.size());
        try {
            Iterator iterator = this.infoTitleC.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                AbstractInfoTitle abstractInfoTitle = (AbstractInfoTitle)iterator.next();
                InfoTitleDeleteRequester infoTitleDeleteRequester = this.createInfoDeleteRequester(abstractInfoTitle);
                try {
                    infoTitleDeleteRequester.execute();
                }
                catch (Exception exception) {
                    String string = "Fail to delete property. " + abstractInfoTitle.getName();
                    logger.warn(string, exception);
                    this.unableDeleteTitleList.add(abstractInfoTitle);
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to delete properties.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!CollectionUtil.isNull(this.unableDeleteTitleList)) {
            String[] stringArray = new String[]{"Fail to delete the follow properties.", InfoUtil.createInfoTitleNameString(this.unableDeleteTitleList)};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return;
        }
        if (this.getAfterRunnable() != null) {
            InfoDeleteAfterRunnable infoDeleteAfterRunnable = (InfoDeleteAfterRunnable)this.getAfterRunnable();
            infoDeleteAfterRunnable.setUnableDeleteTitleC(this.unableDeleteTitleList);
            SwingUtilities.invokeLater(infoDeleteAfterRunnable);
        }
    }

    protected abstract InfoTitleDeleteRequester createInfoDeleteRequester(AbstractInfoTitle var1) throws UnsupportedEncodingException;

    public static abstract class InfoDeleteAfterRunnable
    implements Runnable {
        private Collection unableDeleteTitleC;

        public void setUnableDeleteTitleC(Collection collection) {
            this.unableDeleteTitleC = collection;
        }

        public Collection getUnableDeleteTitleC() {
            return this.unableDeleteTitleC;
        }
    }
}

