/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTabPanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoEditDialog;
import cgdp.recog.info.InfoListDialog;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cell.CellInfoEditExecuter;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitleTableModel;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CellInfoTabPanel
extends AbstractInfoTabPanel
implements MouseListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JTable infoTable;

    public CellInfoTabPanel(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.infoTable = new JTable(new CellInfoTitleTableModel());
        this.infoTable.addMouseListener(this);
        TableColumnModel tableColumnModel = this.infoTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        this.infoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CellInfoTabPanel.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.infoTable, 20, 30);
        this.setShowAddButton(false);
        this.setDownloadButtonLabel("Show property on server...");
        this.setLayout(new GridBagLayout());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEnabledButton();
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        List list = CellInfoFacade.getInfoTitleList();
        CellInfoTitleTableModel cellInfoTitleTableModel = this.getCellInfoTitleTableModel();
        cellInfoTitleTableModel.setCellInfoTitleList(list);
    }

    protected void setEnabledButton(int n) {
        super.setEnabledButton(n);
        this.addButton.setEnabled(this.clusterTbl != null);
        if (n == -1) {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            CellInfoTitleTableModel cellInfoTitleTableModel = this.getCellInfoTitleTableModel();
            AbstractInfoTitle abstractInfoTitle = cellInfoTitleTableModel.getInfoTitle(n);
            this.deleteButton.setEnabled(abstractInfoTitle.isEditable());
            this.editButton.setEnabled(true);
        }
        this.downloadButton.setEnabled(false);
        this.uploadButton.setEnabled(false);
    }

    private CellInfoTitleTableModel getCellInfoTitleTableModel() {
        CellInfoTitleTableModel cellInfoTitleTableModel = (CellInfoTitleTableModel)this.infoTable.getModel();
        return cellInfoTitleTableModel;
    }

    private void setEnabledButton() {
        int n = this.infoTable.getSelectedRow();
        this.setEnabledButton(n);
    }

    protected void add() {
    }

    protected void delete() {
        int[] nArray = this.infoTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        CellInfoTitleTableModel cellInfoTitleTableModel = this.getCellInfoTitleTableModel();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            AbstractInfoTitle abstractInfoTitle = cellInfoTitleTableModel.getInfoTitle(nArray[i]);
            stringBuffer.append(abstractInfoTitle.getName());
            if (i == nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        Object[] objectArray = new String[]{"Delete the following cluster propeties?", stringBuffer.toString()};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            AbstractInfoTitle abstractInfoTitle = cellInfoTitleTableModel.getInfoTitle(nArray[i]);
            this.addDeleteInfoTitle(abstractInfoTitle);
        }
        cellInfoTitleTableModel.remove(nArray);
    }

    protected void edit() {
        int n = this.infoTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        CellInfoTitleTableModel cellInfoTitleTableModel = this.getCellInfoTitleTableModel();
        AbstractInfoTitle abstractInfoTitle = cellInfoTitleTableModel.getInfoTitle(n);
        List list = cellInfoTitleTableModel.getCellInfoTitleList();
        InfoEditDialog infoEditDialog = InfoListDialog.getInfoEditDialog();
        infoEditDialog.updateValue(abstractInfoTitle, list, this);
        infoEditDialog.setVisible(true);
    }

    protected void download() {
    }

    protected void upload() {
    }

    public boolean check() {
        return true;
    }

    protected void updateParameters() {
        if (CollectionUtil.isNull(this.newInfoTitleSet) && CollectionUtil.isNull(this.editInfoTitleSet) && CollectionUtil.isNull(this.deleteInfoTitleSet)) {
            return;
        }
        List list = this.getCellInfoTitleTableModel().getCellInfoTitleList();
        List list2 = InfoUtil.getLocalInfoTitleList(list);
        CellInfoEditExecuter cellInfoEditExecuter = new CellInfoEditExecuter(this, this.mediator, list2);
        cellInfoEditExecuter.execute(new DummyProgressComponent());
        cellInfoEditExecuter.done();
    }

    public void updateTable(AbstractInfoTitle abstractInfoTitle) {
        int n = this.getCellInfoTitleTableModel().indexOf(abstractInfoTitle);
        if (n == -1) {
            return;
        }
        this.getCellInfoTitleTableModel().fireTableRowsUpdated(n, n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.editButton.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

