/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoDownloader;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoRegister;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoDownloadExecuter.class);
    private Component parent;
    private Project project;
    private String domClustId;
    private Collection clusterInfoTitleC;
    private Map clusterInfoMap = new HashMap();
    private List registeredClusterInfoTitleList = new ArrayList();
    private Map subClusterInfoMap = new HashMap();
    private List registeredSubclusterInfoTitleList = new ArrayList();
    private Set unableDownloadInfoTitleSet = new HashSet();
    private boolean errorHandling = true;
    private boolean overwriteCheck = false;

    public ClusterInfoDownloadExecuter(Component component, Collection collection, String string, Project project) {
        this.parent = component;
        this.clusterInfoTitleC = collection;
        this.domClustId = string;
        this.project = project;
    }

    public void setErrorHandling(boolean bl) {
        this.errorHandling = bl;
    }

    public void setOverwriteCheck(boolean bl) {
        this.overwriteCheck = bl;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.clusterInfoTitleC.size());
        try {
            Iterator iterator = this.clusterInfoTitleC.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)iterator.next();
                try {
                    ClusterInfoDownloader clusterInfoDownloader = new ClusterInfoDownloader(clusterInfoTitle, this.domClustId, this.project);
                    clusterInfoDownloader.execute();
                    object = clusterInfoDownloader.getClusterInfoList();
                    int n = clusterInfoDownloader.getClusteInfoType();
                    if (ClusterInfoType.isCluster(n)) {
                        this.updateClusterInfoMap((List)object, this.clusterInfoMap);
                        this.registeredClusterInfoTitleList.add(clusterInfoTitle);
                        continue;
                    }
                    this.updateClusterInfoMap((List)object, this.subClusterInfoMap);
                    this.registeredSubclusterInfoTitleList.add(clusterInfoTitle);
                }
                catch (Exception exception) {
                    object = "Fail to load cluster property. " + clusterInfoTitle.getName();
                    logger.warn((String)object, exception);
                    this.unableDownloadInfoTitleSet.add(clusterInfoTitle);
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to save cluster properies.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void updateClusterInfoMap(List list, Map map) {
        for (ClusterInfo clusterInfo : list) {
            String string = (String)clusterInfo.getInfo(ClusterInfoTitle.TITLE_ID);
            ClusterInfo clusterInfo2 = (ClusterInfo)map.get(string);
            if (clusterInfo2 == null) {
                map.put(string, clusterInfo);
                continue;
            }
            clusterInfo2.putAllInfo(clusterInfo);
        }
    }

    public Set getUnableDownloadInfoTitleSet() {
        return this.unableDownloadInfoTitleSet;
    }

    public void done() {
        String[] stringArray;
        if (this.isCancel()) {
            return;
        }
        if (this.errorHandling) {
            if (this.isError()) {
                MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
                return;
            }
            if (!CollectionUtil.isNull(this.unableDownloadInfoTitleSet)) {
                stringArray = new String[]{"The following cluster property was not able to be downloaded.", InfoUtil.createInfoTitleNameString(this.unableDownloadInfoTitleSet)};
                MessageManager.showWarningMessage(this.parent, stringArray);
            }
        }
        try {
            if (!(CollectionUtil.isNull(this.registeredClusterInfoTitleList) || this.overwriteCheck && !ClusterInfoFacade.validateInfoTitle(this.parent, this.registeredClusterInfoTitleList))) {
                this.registerClusterInfo();
            }
            if (!(CollectionUtil.isNull(this.registeredSubclusterInfoTitleList) || this.overwriteCheck && !ClusterInfoFacade.validateInfoTitle(this.parent, this.registeredSubclusterInfoTitleList))) {
                this.registerSubClusterInfo();
            }
        }
        catch (Exception exception) {
            String string = "Fail to save cluster properties.";
            logger.warn(string, exception);
            MessageManager.showWarningMessage(this.parent, string);
        }
        stringArray = this.getAfterRunnable();
        if (stringArray != null) {
            stringArray.run();
        }
    }

    private void registerClusterInfo() throws Exception {
        ArrayList arrayList = new ArrayList(this.clusterInfoMap.values());
        if (!CollectionUtil.isNull(arrayList) && !CollectionUtil.isNull(this.registeredClusterInfoTitleList)) {
            this.registeredClusterInfoTitleList.add(0, ClusterInfoTitle.TITLE_ID);
            this.registeredClusterInfoTitleList.removeAll(this.unableDownloadInfoTitleSet);
            ClusterInfoRegister.margeLocalClusterInfo(this.domClustId, 3, this.registeredClusterInfoTitleList, this.clusterInfoMap);
            ClusterInfoRegister.exportClusterInfo(this.domClustId, 3, arrayList, this.registeredClusterInfoTitleList);
        }
    }

    private void registerSubClusterInfo() throws Exception {
        ArrayList arrayList = new ArrayList(this.subClusterInfoMap.values());
        if (!CollectionUtil.isNull(arrayList) && !CollectionUtil.isNull(this.registeredSubclusterInfoTitleList)) {
            this.registeredSubclusterInfoTitleList.add(0, ClusterInfoTitle.TITLE_ID);
            this.registeredSubclusterInfoTitleList.removeAll(this.unableDownloadInfoTitleSet);
            ClusterInfoRegister.margeLocalClusterInfo(this.domClustId, 4, this.registeredSubclusterInfoTitleList, this.subClusterInfoMap);
            ClusterInfoRegister.exportClusterInfo(this.domClustId, 4, arrayList, this.registeredSubclusterInfoTitleList);
        }
    }
}

