/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.Const;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoManager;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoConfExporter;
import cgdp.recog.info.gene.GeneInfoConfImporter;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class GeneInfoManager
extends AbstractInfoManager {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoManager.class);
    private static final GeneInfoManager GENE_INFO_MANAGER = new GeneInfoManager();
    private Map organismCodeLocusTagGeneInfoMap = new HashMap();

    private GeneInfoManager() {
    }

    public static GeneInfoManager getInstance() {
        return GENE_INFO_MANAGER;
    }

    public void clear() {
        this.organismCodeLocusTagGeneInfoMap = new HashMap();
        super.clear();
    }

    public Map getLocusTagInfoMap(String string) {
        Map map = (Map)this.organismCodeLocusTagGeneInfoMap.get(string);
        return map;
    }

    private void addGeneInfo(Map map, Collection collection) {
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            this.addGeneInfo(string, map2, collection);
        }
    }

    public void addGeneInfo(String string, Map map, Collection collection) {
        HashMap<String, GeneInfo> hashMap = (HashMap<String, GeneInfo>)this.organismCodeLocusTagGeneInfoMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, GeneInfo>(map);
            this.organismCodeLocusTagGeneInfoMap.put(string, map);
        } else {
            for (String string2 : map.keySet()) {
                GeneInfo geneInfo = (GeneInfo)map.get(string2);
                GeneInfo geneInfo2 = (GeneInfo)hashMap.get(string2);
                if (geneInfo2 == null) {
                    geneInfo2 = new GeneInfo();
                    hashMap.put(string2, geneInfo2);
                }
                geneInfo2.putAllInfo(geneInfo);
            }
        }
        this.addCachedInfoTitle(collection);
    }

    public Object getValue(String string, String string2, GeneInfoTitle geneInfoTitle) {
        Map map = (Map)this.organismCodeLocusTagGeneInfoMap.get(string);
        if (MapUtil.isNull(map)) {
            return null;
        }
        GeneInfo geneInfo = (GeneInfo)map.get(string2);
        if (geneInfo == null) {
            return null;
        }
        return geneInfo.getInfo(geneInfoTitle);
    }

    void registerNumDomain(List list) {
        Map map = this.getNumDomainMap(list);
        HashSet<GeneInfoTitle> hashSet = new HashSet<GeneInfoTitle>();
        hashSet.add(GeneInfoTitle.TITLE_NUM_DOMAIN);
        this.addGeneInfo(map, hashSet);
        this.addCachedInfoTitle(hashSet);
    }

    void registerScore(TaxMapModel taxMapModel) {
        this.registerScore(taxMapModel, GeneInfoTitle.TITLE_LOWER_SCORE);
        this.registerScore(taxMapModel, GeneInfoTitle.TITLE_LOWER_DIST);
        this.registerScore(taxMapModel, GeneInfoTitle.TITLE_UPPER_SCORE);
        this.registerScore(taxMapModel, GeneInfoTitle.TITLE_UPPER_DIST);
    }

    void registerScore(TaxMapModel taxMapModel, GeneInfoTitle geneInfoTitle) {
        Map map = this.getScoreMap(taxMapModel, geneInfoTitle, geneInfoTitle.getKey());
        HashSet<GeneInfoTitle> hashSet = new HashSet<GeneInfoTitle>();
        hashSet.add(geneInfoTitle);
        this.addGeneInfo(map, hashSet);
        this.addCachedInfoTitle(hashSet);
    }

    private Map getScoreMap(TaxMapModel taxMapModel, GeneInfoTitle geneInfoTitle, String string) {
        HashMap hashMap = new HashMap();
        List list = taxMapModel.getTaxMapInfoList();
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            GeneInfo geneInfo;
            TaxMapInfo taxMapInfo = (TaxMapInfo)list.get(i);
            String string3 = taxMapInfo.getOrganismCode();
            HashMap<String, GeneInfo> hashMap2 = (HashMap<String, GeneInfo>)hashMap.get(string3);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, GeneInfo>();
                hashMap.put(string3, hashMap2);
            }
            if ((geneInfo = (GeneInfo)hashMap2.get(string2 = taxMapInfo.getLocusTag())) == null) {
                geneInfo = new GeneInfo();
                hashMap2.put(string2, geneInfo);
            }
            if (string.compareTo("lower_score") == 0) {
                geneInfo.putInfo(geneInfoTitle, new Float(taxMapInfo.getLowerScore()));
                continue;
            }
            if (string.compareTo("lower_dist") == 0) {
                geneInfo.putInfo(geneInfoTitle, new Float(taxMapInfo.getLowerDist()));
                continue;
            }
            if (string.compareTo("upper_score") == 0) {
                if (taxMapInfo.getUpperName() == null) continue;
                geneInfo.putInfo(geneInfoTitle, new Float(taxMapInfo.getUpperScore()));
                continue;
            }
            if (string.compareTo("upper_dist") != 0 || taxMapInfo.getUpperName() == null) continue;
            geneInfo.putInfo(geneInfoTitle, new Float(taxMapInfo.getUpperDist()));
        }
        return hashMap;
    }

    private List createValueList(List list, Map map) {
        ArrayList arrayList = new ArrayList();
        for (TaxMapInfo taxMapInfo : list) {
            String string = taxMapInfo.getOrganismCode();
            String string2 = taxMapInfo.getLocusTag();
        }
        return arrayList;
    }

    private Map getNumDomainMap(List list) {
        HashMap hashMap = new HashMap();
        for (Cluster cluster : list) {
            for (String string : cluster.getSpSet()) {
                List list2 = cluster.getLocusTagList(string);
                for (String string2 : list2) {
                    String string3;
                    GeneInfo geneInfo;
                    if (!GeneUtil.isDomain(string2)) continue;
                    int n = GeneUtil.getDomainNo(string2);
                    HashMap<String, GeneInfo> hashMap2 = (HashMap<String, GeneInfo>)hashMap.get(string);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<String, GeneInfo>();
                        hashMap.put(string, hashMap2);
                    }
                    if ((geneInfo = (GeneInfo)hashMap2.get(string3 = GeneUtil.removeDomainNo(string2))) == null) {
                        geneInfo = new GeneInfo();
                        geneInfo.putInfo(GeneInfoTitle.TITLE_NUM_DOMAIN, new Float(n));
                        hashMap2.put(string3, geneInfo);
                        continue;
                    }
                    int n2 = ((Float)geneInfo.getInfo(GeneInfoTitle.TITLE_NUM_DOMAIN)).intValue();
                    n = Math.max(n2, n);
                    geneInfo.putInfo(GeneInfoTitle.TITLE_NUM_DOMAIN, new Float(n));
                }
            }
        }
        return hashMap;
    }

    protected String getConfFilepath() {
        return Const.USER_GENE_INFO_PATH;
    }

    protected AbstractInfoConfImporter createInfoTitleImporter(String string) {
        GeneInfoConfImporter geneInfoConfImporter = new GeneInfoConfImporter(string);
        return geneInfoConfImporter;
    }

    protected FileExporter createInfoTitleExporter(List list) {
        GeneInfoConfExporter geneInfoConfExporter = new GeneInfoConfExporter(list);
        return geneInfoConfExporter;
    }

    public void removeCachedInfo(Collection collection) {
        for (String string : this.organismCodeLocusTagGeneInfoMap.keySet()) {
            Map map = (Map)this.organismCodeLocusTagGeneInfoMap.get(string);
            for (String string2 : map.keySet()) {
                GeneInfo geneInfo = (GeneInfo)map.get(string2);
                geneInfo.removeAllInfo(collection);
            }
        }
    }
}

