/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.auth.AuthFacade;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.URLList;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GeneInfoTitleListDownloader
extends AbstractServerResourceAccesser {
    private static final String DELIMITER = "\t";
    private Map geneInfoMap = new HashMap();

    public GeneInfoTitleListDownloader(Project project) {
        this.setProject(project);
        this.setContextPath(URLList.getInstance().getGetGenePropTitleList());
    }

    public void parseOutputStringData(int n, String string) {
        if (string.indexOf("prop_name") != -1) {
            return;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (vector.size() != 3) {
            return;
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        String string4 = (String)vector.get(2);
        String string5 = string2 + "(" + string3 + ")";
        GeneInfoTitle geneInfoTitle = (GeneInfoTitle)this.geneInfoMap.get(string2);
        if (geneInfoTitle == null) {
            geneInfoTitle = GeneInfoTitle.createGeneInfoTitle(string5, "Server");
            geneInfoTitle.setEditable(false);
            this.geneInfoMap.put(string2, geneInfoTitle);
        }
        geneInfoTitle.addOrganismCode(string4);
    }

    public List getGeneInfoTitleList() {
        ArrayList arrayList = new ArrayList(this.geneInfoMap.values());
        Collections.sort(arrayList, new InfoTitleComparator());
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            AuthFacade.setAuthenticator();
            Project project = Project.createDefaultProject();
            project.setDownloadServerUrl("http://bias.nibb.ac.jp:8043/");
            GeneInfoTitleListDownloader geneInfoTitleListDownloader = new GeneInfoTitleListDownloader(project);
            geneInfoTitleListDownloader.execute();
            List list = geneInfoTitleListDownloader.getGeneInfoTitleList();
            for (GeneInfoTitle geneInfoTitle : list) {
                System.out.println(geneInfoTitle.getName() + DELIMITER + geneInfoTitle.getTypeName() + DELIMITER + geneInfoTitle.getOrganismCodeString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

