/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoDeleteRequestExecuter;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUploader;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SimpleServerConnection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GeneInfoUploadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoUploadExecuter.class);
    private Component parent;
    private Collection geneInfoTitleC;
    private Set unableUploadInfoTitleSet = new HashSet();
    private boolean execDone = true;

    public GeneInfoUploadExecuter(Component component, Collection collection) {
        this.parent = component;
        this.geneInfoTitleC = collection;
    }

    public void setExecDone(boolean bl) {
        this.execDone = bl;
    }

    public void execute(ProgressImpl progressImpl) {
        Set set = this.getOrgnismCodeSet();
        progressImpl.setTotal(set.size() * this.geneInfoTitleC.size());
        for (GeneInfoTitle geneInfoTitle : this.geneInfoTitleC) {
            Object object2;
            String string = geneInfoTitle.getLocationName();
            ArrayList arrayList = new ArrayList();
            for (Object object2 : set) {
                Object object3;
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    this.deletePropertyFromServer(set);
                    return;
                }
                progressImpl.increment();
                if (!geneInfoTitle.containsOrganismCode((String)object2)) continue;
                try {
                    Map map;
                    if (LocationType.isNameGlobal(string)) {
                        map = GeneInfoFacade.getUserDefGeneInfoMap((String)object2);
                    } else {
                        object3 = ProjectAccesser.getProject(string);
                        map = GeneInfoFacade.getUserDefGeneInfoMap((Project)object3, (String)object2);
                    }
                    if (MapUtil.isNull(map)) continue;
                    object3 = new ArrayList(map.values());
                    this.setOrganismCode((Collection)object3, (String)object2);
                    arrayList.addAll(object3);
                }
                catch (Exception exception) {
                    object3 = "Fail to load gene property. sp=" + (String)object2 + " property=" + geneInfoTitle.getName();
                    logger.warn((String)object3, exception);
                }
            }
            if (CollectionUtil.isNull(arrayList)) continue;
            try {
                GeneInfoUploader geneInfoUploader = new GeneInfoUploader(geneInfoTitle, arrayList, "");
                geneInfoUploader.execute();
                if (geneInfoUploader.isErrorAlreadyExist()) {
                    if (!MessageManager.showConfirmMessage(this.parent, "Overwrite [" + geneInfoTitle.getName() + "] ?")) {
                        object2 = "Fail to upload gene property. property=" + geneInfoTitle.getName();
                        this.setError(geneInfoTitle, (String)object2);
                        continue;
                    }
                    object2 = new GeneInfoUploader(geneInfoTitle, arrayList, "replace");
                    ((SimpleServerConnection)object2).execute();
                    if (!((AbstractServerConnection)object2).isError()) continue;
                    this.setError(geneInfoTitle, ((AbstractServerConnection)object2).getMessage());
                    continue;
                }
                if (!geneInfoUploader.isError()) continue;
                this.setError(geneInfoTitle, geneInfoUploader.getMessage());
            }
            catch (Exception exception) {
                object2 = "Fail to upload gene property. property=" + geneInfoTitle.getName();
                this.setError(geneInfoTitle, (String)object2);
            }
        }
    }

    private void setError(AbstractInfoTitle abstractInfoTitle, String string) {
        String string2 = "Fail to upload gene property. property=" + abstractInfoTitle.getName();
        logger.warn(string2);
        this.unableUploadInfoTitleSet.add(abstractInfoTitle);
    }

    private void setOrganismCode(Collection collection, String string) {
        for (GeneInfo geneInfo : collection) {
            geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
        }
    }

    private void deletePropertyFromServer(Collection collection) {
        GeneInfoDeleteRequestExecuter geneInfoDeleteRequestExecuter = new GeneInfoDeleteRequestExecuter(this.parent, collection, this.getOrgnismCodeSet());
        geneInfoDeleteRequestExecuter.execute(new DummyProgressComponent());
    }

    private Set getOrgnismCodeSet() {
        HashSet hashSet = new HashSet();
        for (GeneInfoTitle geneInfoTitle : this.geneInfoTitleC) {
            hashSet.addAll(geneInfoTitle.getOrganismCodeSet());
        }
        return hashSet;
    }

    public Set getUnableUploadInfoTitleSet() {
        return this.unableUploadInfoTitleSet;
    }

    public void done() {
        String[] stringArray;
        if (!this.execDone) {
            return;
        }
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!CollectionUtil.isNull(this.unableUploadInfoTitleSet)) {
            stringArray = new String[]{"The following gene property was not able to be uploaded.", InfoUtil.createInfoTitleNameString(this.unableUploadInfoTitleSet)};
            MessageManager.showWarningMessage(this.parent, stringArray);
        }
        if ((stringArray = this.getAfterRunnable()) != null) {
            stringArray.run();
        }
    }
}

