/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AbstractServerInfoListDialog;
import cgdp.recog.info.InfoDeleteRequestExecuter;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.gene.GeneDownloadDialog;
import cgdp.recog.info.gene.GeneInfoDeleteRequestExecuter;
import cgdp.recog.info.gene.GeneInfoDownloadExecuter;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ServerGeneListDialog
extends AbstractServerInfoListDialog {
    private static final String TITLE = "Gene Property List";
    private Collection organismCodeC;

    private ServerGeneListDialog(Dialog dialog, MediatorImpl mediatorImpl, Collection collection) {
        super(dialog, mediatorImpl);
        this.organismCodeC = collection;
    }

    private ServerGeneListDialog(Frame frame, MediatorImpl mediatorImpl, Collection collection) {
        super(frame, mediatorImpl);
        this.organismCodeC = collection;
    }

    public static ServerGeneListDialog createInstance(Component component, MediatorImpl mediatorImpl, Collection collection) {
        ServerGeneListDialog serverGeneListDialog = null;
        if (component instanceof Dialog) {
            serverGeneListDialog = new ServerGeneListDialog((Dialog)component, mediatorImpl, collection);
        } else if (component instanceof Frame) {
            serverGeneListDialog = new ServerGeneListDialog((Frame)component, mediatorImpl, collection);
        }
        return serverGeneListDialog;
    }

    protected String getFrameTitle() {
        return TITLE;
    }

    protected void delete() {
        final List list = this.getSelectedInfoTitleList();
        Object[] objectArray = new String[]{"Delete the following properties?", InfoUtil.createInfoTitleNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        GeneInfoDeleteRequestExecuter geneInfoDeleteRequestExecuter = new GeneInfoDeleteRequestExecuter(this, list);
        geneInfoDeleteRequestExecuter.setAfterRunnable(new InfoDeleteRequestExecuter.InfoDeleteAfterRunnable(){

            public void run() {
                HashSet hashSet = new HashSet(list);
                hashSet.removeAll(this.getUnableDeleteTitleC());
                ServerGeneListDialog.this.getInfoTitleListTableModel().removeAll(hashSet);
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Delete gene property...", false, (ProcessImpl)geneInfoDeleteRequestExecuter);
    }

    protected boolean apply() {
        Object object2;
        List list = this.getSelectedInfoTitleList();
        GeneDownloadDialog geneDownloadDialog = new GeneDownloadDialog(this);
        Project project = ProjectAccesser.getSelectedProject();
        List list2 = InfoUtil.getInfoTitleNameList(list);
        geneDownloadDialog.updateValue(project.getProjectName(), list2);
        geneDownloadDialog.setVisible(true);
        if (geneDownloadDialog.isCanceled()) {
            return false;
        }
        String string = geneDownloadDialog.getLocationString();
        for (Object object2 : list) {
            ((AbstractInfoTitle)object2).setLocationName(string);
        }
        List list3 = GeneInfoFacade.getGeneInfoTitleList();
        if (!GeneInfoFacade.validateInfoTitle(this, list, list3)) {
            return false;
        }
        object2 = new GeneInfoDownloadExecuter(this, list, this.organismCodeC, project);
        ((GeneInfoDownloadExecuter)object2).setLocation(string);
        new ProgressDialog((Dialog)this, this.mediator, 1, "Download gene property...", false, (ProcessImpl)object2);
        return false;
    }
}

