/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.mapping.MapRecode;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import java.util.ArrayList;
import java.util.List;

class MapExporter
extends FileExporter {
    private static final String HEADER = "sp\tchrid\tcontigid\tseqno\tordno\tfrom1\tto1\tdir";
    private static final String DELIMITER = "\t";
    private String filepath;
    private List mapRecodeList = new ArrayList();

    public MapExporter(String string, List list) {
        this.filepath = string;
        this.mapRecodeList = list;
    }

    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        int n = 1;
        int n2 = Integer.MIN_VALUE;
        for (MapRecode mapRecode : this.mapRecodeList) {
            stringBuffer.append(mapRecode.getOrganismCode());
            stringBuffer.append(DELIMITER);
            int n3 = mapRecode.getChrId();
            if (n3 != n2) {
                n = 1;
            }
            if (!MapRecode.isNoValue(n3)) {
                stringBuffer.append(n3);
            }
            stringBuffer.append(DELIMITER);
            int n4 = mapRecode.getContigId();
            if (!MapRecode.isNoValue(n4)) {
                stringBuffer.append(n4);
            }
            stringBuffer.append(DELIMITER);
            stringBuffer.append(mapRecode.getSeqNo());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(n);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(mapRecode.getFrom());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(mapRecode.getTo());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(mapRecode.getDirection());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ++n;
            n2 = n3;
        }
        return stringBuffer.toString();
    }

    protected String getFilepath() {
        return this.filepath;
    }
}

