/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterIdTbl;
import cgdp.recog.funccat.FuncCatTable;
import cgdp.recog.mgmap.ClusterIdColorDialog;
import cgdp.recog.mgmap.ClusterIdTable;
import cgdp.recog.mgmap.PatternTable;
import cgdp.recog.mgmap.RGMCondition;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AlignmentListColorDialog
extends AbstractApplyDialog {
    private MediatorImpl mediator;
    private OptionTbl optionTbl = OptionTbl.getInstance();
    private JRadioButton functionCategoryButton;
    private JRadioButton clusterButton;
    private JRadioButton patternButton;
    private JRadioButton ppmButton;
    private JButton restoreButton;
    private JButton clusterIDButton;
    private FuncCatTable funcCatTable;
    private ClusterIdTable clusterIdTable;
    private PatternTable patternTable;
    private RGMCondition rgmCondition;

    public AlignmentListColorDialog(Frame frame, MediatorImpl mediatorImpl, RGMCondition rGMCondition) {
        super(frame);
        this.mediator = mediatorImpl;
        this.rgmCondition = rGMCondition;
        this.createComponent();
    }

    private void createComponent() {
        this.setTitle("Color Setting");
        this.setModal(true);
        this.setResizable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.functionCategoryButton = new JRadioButton("Function Category");
        this.clusterButton = new JRadioButton("Cluster ID");
        this.patternButton = new JRadioButton("Pattern");
        this.ppmButton = new JRadioButton("Use the color of the control tree");
        buttonGroup.add(this.functionCategoryButton);
        buttonGroup.add(this.clusterButton);
        buttonGroup.add(this.patternButton);
        buttonGroup.add(this.ppmButton);
        this.funcCatTable = new FuncCatTable(this.mediator);
        this.clusterIdTable = new ClusterIdTable(this.mediator);
        this.patternTable = new PatternTable(this.mediator);
        this.clusterIDButton = new JButton("Create Color");
        this.clusterIDButton.addActionListener(this);
        this.restoreButton = new JButton("Restore");
        this.restoreButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.applyButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.restoreButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.functionCategoryButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.clusterButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.patternButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.funcCatTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.clusterIdTable, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.patternTable, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.ppmButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.clusterIDButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.updateValue();
    }

    private void updateValue() {
        if (this.rgmCondition.isFuncCatColor()) {
            this.functionCategoryButton.setSelected(true);
        } else if (this.rgmCondition.isClusterIDColor()) {
            this.clusterButton.setSelected(true);
        } else if (this.rgmCondition.isPPMColor()) {
            this.ppmButton.setSelected(true);
        } else {
            this.patternButton.setSelected(true);
        }
    }

    private String getFunctionCategoryType() {
        return this.funcCatTable.getSelectedFunctionCategoryType();
    }

    private List getFunctionCategoryList() {
        return this.funcCatTable.getFunctionCategoryList();
    }

    private List getClusterIdColorList() {
        return this.clusterIdTable.getClusterIdColorList();
    }

    private List getPatternList() {
        return this.patternTable.getPatternList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClusterID() {
        ClusterIdColorDialog clusterIdColorDialog = new ClusterIdColorDialog(this);
        clusterIdColorDialog.setVisible(true);
        if (!clusterIdColorDialog.isCanceled()) {
            try {
                int n = clusterIdColorDialog.getClusterFrom();
                int n2 = clusterIdColorDialog.getClusterTo();
                int n3 = clusterIdColorDialog.getClusterCount();
                ClusterIdTbl clusterIdTbl = ClusterIdTbl.getInstance();
                ArrayList arrayList = clusterIdTbl.createClusterIdColor(n, n2, n3);
                this.clusterIdTable.setClusterIdColor(arrayList);
                this.optionTbl.getOptionValues().setClusterFrom(ColorUtil.color2Str(new Color(n)));
                this.optionTbl.getOptionValues().setClusterTo(ColorUtil.color2Str(new Color(n2)));
                this.optionTbl.getOptionValues().setClusterCount(n3);
            }
            catch (Exception exception) {
                MessageManager.showErrorMessage((Component)this, exception.getMessage());
            }
            finally {
                clusterIdColorDialog.dispose();
            }
        }
    }

    private void restore() {
        String string = this.getFunctionCategoryType();
        this.mediator.restoreFunctionCategoryColor(string);
        this.funcCatTable.restoreFuncCatColor();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.clusterIDButton) {
            this.registerClusterID();
        } else if (actionEvent.getSource() == this.restoreButton) {
            this.restore();
        }
    }

    protected boolean apply() {
        this.rgmCondition.setColorType(this.getColorType());
        this.mediator.applyAlignmentListColor(this.rgmCondition, this.getFunctionCategoryType(), this.getFunctionCategoryList(), this.getClusterIdColorList(), this.getPatternList());
        return true;
    }

    public int getColorType() {
        if (this.functionCategoryButton.isSelected()) {
            return 0;
        }
        if (this.clusterButton.isSelected()) {
            return 1;
        }
        if (this.ppmButton.isSelected()) {
            return 3;
        }
        return 2;
    }
}

